/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle160.crypto.KeyGenerationParameters;
import org.bouncycastle160.crypto.engines.DESedeEngine;
import org.bouncycastle160.crypto.engines.DESedeWrapEngine;
import org.bouncycastle160.crypto.generators.DESedeKeyGenerator;
import org.bouncycastle160.crypto.params.DESedeParameters;
import org.bouncycastle160.crypto.params.KeyParameter;
import org.bouncycastle160.crypto.params.ParametersWithIV;
import org.bouncycastle160.crypto.test.BlockCipherVectorTest;
import org.bouncycastle160.crypto.test.CipherTest;
import org.bouncycastle160.util.encoders.Hex;
import org.bouncycastle160.util.test.SimpleTest;

public class DESedeTest
extends CipherTest {
    private static byte[] weakKey = new byte[]{6, 1, 1, 1, 1, 1, 1, 1, 31, 31, 31, 31, 14, 14, 14, 14, -32, -32, -32, -32, -15, -15, -15, -15};
    static String input1 = "4e6f77206973207468652074696d6520666f7220616c6c20";
    static String input2 = "4e6f7720697320746865";
    static SimpleTest[] tests = new SimpleTest[]{new BlockCipherVectorTest(0, new DESedeEngine(), new DESedeParameters(Hex.decode("0123456789abcdef0123456789abcdef")), input1, "3fa40e8a984d48156a271787ab8883f9893d51ec4b563b53"), new BlockCipherVectorTest(1, new DESedeEngine(), new DESedeParameters(Hex.decode("0123456789abcdeffedcba9876543210")), input1, "d80a0d8b2bae5e4e6a0094171abcfc2775d2235a706e232c"), new BlockCipherVectorTest(2, new DESedeEngine(), new DESedeParameters(Hex.decode("0123456789abcdef0123456789abcdef0123456789abcdef")), input1, "3fa40e8a984d48156a271787ab8883f9893d51ec4b563b53"), new BlockCipherVectorTest(3, new DESedeEngine(), new DESedeParameters(Hex.decode("0123456789abcdeffedcba98765432100123456789abcdef")), input1, "d80a0d8b2bae5e4e6a0094171abcfc2775d2235a706e232c")};

    DESedeTest() {
        super(tests, new DESedeEngine(), new KeyParameter(new byte[16]));
    }

    private void wrapTest(int id, byte[] kek, byte[] iv, byte[] in, byte[] out) {
        DESedeWrapEngine wrapper = new DESedeWrapEngine();
        wrapper.init(true, new ParametersWithIV(new KeyParameter(kek), iv));
        try {
            byte[] cText = wrapper.wrap(in, 0, in.length);
            if (!this.areEqual(cText, out)) {
                this.fail(": failed wrap test " + id + " expected " + new String(Hex.encode(out)) + " got " + new String(Hex.encode(cText)));
            }
        }
        catch (Exception e) {
            this.fail("failed wrap test exception: " + e.toString(), e);
        }
        wrapper.init(false, new KeyParameter(kek));
        try {
            byte[] pText = wrapper.unwrap(out, 0, out.length);
            if (!this.areEqual(pText, in)) {
                this.fail("failed unwrap test " + id + " expected " + new String(Hex.encode(in)) + " got " + new String(Hex.encode(pText)));
            }
        }
        catch (Exception e) {
            this.fail("failed unwrap test exception: " + e.toString(), e);
        }
    }

    @Override
    public void performTest() throws Exception {
        block9: {
            block8: {
                super.performTest();
                byte[] kek1 = Hex.decode("255e0d1c07b646dfb3134cc843ba8aa71f025b7c0838251f");
                byte[] iv1 = Hex.decode("5dd4cbfc96f5453b");
                byte[] in1 = Hex.decode("2923bf85e06dd6ae529149f1f1bae9eab3a7da3d860d3e98");
                byte[] out1 = Hex.decode("690107618ef092b3b48ca1796b234ae9fa33ebb4159604037db5d6a84eb3aac2768c632775a467d4");
                this.wrapTest(1, kek1, iv1, in1, out1);
                SecureRandom random = new SecureRandom();
                DESedeKeyGenerator keyGen = new DESedeKeyGenerator();
                keyGen.init(new KeyGenerationParameters(random, 112));
                byte[] kB = keyGen.generateKey();
                if (kB.length != 16) {
                    this.fail("112 bit key wrong length.");
                }
                keyGen.init(new KeyGenerationParameters(random, 168));
                kB = keyGen.generateKey();
                if (kB.length != 24) {
                    this.fail("168 bit key wrong length.");
                }
                try {
                    keyGen.init(new KeyGenerationParameters(random, 200));
                    this.fail("invalid key length not detected.");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                try {
                    DESedeParameters.isWeakKey(new byte[4], 0);
                    this.fail("no exception on small key");
                }
                catch (IllegalArgumentException e) {
                    if (e.getMessage().equals("key material too short.")) break block8;
                    this.fail("wrong exception");
                }
            }
            try {
                new DESedeParameters(weakKey);
                this.fail("no exception on weak key");
            }
            catch (IllegalArgumentException e) {
                if (e.getMessage().equals("attempt to create weak DESede key")) break block9;
                this.fail("wrong exception");
            }
        }
    }

    @Override
    public String getName() {
        return "DESede";
    }

    public static void main(String[] args) {
        DESedeTest.runTest(new DESedeTest());
    }
}

