/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.crypto.test;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle160.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle160.crypto.generators.DHKeyPairGenerator;
import org.bouncycastle160.crypto.generators.ElGamalKeyPairGenerator;
import org.bouncycastle160.crypto.params.DHKeyGenerationParameters;
import org.bouncycastle160.crypto.params.DHParameters;
import org.bouncycastle160.crypto.params.DHPrivateKeyParameters;
import org.bouncycastle160.crypto.params.DHPublicKeyParameters;
import org.bouncycastle160.crypto.params.DHValidationParameters;
import org.bouncycastle160.crypto.params.DSAParameters;
import org.bouncycastle160.crypto.params.DSAValidationParameters;
import org.bouncycastle160.crypto.params.ElGamalKeyGenerationParameters;
import org.bouncycastle160.crypto.params.ElGamalParameters;
import org.bouncycastle160.crypto.params.ElGamalPrivateKeyParameters;
import org.bouncycastle160.crypto.params.ElGamalPublicKeyParameters;
import org.bouncycastle160.crypto.params.GOST3410Parameters;
import org.bouncycastle160.crypto.params.GOST3410ValidationParameters;
import org.bouncycastle160.crypto.test.DHTestKeyParameters;
import org.bouncycastle160.crypto.test.ElGamalTestKeyParameters;
import org.bouncycastle160.util.test.SimpleTest;

public class EqualsHashCodeTest
extends SimpleTest {
    private static Object OTHER = new Object();

    @Override
    public String getName() {
        return "EqualsHashCode";
    }

    private void doTest(Object a, Object equalsA, Object notEqualsA) {
        if (a.equals(null)) {
            this.fail("a equaled null");
        }
        if (!a.equals(equalsA) || !equalsA.equals(a)) {
            this.fail("equality failed");
        }
        if (a.equals(OTHER)) {
            this.fail("other inequality failed");
        }
        if (a.equals(notEqualsA) || notEqualsA.equals(a)) {
            this.fail("inequality failed");
        }
        if (a.hashCode() != equalsA.hashCode()) {
            this.fail("hashCode equality failed");
        }
    }

    private void dhTest() {
        BigInteger g512 = new BigInteger("153d5d6172adb43045b68ae8e1de1070b6137005686d29d3d73a7749199681ee5b212c9b96bfdcfa5b20cd5e3fd2044895d609cf9b410b7a0f12ca1cb9a428cc", 16);
        BigInteger p512 = new BigInteger("9494fec095f3b85ee286542b3836fc81a5dd0a0349b4c239dd38744d488cf8e31db8bcb7d33b41abb9e5a33cca9144b1cef332c94bf0573bf047a3aca98cdf3b", 16);
        DHParameters dhParams = new DHParameters(p512, g512);
        DHKeyGenerationParameters params = new DHKeyGenerationParameters(new SecureRandom(), dhParams);
        DHKeyPairGenerator kpGen = new DHKeyPairGenerator();
        kpGen.init(params);
        AsymmetricCipherKeyPair pair = kpGen.generateKeyPair();
        DHPublicKeyParameters pu1 = (DHPublicKeyParameters)pair.getPublic();
        DHPrivateKeyParameters pv1 = (DHPrivateKeyParameters)pair.getPrivate();
        DHPublicKeyParameters pu2 = new DHPublicKeyParameters(pu1.getY(), pu1.getParameters());
        DHPrivateKeyParameters pv2 = new DHPrivateKeyParameters(pv1.getX(), pv1.getParameters());
        DHPublicKeyParameters pu3 = new DHPublicKeyParameters(pv1.getX(), pu1.getParameters());
        DHPrivateKeyParameters pv3 = new DHPrivateKeyParameters(pu1.getY(), pu1.getParameters());
        this.doTest(pu1, pu2, pu3);
        this.doTest(pv1, pv2, pv3);
        DHParameters pr1 = pu1.getParameters();
        DHParameters pr2 = new DHParameters(pr1.getP(), pr1.getG(), pr1.getQ(), pr1.getM(), pr1.getL(), pr1.getJ(), pr1.getValidationParameters());
        DHParameters pr3 = new DHParameters(pr1.getG(), pr1.getP(), pr1.getQ(), pr1.getM(), pr1.getL(), pr1.getJ(), pr1.getValidationParameters());
        this.doTest(pr1, pr2, pr3);
        pr3 = new DHParameters(pr1.getG(), pr1.getP(), null, pr1.getM(), pr1.getL(), pr1.getJ(), pr1.getValidationParameters());
        this.doTest(pr1, pr2, pr3);
        pu2 = new DHPublicKeyParameters(pu1.getY(), pr2);
        pv2 = new DHPrivateKeyParameters(pv1.getX(), pr2);
        this.doTest(pu1, pu2, pu3);
        this.doTest(pv1, pv2, pv3);
        DHValidationParameters vp1 = new DHValidationParameters(new byte[20], 1024);
        DHValidationParameters vp2 = new DHValidationParameters(new byte[20], 1024);
        DHValidationParameters vp3 = new DHValidationParameters(new byte[24], 1024);
        this.doTest(vp1, vp1, vp3);
        this.doTest(vp1, vp2, vp3);
        byte[] bytes = new byte[20];
        bytes[0] = 1;
        vp3 = new DHValidationParameters(bytes, 1024);
        this.doTest(vp1, vp2, vp3);
        vp3 = new DHValidationParameters(new byte[20], 2048);
        this.doTest(vp1, vp2, vp3);
        DHTestKeyParameters k1 = new DHTestKeyParameters(false, null);
        DHTestKeyParameters k2 = new DHTestKeyParameters(false, null);
        DHTestKeyParameters k3 = new DHTestKeyParameters(false, pu1.getParameters());
        this.doTest(k1, k2, k3);
    }

    private void elGamalTest() {
        BigInteger g512 = new BigInteger("153d5d6172adb43045b68ae8e1de1070b6137005686d29d3d73a7749199681ee5b212c9b96bfdcfa5b20cd5e3fd2044895d609cf9b410b7a0f12ca1cb9a428cc", 16);
        BigInteger p512 = new BigInteger("9494fec095f3b85ee286542b3836fc81a5dd0a0349b4c239dd38744d488cf8e31db8bcb7d33b41abb9e5a33cca9144b1cef332c94bf0573bf047a3aca98cdf3b", 16);
        ElGamalParameters dhParams = new ElGamalParameters(p512, g512);
        ElGamalKeyGenerationParameters params = new ElGamalKeyGenerationParameters(new SecureRandom(), dhParams);
        ElGamalKeyPairGenerator kpGen = new ElGamalKeyPairGenerator();
        kpGen.init(params);
        AsymmetricCipherKeyPair pair = kpGen.generateKeyPair();
        ElGamalPublicKeyParameters pu1 = (ElGamalPublicKeyParameters)pair.getPublic();
        ElGamalPrivateKeyParameters pv1 = (ElGamalPrivateKeyParameters)pair.getPrivate();
        ElGamalPublicKeyParameters pu2 = new ElGamalPublicKeyParameters(pu1.getY(), pu1.getParameters());
        ElGamalPrivateKeyParameters pv2 = new ElGamalPrivateKeyParameters(pv1.getX(), pv1.getParameters());
        ElGamalPublicKeyParameters pu3 = new ElGamalPublicKeyParameters(pv1.getX(), pu1.getParameters());
        ElGamalPrivateKeyParameters pv3 = new ElGamalPrivateKeyParameters(pu1.getY(), pu1.getParameters());
        this.doTest(pu1, pu2, pu3);
        this.doTest(pv1, pv2, pv3);
        ElGamalParameters pr1 = pu1.getParameters();
        ElGamalParameters pr2 = new ElGamalParameters(pr1.getP(), pr1.getG());
        ElGamalParameters pr3 = new ElGamalParameters(pr1.getG(), pr1.getP());
        this.doTest(pr1, pr2, pr3);
        pu2 = new ElGamalPublicKeyParameters(pu1.getY(), pr2);
        pv2 = new ElGamalPrivateKeyParameters(pv1.getX(), pr2);
        this.doTest(pu1, pu2, pu3);
        this.doTest(pv1, pv2, pv3);
        ElGamalTestKeyParameters k1 = new ElGamalTestKeyParameters(false, null);
        ElGamalTestKeyParameters k2 = new ElGamalTestKeyParameters(false, null);
        ElGamalTestKeyParameters k3 = new ElGamalTestKeyParameters(false, pu1.getParameters());
        this.doTest(k1, k2, k3);
    }

    private void dsaTest() {
        BigInteger a = BigInteger.valueOf(1L);
        BigInteger b = BigInteger.valueOf(2L);
        BigInteger c = BigInteger.valueOf(3L);
        DSAParameters dsaP1 = new DSAParameters(a, b, c);
        DSAParameters dsaP2 = new DSAParameters(a, b, c);
        DSAParameters dsaP3 = new DSAParameters(b, c, a);
        this.doTest(dsaP1, dsaP2, dsaP3);
        DSAValidationParameters vp1 = new DSAValidationParameters(new byte[20], 1024);
        DSAValidationParameters vp2 = new DSAValidationParameters(new byte[20], 1024);
        DSAValidationParameters vp3 = new DSAValidationParameters(new byte[24], 1024);
        this.doTest(vp1, vp1, vp3);
        this.doTest(vp1, vp2, vp3);
        byte[] bytes = new byte[20];
        bytes[0] = 1;
        vp3 = new DSAValidationParameters(bytes, 1024);
        this.doTest(vp1, vp2, vp3);
        vp3 = new DSAValidationParameters(new byte[20], 2048);
        this.doTest(vp1, vp2, vp3);
    }

    private void gost3410Test() {
        BigInteger a = BigInteger.valueOf(1L);
        BigInteger b = BigInteger.valueOf(2L);
        BigInteger c = BigInteger.valueOf(3L);
        GOST3410Parameters g1 = new GOST3410Parameters(a, b, c);
        GOST3410Parameters g2 = new GOST3410Parameters(a, b, c);
        GOST3410Parameters g3 = new GOST3410Parameters(a, c, c);
        this.doTest(g1, g2, g3);
        GOST3410ValidationParameters v1 = new GOST3410ValidationParameters(100, 1);
        GOST3410ValidationParameters v2 = new GOST3410ValidationParameters(100, 1);
        GOST3410ValidationParameters v3 = new GOST3410ValidationParameters(101, 1);
        this.doTest(v1, v2, v3);
        v3 = new GOST3410ValidationParameters(100, 2);
        this.doTest(v1, v2, v3);
        v1 = new GOST3410ValidationParameters(100L, 1L);
        v2 = new GOST3410ValidationParameters(100L, 1L);
        v3 = new GOST3410ValidationParameters(101L, 1L);
        this.doTest(v1, v2, v3);
        v3 = new GOST3410ValidationParameters(100L, 2L);
        this.doTest(v1, v2, v3);
    }

    @Override
    public void performTest() throws Exception {
        this.dhTest();
        this.elGamalTest();
        this.gost3410Test();
        this.dsaTest();
    }

    public static void main(String[] args) {
        EqualsHashCodeTest.runTest(new EqualsHashCodeTest());
    }
}

