/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.crypto.test;

import org.bouncycastle160.crypto.BufferedBlockCipher;
import org.bouncycastle160.crypto.CipherParameters;
import org.bouncycastle160.crypto.CryptoException;
import org.bouncycastle160.crypto.digests.GOST3411Digest;
import org.bouncycastle160.crypto.engines.GOST28147Engine;
import org.bouncycastle160.crypto.modes.CBCBlockCipher;
import org.bouncycastle160.crypto.modes.CFBBlockCipher;
import org.bouncycastle160.crypto.modes.GOFBBlockCipher;
import org.bouncycastle160.crypto.params.KeyParameter;
import org.bouncycastle160.crypto.params.ParametersWithIV;
import org.bouncycastle160.crypto.params.ParametersWithSBox;
import org.bouncycastle160.crypto.test.BlockCipherVectorTest;
import org.bouncycastle160.crypto.test.CipherTest;
import org.bouncycastle160.util.encoders.Hex;
import org.bouncycastle160.util.test.SimpleTest;

public class GOST28147Test
extends CipherTest {
    static String input1 = "0000000000000000";
    static String output1 = "1b0bbc32cebcab42";
    static String input2 = "bc350e71aac5f5c2";
    static String output2 = "d35ab653493b49f5";
    static String input3 = "bc350e71aa11345709acde";
    static String output3 = "8824c124c4fd14301fb1e8";
    static String input4 = "000102030405060708090a0b0c0d0e0fff0102030405060708090a0b0c0d0e0f";
    static String output4 = "29b7083e0a6d955ca0ec5b04fdb4ea41949f1dd2efdf17baffc1780b031f3934";
    static byte[] TestSBox = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0};
    static byte[] TestSBox_1 = new byte[]{14, 3, 12, 13, 1, 15, 10, 9, 11, 6, 2, 7, 5, 0, 8, 4, 13, 9, 0, 4, 7, 1, 3, 11, 6, 12, 2, 10, 15, 14, 5, 8, 8, 11, 10, 7, 1, 13, 5, 12, 6, 3, 9, 0, 15, 14, 2, 4, 13, 7, 12, 9, 15, 0, 5, 8, 10, 2, 11, 6, 4, 3, 1, 14, 11, 4, 6, 5, 0, 15, 1, 12, 9, 14, 13, 8, 3, 7, 10, 2, 13, 15, 9, 4, 2, 12, 5, 10, 6, 0, 3, 8, 7, 14, 1, 11, 15, 14, 9, 5, 11, 2, 1, 8, 6, 0, 13, 3, 4, 7, 12, 10, 10, 3, 14, 2, 0, 1, 4, 6, 11, 8, 12, 7, 13, 5, 15, 9};
    static SimpleTest[] tests = new SimpleTest[]{new BlockCipherVectorTest(1, new GOST28147Engine(), new KeyParameter(Hex.decode("546d203368656c326973652073736e62206167796967747473656865202c3d73")), input1, output1), new BlockCipherVectorTest(2, new CBCBlockCipher(new GOST28147Engine()), new ParametersWithIV(new KeyParameter(Hex.decode("00112233445566778899AABBCCDDEEFF00112233445566778899AABBCCDDEEFF")), Hex.decode("1234567890abcdef")), input2, output2), new BlockCipherVectorTest(3, new GOFBBlockCipher(new GOST28147Engine()), new ParametersWithIV(new KeyParameter(Hex.decode("0011223344556677889900112233445566778899001122334455667788990011")), Hex.decode("1234567890abcdef")), input3, output3), new BlockCipherVectorTest(4, new CFBBlockCipher(new GOST28147Engine(), 64), new ParametersWithIV(new KeyParameter(Hex.decode("aafd12f659cae63489b479e5076ddec2f06cb58faafd12f659cae63489b479e5")), Hex.decode("aafd12f659cae634")), input4, output4), new BlockCipherVectorTest(5, new GOST28147Engine(), new KeyParameter(Hex.decode("546d203368656c326973652073736e62206167796967747473656865202c3d73")), input1, output1), new BlockCipherVectorTest(6, new CFBBlockCipher(new GOST28147Engine(), 64), new ParametersWithIV(new ParametersWithSBox(new KeyParameter(Hex.decode("546d203368656c326973652073736e62206167796967747473656865202c3d73")), GOST28147Engine.getSBox("D-Test")), Hex.decode("1234567890abcdef")), "0000000000000000", "b587f7a0814c911d"), new BlockCipherVectorTest(7, new CFBBlockCipher(new GOST28147Engine(), 64), new ParametersWithIV(new ParametersWithSBox(new KeyParameter(Hex.decode("546d203368656c326973652073736e62206167796967747473656865202c3d73")), GOST28147Engine.getSBox("E-Test")), Hex.decode("1234567890abcdef")), "0000000000000000", "e8287f53f991d52b"), new BlockCipherVectorTest(8, new CFBBlockCipher(new GOST28147Engine(), 64), new ParametersWithIV(new ParametersWithSBox(new KeyParameter(Hex.decode("546d203368656c326973652073736e62206167796967747473656865202c3d73")), GOST28147Engine.getSBox("E-A")), Hex.decode("1234567890abcdef")), "0000000000000000", "c41009dba22ebe35"), new BlockCipherVectorTest(9, new CFBBlockCipher(new GOST28147Engine(), 8), new ParametersWithIV(new ParametersWithSBox(new KeyParameter(Hex.decode("546d203368656c326973652073736e62206167796967747473656865202c3d73")), GOST28147Engine.getSBox("E-B")), Hex.decode("1234567890abcdef")), "0000000000000000", "80d8723fcd3aba28"), new BlockCipherVectorTest(10, new CFBBlockCipher(new GOST28147Engine(), 8), new ParametersWithIV(new ParametersWithSBox(new KeyParameter(Hex.decode("546d203368656c326973652073736e62206167796967747473656865202c3d73")), GOST28147Engine.getSBox("E-C")), Hex.decode("1234567890abcdef")), "0000000000000000", "739f6f95068499b5"), new BlockCipherVectorTest(11, new CFBBlockCipher(new GOST28147Engine(), 8), new ParametersWithIV(new ParametersWithSBox(new KeyParameter(Hex.decode("546d203368656c326973652073736e62206167796967747473656865202c3d73")), GOST28147Engine.getSBox("E-D")), Hex.decode("1234567890abcdef")), "0000000000000000", "4663f720f4340f57"), new BlockCipherVectorTest(12, new CFBBlockCipher(new GOST28147Engine(), 8), new ParametersWithIV(new ParametersWithSBox(new KeyParameter(Hex.decode("546d203368656c326973652073736e62206167796967747473656865202c3d73")), GOST28147Engine.getSBox("D-A")), Hex.decode("1234567890abcdef")), "0000000000000000", "5bb0a31d218ed564"), new BlockCipherVectorTest(13, new CFBBlockCipher(new GOST28147Engine(), 8), new ParametersWithIV(new ParametersWithSBox(new KeyParameter(Hex.decode("546d203368656c326973652073736e62206167796967747473656865202c3d73")), TestSBox), Hex.decode("1234567890abcdef")), "0000000000000000", "c3af96ef788667c5"), new BlockCipherVectorTest(14, new GOFBBlockCipher(new GOST28147Engine()), new ParametersWithIV(new ParametersWithSBox(new KeyParameter(Hex.decode("4ef72b778f0b0bebeef4f077551cb74a927b470ad7d7f2513454569a247e989d")), GOST28147Engine.getSBox("E-A")), Hex.decode("1234567890abcdef")), "bc350e71aa11345709acde", "1bcc2282707c676fb656dc"), new BlockCipherVectorTest(15, new GOFBBlockCipher(new GOST28147Engine()), new ParametersWithIV(new ParametersWithSBox(new KeyParameter(Hex.decode("0A43145BA8B9E9FF0AEA67D3F26AD87854CED8D9017B3D33ED81301F90FDF993")), TestSBox_1), Hex.decode("8001069080010690")), "094C912C5EFDD703D42118971694580B", "2707B58DF039D1A64460735FFE76D55F"), new BlockCipherVectorTest(16, new GOFBBlockCipher(new GOST28147Engine()), new ParametersWithIV(new ParametersWithSBox(new KeyParameter(Hex.decode("0A43145BA8B9E9FF0AEA67D3F26AD87854CED8D9017B3D33ED81301F90FDF993")), TestSBox_1), Hex.decode("800107A0800107A0")), "FE780800E0690083F20C010CF00C0329", "9AF623DFF948B413B53171E8D546188D"), new BlockCipherVectorTest(17, new GOFBBlockCipher(new GOST28147Engine()), new ParametersWithIV(new ParametersWithSBox(new KeyParameter(Hex.decode("0A43145BA8B9E9FF0AEA67D3F26AD87854CED8D9017B3D33ED81301F90FDF993")), TestSBox_1), Hex.decode("8001114080011140")), "D1088FD8C0A86EE8F1DCD1088FE8C058", "62A6B64D12253BCD8241A4BB0CFD3E7C"), new BlockCipherVectorTest(18, new GOFBBlockCipher(new GOST28147Engine()), new ParametersWithIV(new ParametersWithSBox(new KeyParameter(Hex.decode("0A43145BA8B9E9FF0AEA67D3F26AD87854CED8D9017B3D33ED81301F90FDF993")), TestSBox_1), Hex.decode("80011A3080011A30")), "D431FACD011C502C501B500A12921090", "07313C89D302FF73234B4A0506AB00F3")};
    private static final int GOST28147_KEY_LENGTH = 32;

    private byte[] generateKey(byte[] startkey) {
        byte[] newKey = new byte[32];
        GOST3411Digest digest = new GOST3411Digest();
        digest.update(startkey, 0, startkey.length);
        digest.doFinal(newKey, 0);
        return newKey;
    }

    GOST28147Test() {
        super(tests, new GOST28147Engine(), new KeyParameter(new byte[32]));
    }

    @Override
    public void performTest() throws Exception {
        int i;
        super.performTest();
        byte[] in = Hex.decode("4e6f77206973207468652074696d6520666f7220616c6c20");
        byte[] output = Hex.decode("8ad3c8f56b27ff1fbd46409359bdc796bc350e71aac5f5c0");
        byte[] out = new byte[in.length];
        byte[] key = this.generateKey(Hex.decode("0123456789abcdef"));
        CipherParameters param = new ParametersWithSBox(new KeyParameter(key), GOST28147Engine.getSBox("E-A"));
        BufferedBlockCipher cipher = new BufferedBlockCipher(new GOST28147Engine());
        cipher.init(true, param);
        int len1 = cipher.processBytes(in, 0, in.length, out, 0);
        try {
            cipher.doFinal(out, len1);
        }
        catch (CryptoException e) {
            this.fail("failed - exception " + e.toString(), e);
        }
        if (out.length != output.length) {
            this.fail("failed - expected " + new String(Hex.encode(output)) + " got " + new String(Hex.encode(out)));
        }
        for (int i2 = 0; i2 != out.length; ++i2) {
            if (out[i2] == output[i2]) continue;
            this.fail("failed - expected " + new String(Hex.encode(output)) + " got " + new String(Hex.encode(out)));
        }
        in = Hex.decode("bc350e71aac5f5c2");
        output = Hex.decode("0ebbbafcf38f14a5");
        out = new byte[in.length];
        key = this.generateKey(Hex.decode("0123456789abcdef"));
        param = new ParametersWithIV(new ParametersWithSBox(new KeyParameter(key), GOST28147Engine.getSBox("E-A")), Hex.decode("1234567890abcdef"));
        cipher = new BufferedBlockCipher(new CFBBlockCipher(new GOST28147Engine(), 64));
        cipher.init(true, param);
        len1 = cipher.processBytes(in, 0, in.length, out, 0);
        try {
            cipher.doFinal(out, len1);
        }
        catch (CryptoException e) {
            this.fail("failed - exception " + e.toString(), e);
        }
        if (out.length != output.length) {
            this.fail("failed - expected " + new String(Hex.encode(output)) + " got " + new String(Hex.encode(out)));
        }
        for (i = 0; i != out.length; ++i) {
            if (out[i] == output[i]) continue;
            this.fail("failed - expected " + new String(Hex.encode(output)) + " got " + new String(Hex.encode(out)));
        }
        in = Hex.decode("000102030405060708090a0b0c0d0e0fff0102030405060708090a0b0c0d0e0f");
        output = Hex.decode("64988982819f0a1655e226e19ecad79d10cc73bac95c5d7da034786c12294225");
        out = new byte[in.length];
        key = this.generateKey(Hex.decode("aafd12f659cae63489b479e5076ddec2f06cb58faafd12f659cae63489b479e5"));
        param = new ParametersWithIV(new ParametersWithSBox(new KeyParameter(key), GOST28147Engine.getSBox("E-A")), Hex.decode("aafd12f659cae634"));
        cipher = new BufferedBlockCipher(new CFBBlockCipher(new GOST28147Engine(), 64));
        cipher.init(true, param);
        len1 = cipher.processBytes(in, 0, in.length, out, 0);
        cipher.doFinal(out, len1);
        if (out.length != output.length) {
            this.fail("failed - expected " + new String(Hex.encode(output)) + " got " + new String(Hex.encode(out)));
        }
        for (i = 0; i != out.length; ++i) {
            if (out[i] == output[i]) continue;
            this.fail("failed - expected " + new String(Hex.encode(output)) + " got " + new String(Hex.encode(out)));
        }
        in = Hex.decode("bc350e71aa11345709acde");
        output = Hex.decode("1bcc2282707c676fb656dc");
        out = new byte[in.length];
        key = this.generateKey(Hex.decode("0123456789abcdef"));
        param = new ParametersWithIV(new ParametersWithSBox(new KeyParameter(key), GOST28147Engine.getSBox("E-A")), Hex.decode("1234567890abcdef"));
        cipher = new BufferedBlockCipher(new GOFBBlockCipher(new GOST28147Engine()));
        cipher.init(true, param);
        len1 = cipher.processBytes(in, 0, in.length, out, 0);
        cipher.doFinal(out, len1);
        if (out.length != output.length) {
            this.fail("failed - expected " + new String(Hex.encode(output)) + " got " + new String(Hex.encode(out)));
        }
        for (i = 0; i != out.length; ++i) {
            if (out[i] == output[i]) continue;
            this.fail("failed - expected " + new String(Hex.encode(output)) + " got " + new String(Hex.encode(out)));
        }
        param = new ParametersWithIV(null, Hex.decode("1234567890abcdef"));
        cipher.init(true, param);
        len1 = cipher.processBytes(in, 0, in.length, out, 0);
        cipher.doFinal(out, len1);
        if (out.length != output.length) {
            this.fail("failed - expected " + new String(Hex.encode(output)) + " got " + new String(Hex.encode(out)));
        }
        for (i = 0; i != out.length; ++i) {
            if (out[i] == output[i]) continue;
            this.fail("failed - expected " + new String(Hex.encode(output)) + " got " + new String(Hex.encode(out)));
        }
    }

    @Override
    public String getName() {
        return "GOST28147";
    }

    public static void main(String[] args) {
        GOST28147Test.runTest(new GOST28147Test());
    }
}

