/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.crypto.test;

import org.bouncycastle160.crypto.CipherParameters;
import org.bouncycastle160.crypto.engines.Grain128Engine;
import org.bouncycastle160.crypto.params.KeyParameter;
import org.bouncycastle160.crypto.params.ParametersWithIV;
import org.bouncycastle160.util.encoders.Hex;
import org.bouncycastle160.util.test.SimpleTest;

public class Grain128Test
extends SimpleTest {
    String keyStream1 = "f09b7bf7d7f6b5c2de2ffc73ac21397f";
    String keyStream2 = "afb5babfa8de896b4b9c6acaf7c4fbfd";

    @Override
    public String getName() {
        return "Grain-128";
    }

    @Override
    public void performTest() {
        this.Grain128Test1(new ParametersWithIV(new KeyParameter(Hex.decode("00000000000000000000000000000000")), Hex.decode("000000000000000000000000")));
        this.Grain128Test2(new ParametersWithIV(new KeyParameter(Hex.decode("0123456789abcdef123456789abcdef0")), Hex.decode("0123456789abcdef12345678")));
        this.Grain128Test3(new ParametersWithIV(new KeyParameter(Hex.decode("0123456789abcdef123456789abcdef0")), Hex.decode("0123456789abcdef12345678")));
    }

    private void Grain128Test1(CipherParameters params) {
        Grain128Engine grain = new Grain128Engine();
        byte[] in = new byte[16];
        byte[] out = new byte[16];
        grain.init(true, params);
        grain.processBytes(in, 0, in.length, out, 0);
        if (!this.areEqual(out, Hex.decode(this.keyStream1))) {
            this.mismatch("Keystream 1", this.keyStream1, out);
        }
        grain.reset();
        grain.processBytes(in, 0, in.length, out, 0);
        if (!this.areEqual(out, Hex.decode(this.keyStream1))) {
            this.mismatch("Keystream 1", this.keyStream1, out);
        }
    }

    private void Grain128Test2(CipherParameters params) {
        Grain128Engine grain = new Grain128Engine();
        byte[] in = new byte[16];
        byte[] out = new byte[16];
        grain.init(true, params);
        grain.processBytes(in, 0, in.length, out, 0);
        if (!this.areEqual(out, Hex.decode(this.keyStream2))) {
            this.mismatch("Keystream 2", this.keyStream2, out);
        }
        grain.reset();
        grain.processBytes(in, 0, in.length, out, 0);
        if (!this.areEqual(out, Hex.decode(this.keyStream2))) {
            this.mismatch("Keystream 2", this.keyStream2, out);
        }
    }

    private void Grain128Test3(CipherParameters params) {
        Grain128Engine grain = new Grain128Engine();
        byte[] in = "Encrypt me!".getBytes();
        byte[] cipher = new byte[in.length];
        byte[] clear = new byte[in.length];
        grain.init(true, params);
        grain.processBytes(in, 0, in.length, cipher, 0);
        grain.reset();
        grain.processBytes(cipher, 0, cipher.length, clear, 0);
        if (!this.areEqual(in, clear)) {
            this.mismatch("Test 3", new String(Hex.encode(in)), clear);
        }
    }

    private void mismatch(String name, String expected, byte[] found) {
        this.fail("mismatch on " + name, expected, new String(Hex.encode(found)));
    }

    public static void main(String[] args) {
        Grain128Test.runTest(new Grain128Test());
    }
}

