/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.crypto.test;

import org.bouncycastle160.crypto.CipherParameters;
import org.bouncycastle160.crypto.engines.Grainv1Engine;
import org.bouncycastle160.crypto.params.KeyParameter;
import org.bouncycastle160.crypto.params.ParametersWithIV;
import org.bouncycastle160.util.encoders.Hex;
import org.bouncycastle160.util.test.SimpleTest;

public class Grainv1Test
extends SimpleTest {
    String keyStream1 = "dee931cf1662a72f77d0";
    String keyStream2 = "7f362bd3f7abae203664";
    String keyStream4 = "017D13ECB20AE0C9ACF784CB06525F72CE6D52BEBB948F124668C3506455902449EEA505C19F3EE4D052C3D19DA9C4D1B92DBC7F07AFEA6A3D845DE60D8471FD";

    @Override
    public String getName() {
        return "Grain v1";
    }

    @Override
    public void performTest() {
        this.Grainv1Test1(new ParametersWithIV(new KeyParameter(Hex.decode("00000000000000000000")), Hex.decode("0000000000000000")));
        this.Grainv1Test2(new ParametersWithIV(new KeyParameter(Hex.decode("0123456789abcdef1234")), Hex.decode("0123456789abcdef")));
        this.Grainv1Test3(new ParametersWithIV(new KeyParameter(Hex.decode("0123456789abcdef1234")), Hex.decode("0123456789abcdef")));
        this.Grainv1Test4(new ParametersWithIV(new KeyParameter(Hex.decode("0F62B5085BAE0154A7FA")), Hex.decode("288FF65DC42B92F9")));
    }

    private void Grainv1Test1(CipherParameters params) {
        Grainv1Engine grain = new Grainv1Engine();
        byte[] in = new byte[10];
        byte[] out = new byte[10];
        grain.init(true, params);
        grain.processBytes(in, 0, in.length, out, 0);
        if (!this.areEqual(out, Hex.decode(this.keyStream1))) {
            this.mismatch("Keystream 1", this.keyStream1, out);
        }
        grain.reset();
        grain.processBytes(in, 0, in.length, out, 0);
        if (!this.areEqual(out, Hex.decode(this.keyStream1))) {
            this.mismatch("Keystream 1", this.keyStream1, out);
        }
    }

    private void Grainv1Test2(CipherParameters params) {
        Grainv1Engine grain = new Grainv1Engine();
        byte[] in = new byte[10];
        byte[] out = new byte[10];
        grain.init(true, params);
        grain.processBytes(in, 0, in.length, out, 0);
        if (!this.areEqual(out, Hex.decode(this.keyStream2))) {
            this.mismatch("Keystream 2", this.keyStream2, out);
        }
        grain.reset();
        grain.processBytes(in, 0, in.length, out, 0);
        if (!this.areEqual(out, Hex.decode(this.keyStream2))) {
            this.mismatch("Keystream 2", this.keyStream2, out);
        }
    }

    private void Grainv1Test3(CipherParameters params) {
        Grainv1Engine grain = new Grainv1Engine();
        byte[] in = "Encrypt me!".getBytes();
        byte[] cipher = new byte[in.length];
        byte[] clear = new byte[in.length];
        grain.init(true, params);
        grain.processBytes(in, 0, in.length, cipher, 0);
        grain.reset();
        grain.processBytes(cipher, 0, cipher.length, clear, 0);
        if (!this.areEqual(in, clear)) {
            this.mismatch("Test 3", new String(Hex.encode(in)), clear);
        }
    }

    private void Grainv1Test4(CipherParameters params) {
        Grainv1Engine grain = new Grainv1Engine();
        byte[] in = new byte[this.keyStream4.length() / 2];
        byte[] out = new byte[in.length];
        grain.init(true, params);
        grain.processBytes(in, 0, in.length, out, 0);
        if (!this.areEqual(out, Hex.decode(this.keyStream4))) {
            this.mismatch("Keystream 4", this.keyStream4, out);
        }
    }

    private void mismatch(String name, String expected, byte[] found) {
        this.fail("mismatch on " + name, expected, new String(Hex.encode(found)));
    }

    public static void main(String[] args) {
        Grainv1Test.runTest(new Grainv1Test());
    }
}

