/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.crypto.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.bouncycastle160.crypto.test.cavp.CAVPReader;
import org.bouncycastle160.crypto.test.cavp.KDFDoublePipelineCounterTests;
import org.bouncycastle160.crypto.test.cavp.KDFDoublePipelineIterationNoCounterTests;
import org.bouncycastle160.util.test.SimpleTest;

public class KDFDoublePipelineIteratorGeneratorTest
extends SimpleTest {
    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void performTest() throws Exception {
        KDFDoublePipelineIteratorGeneratorTest.testDoublePipelineIterationCounter();
        KDFDoublePipelineIteratorGeneratorTest.testDoublePipelineIterationNoCounter();
    }

    private static void testDoublePipelineIterationCounter() {
        CAVPReader cavpReader = new CAVPReader(new KDFDoublePipelineCounterTests());
        InputStream stream = CAVPReader.class.getResourceAsStream("KDFDblPipelineCounter_gen.rsp");
        InputStreamReader reader = new InputStreamReader(stream, Charset.forName("UTF-8"));
        cavpReader.setInput("KDFDoublePipelineIterationCounter", reader);
        try {
            cavpReader.readAll();
        }
        catch (IOException e) {
            throw new IllegalStateException("Something is rotten in the state of Denmark", e);
        }
    }

    private static void testDoublePipelineIterationNoCounter() {
        CAVPReader cavpReader = new CAVPReader(new KDFDoublePipelineIterationNoCounterTests());
        InputStream stream = CAVPReader.class.getResourceAsStream("KDFDblPipelineNoCounter_gen.rsp");
        InputStreamReader reader = new InputStreamReader(stream, Charset.forName("UTF-8"));
        cavpReader.setInput("KDFDblPipelineIterationNoCounter", reader);
        try {
            cavpReader.readAll();
        }
        catch (IOException e) {
            throw new IllegalStateException("Something is rotten in the state of Denmark", e);
        }
    }

    public static void main(String[] args) {
        KDFDoublePipelineIteratorGeneratorTest.runTest(new KDFDoublePipelineIteratorGeneratorTest());
    }
}

