/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.crypto.test;

import org.bouncycastle160.crypto.DataLengthException;
import org.bouncycastle160.crypto.engines.NullEngine;
import org.bouncycastle160.crypto.params.KeyParameter;
import org.bouncycastle160.crypto.test.BlockCipherVectorTest;
import org.bouncycastle160.crypto.test.CipherTest;
import org.bouncycastle160.util.encoders.Hex;
import org.bouncycastle160.util.test.SimpleTest;

public class NullTest
extends CipherTest {
    static SimpleTest[] tests = new SimpleTest[]{new BlockCipherVectorTest(0, new NullEngine(), new KeyParameter(Hex.decode("00")), "00", "00")};

    NullTest() {
        super(tests, new NullEngine(), new KeyParameter(new byte[2]));
    }

    @Override
    public String getName() {
        return "Null";
    }

    @Override
    public void performTest() throws Exception {
        super.performTest();
        NullEngine engine = new NullEngine();
        engine.init(true, null);
        byte[] buf = new byte[1];
        engine.processBlock(buf, 0, buf, 0);
        if (buf[0] != 0) {
            this.fail("NullCipher changed data!");
        }
        byte[] shortBuf = new byte[]{};
        try {
            engine.processBlock(shortBuf, 0, buf, 0);
            this.fail("failed short input check");
        }
        catch (DataLengthException dataLengthException) {
            // empty catch block
        }
        try {
            engine.processBlock(buf, 0, shortBuf, 0);
            this.fail("failed short output check");
        }
        catch (DataLengthException dataLengthException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        NullTest.runTest(new NullTest());
    }
}

