/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.crypto.test;

import org.bouncycastle160.crypto.engines.SM4Engine;
import org.bouncycastle160.crypto.params.KeyParameter;
import org.bouncycastle160.crypto.test.BlockCipherVectorTest;
import org.bouncycastle160.crypto.test.CipherTest;
import org.bouncycastle160.util.encoders.Hex;
import org.bouncycastle160.util.test.SimpleTest;

public class SM4Test
extends CipherTest {
    static SimpleTest[] tests = new SimpleTest[]{new BlockCipherVectorTest(0, new SM4Engine(), new KeyParameter(Hex.decode("0123456789abcdeffedcba9876543210")), "0123456789abcdeffedcba9876543210", "681edf34d206965e86b3e94f536e4246")};

    SM4Test() {
        super(tests, new SM4Engine(), new KeyParameter(new byte[16]));
    }

    @Override
    public void performTest() throws Exception {
        super.performTest();
        this.test1000000();
    }

    private void test1000000() {
        int i;
        byte[] plain = Hex.decode("0123456789abcdeffedcba9876543210");
        byte[] key = Hex.decode("0123456789abcdeffedcba9876543210");
        byte[] cipher = Hex.decode("595298c7c6fd271f0402f804c33d3f66");
        byte[] buf = new byte[16];
        SM4Engine engine = new SM4Engine();
        engine.init(true, new KeyParameter(key));
        System.arraycopy(plain, 0, buf, 0, buf.length);
        for (i = 0; i != 1000000; ++i) {
            engine.processBlock(buf, 0, buf, 0);
        }
        if (!this.areEqual(cipher, buf)) {
            this.fail("1000000 encryption test failed");
        }
        engine.init(false, new KeyParameter(key));
        for (i = 0; i != 1000000; ++i) {
            engine.processBlock(buf, 0, buf, 0);
        }
        if (!this.areEqual(plain, buf)) {
            this.fail("1000000 decryption test failed");
        }
    }

    @Override
    public String getName() {
        return "SM4";
    }

    public static void main(String[] args) {
        SM4Test.runTest(new SM4Test());
    }
}

