/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.crypto.test.cavp;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.regex.Matcher;
import org.bouncycastle160.crypto.Mac;
import org.bouncycastle160.crypto.generators.KDFCounterBytesGenerator;
import org.bouncycastle160.crypto.params.KDFCounterParameters;
import org.bouncycastle160.crypto.test.cavp.CAVPListener;
import org.bouncycastle160.crypto.test.cavp.CAVPReader;
import org.bouncycastle160.util.Arrays;
import org.bouncycastle160.util.encoders.Hex;
import org.bouncycastle160.util.test.SimpleTestResult;
import org.bouncycastle160.util.test.TestFailedException;

public final class KDFCounterTests
implements CAVPListener {
    private PrintWriter out;

    @Override
    public void receiveCAVPVectors(String name, Properties config, Properties vectors) {
        KDFCounterParameters params;
        byte[] fixedInputData;
        Mac prf = CAVPReader.createPRF(config);
        KDFCounterBytesGenerator gen = new KDFCounterBytesGenerator(prf);
        Matcher matcherForR = CAVPReader.PATTERN_FOR_R.matcher(config.getProperty("RLEN"));
        if (!matcherForR.matches()) {
            throw new IllegalStateException("RLEN value should always match");
        }
        int r = Integer.parseInt(matcherForR.group(1));
        int count = Integer.parseInt(vectors.getProperty("COUNT"));
        int l = Integer.parseInt(vectors.getProperty("L"));
        byte[] ki = Hex.decode(vectors.getProperty("KI"));
        if (config.getProperty("CTRLOCATION").matches("BEFORE_FIXED")) {
            fixedInputData = Hex.decode(vectors.getProperty("FixedInputData"));
            params = new KDFCounterParameters(ki, null, fixedInputData, r);
            gen.init(params);
        } else if (config.getProperty("CTRLOCATION").matches("AFTER_FIXED")) {
            fixedInputData = Hex.decode(vectors.getProperty("FixedInputData"));
            params = new KDFCounterParameters(ki, fixedInputData, null, r);
            gen.init(params);
        } else if (config.getProperty("CTRLOCATION").matches("MIDDLE_FIXED")) {
            byte[] DataBeforeCtrData = Hex.decode(vectors.getProperty("DataBeforeCtrData"));
            byte[] DataAfterCtrData = Hex.decode(vectors.getProperty("DataAfterCtrData"));
            KDFCounterParameters params2 = new KDFCounterParameters(ki, DataBeforeCtrData, DataAfterCtrData, r);
            gen.init(params2);
        } else {
            return;
        }
        byte[] koGenerated = new byte[l / 8];
        gen.generateBytes(koGenerated, 0, koGenerated.length);
        byte[] koVectors = Hex.decode(vectors.getProperty("KO"));
        KDFCounterTests.compareKO(name, config, count, koGenerated, koVectors);
    }

    private static void compareKO(String name, Properties config, int test, byte[] calculatedOKM, byte[] testOKM) {
        if (!Arrays.areEqual(calculatedOKM, testOKM)) {
            throw new TestFailedException(new SimpleTestResult(false, name + " using " + config + " test " + test + " failed"));
        }
    }

    @Override
    public void receiveCommentLine(String commentLine) {
    }

    @Override
    public void receiveStart(String name) {
    }

    @Override
    public void receiveEnd() {
        this.out.println(" *** *** *** ");
    }

    @Override
    public void setup() {
        try {
            this.out = new PrintWriter(new FileWriter("KDFCTR.gen"));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void tearDown() {
        this.out.close();
    }
}

