/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.crypto.test.cavp;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import org.bouncycastle160.crypto.Mac;
import org.bouncycastle160.crypto.generators.KDFDoublePipelineIterationBytesGenerator;
import org.bouncycastle160.crypto.params.KDFDoublePipelineIterationParameters;
import org.bouncycastle160.crypto.test.cavp.CAVPListener;
import org.bouncycastle160.crypto.test.cavp.CAVPReader;
import org.bouncycastle160.util.Arrays;
import org.bouncycastle160.util.encoders.Hex;
import org.bouncycastle160.util.test.SimpleTestResult;
import org.bouncycastle160.util.test.TestFailedException;

public final class KDFDoublePipelineIterationNoCounterTests
implements CAVPListener {
    private PrintWriter out;

    @Override
    public void receiveCAVPVectors(String name, Properties config, Properties vectors) {
        Mac prf = CAVPReader.createPRF(config);
        KDFDoublePipelineIterationBytesGenerator gen = new KDFDoublePipelineIterationBytesGenerator(prf);
        int count = Integer.parseInt(vectors.getProperty("COUNT"));
        int l = Integer.parseInt(vectors.getProperty("L"));
        byte[] ki = Hex.decode(vectors.getProperty("KI"));
        byte[] fixedInputData = Hex.decode(vectors.getProperty("FixedInputData"));
        KDFDoublePipelineIterationParameters params = KDFDoublePipelineIterationParameters.createWithoutCounter(ki, fixedInputData);
        gen.init(params);
        byte[] koGenerated = new byte[l / 8];
        gen.generateBytes(koGenerated, 0, koGenerated.length);
        byte[] koVectors = Hex.decode(vectors.getProperty("KO"));
        KDFDoublePipelineIterationNoCounterTests.compareKO(name, config, count, koGenerated, koVectors);
    }

    private static void compareKO(String name, Properties config, int test, byte[] calculatedOKM, byte[] testOKM) {
        if (!Arrays.areEqual(calculatedOKM, testOKM)) {
            throw new TestFailedException(new SimpleTestResult(false, name + " using " + config + " test " + test + " failed"));
        }
    }

    @Override
    public void receiveCommentLine(String commentLine) {
    }

    @Override
    public void receiveStart(String name) {
    }

    @Override
    public void receiveEnd() {
        this.out.println(" *** *** *** ");
    }

    @Override
    public void setup() {
        try {
            this.out = new PrintWriter(new FileWriter("KDFDblPipelineNoCounter.gen"));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void tearDown() {
        this.out.close();
    }
}

