/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.crypto.tls;

import java.io.IOException;
import org.bouncycastle160.crypto.tls.AbstractTlsClient;
import org.bouncycastle160.crypto.tls.DefaultTlsCipherFactory;
import org.bouncycastle160.crypto.tls.TlsAuthentication;
import org.bouncycastle160.crypto.tls.TlsCipherFactory;
import org.bouncycastle160.crypto.tls.TlsFatalAlert;
import org.bouncycastle160.crypto.tls.TlsKeyExchange;
import org.bouncycastle160.crypto.tls.TlsPSKIdentity;
import org.bouncycastle160.crypto.tls.TlsPSKKeyExchange;
import org.bouncycastle160.crypto.tls.TlsUtils;

public class PSKTlsClient
extends AbstractTlsClient {
    protected TlsPSKIdentity pskIdentity;

    public PSKTlsClient(TlsPSKIdentity pskIdentity) {
        this(new DefaultTlsCipherFactory(), pskIdentity);
    }

    public PSKTlsClient(TlsCipherFactory cipherFactory, TlsPSKIdentity pskIdentity) {
        super(cipherFactory);
        this.pskIdentity = pskIdentity;
    }

    @Override
    public int[] getCipherSuites() {
        return new int[]{49207, 49205, 178, 144};
    }

    @Override
    public TlsKeyExchange getKeyExchange() throws IOException {
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (keyExchangeAlgorithm) {
            case 13: 
            case 14: 
            case 15: 
            case 24: {
                return this.createPSKKeyExchange(keyExchangeAlgorithm);
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsAuthentication getAuthentication() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createPSKKeyExchange(int keyExchange) {
        return new TlsPSKKeyExchange(keyExchange, this.supportedSignatureAlgorithms, this.pskIdentity, null, null, this.namedCurves, this.clientECPointFormats, this.serverECPointFormats);
    }
}

