/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.crypto.tls;

import org.bouncycastle160.crypto.CipherParameters;
import org.bouncycastle160.crypto.CryptoException;
import org.bouncycastle160.crypto.DSA;
import org.bouncycastle160.crypto.Digest;
import org.bouncycastle160.crypto.Signer;
import org.bouncycastle160.crypto.digests.NullDigest;
import org.bouncycastle160.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle160.crypto.params.ParametersWithRandom;
import org.bouncycastle160.crypto.signers.DSADigestSigner;
import org.bouncycastle160.crypto.tls.AbstractTlsSigner;
import org.bouncycastle160.crypto.tls.SignatureAndHashAlgorithm;
import org.bouncycastle160.crypto.tls.TlsUtils;

public abstract class TlsDSASigner
extends AbstractTlsSigner {
    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, AsymmetricKeyParameter privateKey, byte[] hash) throws CryptoException {
        Signer signer = this.makeSigner(algorithm, true, true, new ParametersWithRandom(privateKey, this.context.getSecureRandom()));
        if (algorithm == null) {
            signer.update(hash, 16, 20);
        } else {
            signer.update(hash, 0, hash.length);
        }
        return signer.generateSignature();
    }

    @Override
    public boolean verifyRawSignature(SignatureAndHashAlgorithm algorithm, byte[] sigBytes, AsymmetricKeyParameter publicKey, byte[] hash) throws CryptoException {
        Signer signer = this.makeSigner(algorithm, true, false, publicKey);
        if (algorithm == null) {
            signer.update(hash, 16, 20);
        } else {
            signer.update(hash, 0, hash.length);
        }
        return signer.verifySignature(sigBytes);
    }

    @Override
    public Signer createSigner(SignatureAndHashAlgorithm algorithm, AsymmetricKeyParameter privateKey) {
        return this.makeSigner(algorithm, false, true, privateKey);
    }

    @Override
    public Signer createVerifyer(SignatureAndHashAlgorithm algorithm, AsymmetricKeyParameter publicKey) {
        return this.makeSigner(algorithm, false, false, publicKey);
    }

    protected CipherParameters makeInitParameters(boolean forSigning, CipherParameters cp) {
        return cp;
    }

    protected Signer makeSigner(SignatureAndHashAlgorithm algorithm, boolean raw, boolean forSigning, CipherParameters cp) {
        if (algorithm != null != TlsUtils.isTLSv12(this.context)) {
            throw new IllegalStateException();
        }
        if (algorithm != null && algorithm.getSignature() != this.getSignatureAlgorithm()) {
            throw new IllegalStateException();
        }
        short hashAlgorithm = algorithm == null ? (short)2 : (short)algorithm.getHash();
        Digest d = raw ? new NullDigest() : TlsUtils.createHash(hashAlgorithm);
        DSADigestSigner s = new DSADigestSigner(this.createDSAImpl(hashAlgorithm), d);
        s.init(forSigning, this.makeInitParameters(forSigning, cp));
        return s;
    }

    protected abstract short getSignatureAlgorithm();

    protected abstract DSA createDSAImpl(short var1);
}

