/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.crypto.tls;

import org.bouncycastle160.crypto.DSA;
import org.bouncycastle160.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle160.crypto.params.DSAPublicKeyParameters;
import org.bouncycastle160.crypto.signers.DSASigner;
import org.bouncycastle160.crypto.signers.HMacDSAKCalculator;
import org.bouncycastle160.crypto.tls.TlsDSASigner;
import org.bouncycastle160.crypto.tls.TlsUtils;

public class TlsDSSSigner
extends TlsDSASigner {
    @Override
    public boolean isValidPublicKey(AsymmetricKeyParameter publicKey) {
        return publicKey instanceof DSAPublicKeyParameters;
    }

    @Override
    protected DSA createDSAImpl(short hashAlgorithm) {
        return new DSASigner(new HMacDSAKCalculator(TlsUtils.createHash(hashAlgorithm)));
    }

    @Override
    protected short getSignatureAlgorithm() {
        return 2;
    }
}

