/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.crypto.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Vector;
import org.bouncycastle160.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle160.crypto.CryptoException;
import org.bouncycastle160.crypto.Digest;
import org.bouncycastle160.crypto.Signer;
import org.bouncycastle160.crypto.agreement.srp.SRP6Client;
import org.bouncycastle160.crypto.agreement.srp.SRP6Server;
import org.bouncycastle160.crypto.agreement.srp.SRP6Util;
import org.bouncycastle160.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle160.crypto.params.SRP6GroupParameters;
import org.bouncycastle160.crypto.tls.AbstractTlsKeyExchange;
import org.bouncycastle160.crypto.tls.Certificate;
import org.bouncycastle160.crypto.tls.CertificateRequest;
import org.bouncycastle160.crypto.tls.DefaultTlsSRPGroupVerifier;
import org.bouncycastle160.crypto.tls.DigestInputBuffer;
import org.bouncycastle160.crypto.tls.DigitallySigned;
import org.bouncycastle160.crypto.tls.SecurityParameters;
import org.bouncycastle160.crypto.tls.ServerSRPParams;
import org.bouncycastle160.crypto.tls.SignatureAndHashAlgorithm;
import org.bouncycastle160.crypto.tls.SignerInputBuffer;
import org.bouncycastle160.crypto.tls.TlsContext;
import org.bouncycastle160.crypto.tls.TlsCredentials;
import org.bouncycastle160.crypto.tls.TlsDSSSigner;
import org.bouncycastle160.crypto.tls.TlsFatalAlert;
import org.bouncycastle160.crypto.tls.TlsRSASigner;
import org.bouncycastle160.crypto.tls.TlsSRPGroupVerifier;
import org.bouncycastle160.crypto.tls.TlsSRPLoginParameters;
import org.bouncycastle160.crypto.tls.TlsSRPUtils;
import org.bouncycastle160.crypto.tls.TlsSigner;
import org.bouncycastle160.crypto.tls.TlsSignerCredentials;
import org.bouncycastle160.crypto.tls.TlsUtils;
import org.bouncycastle160.crypto.util.PublicKeyFactory;
import org.bouncycastle160.util.Arrays;
import org.bouncycastle160.util.BigIntegers;
import org.bouncycastle160.util.io.TeeInputStream;

public class TlsSRPKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsSigner tlsSigner;
    protected TlsSRPGroupVerifier groupVerifier;
    protected byte[] identity;
    protected byte[] password;
    protected AsymmetricKeyParameter serverPublicKey = null;
    protected SRP6GroupParameters srpGroup = null;
    protected SRP6Client srpClient = null;
    protected SRP6Server srpServer = null;
    protected BigInteger srpPeerCredentials = null;
    protected BigInteger srpVerifier = null;
    protected byte[] srpSalt = null;
    protected TlsSignerCredentials serverCredentials = null;

    protected static TlsSigner createSigner(int keyExchange) {
        switch (keyExchange) {
            case 21: {
                return null;
            }
            case 23: {
                return new TlsRSASigner();
            }
            case 22: {
                return new TlsDSSSigner();
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsSRPKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, byte[] identity, byte[] password) {
        this(keyExchange, supportedSignatureAlgorithms, new DefaultTlsSRPGroupVerifier(), identity, password);
    }

    public TlsSRPKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, TlsSRPGroupVerifier groupVerifier, byte[] identity, byte[] password) {
        super(keyExchange, supportedSignatureAlgorithms);
        this.tlsSigner = TlsSRPKeyExchange.createSigner(keyExchange);
        this.groupVerifier = groupVerifier;
        this.identity = identity;
        this.password = password;
        this.srpClient = new SRP6Client();
    }

    public TlsSRPKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, byte[] identity, TlsSRPLoginParameters loginParameters) {
        super(keyExchange, supportedSignatureAlgorithms);
        this.tlsSigner = TlsSRPKeyExchange.createSigner(keyExchange);
        this.identity = identity;
        this.srpServer = new SRP6Server();
        this.srpGroup = loginParameters.getGroup();
        this.srpVerifier = loginParameters.getVerifier();
        this.srpSalt = loginParameters.getSalt();
    }

    @Override
    public void init(TlsContext context) {
        super.init(context);
        if (this.tlsSigner != null) {
            this.tlsSigner.init(context);
        }
    }

    @Override
    public void skipServerCredentials() throws IOException {
        if (this.tlsSigner != null) {
            throw new TlsFatalAlert(10);
        }
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        if (this.tlsSigner == null) {
            throw new TlsFatalAlert(10);
        }
        if (serverCertificate.isEmpty()) {
            throw new TlsFatalAlert(42);
        }
        org.bouncycastle160.asn1.x509.Certificate x509Cert = serverCertificate.getCertificateAt(0);
        SubjectPublicKeyInfo keyInfo = x509Cert.getSubjectPublicKeyInfo();
        try {
            this.serverPublicKey = PublicKeyFactory.createKey(keyInfo);
        }
        catch (RuntimeException e) {
            throw new TlsFatalAlert(43, (Throwable)e);
        }
        if (!this.tlsSigner.isValidPublicKey(this.serverPublicKey)) {
            throw new TlsFatalAlert(46);
        }
        TlsUtils.validateKeyUsage(x509Cert, 128);
        super.processServerCertificate(serverCertificate);
    }

    @Override
    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        if (this.keyExchange == 21 || !(serverCredentials instanceof TlsSignerCredentials)) {
            throw new TlsFatalAlert(80);
        }
        this.processServerCertificate(serverCredentials.getCertificate());
        this.serverCredentials = (TlsSignerCredentials)serverCredentials;
    }

    @Override
    public boolean requiresServerKeyExchange() {
        return true;
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        this.srpServer.init(this.srpGroup, this.srpVerifier, TlsUtils.createHash((short)2), this.context.getSecureRandom());
        BigInteger B = this.srpServer.generateServerCredentials();
        ServerSRPParams srpParams = new ServerSRPParams(this.srpGroup.getN(), this.srpGroup.getG(), this.srpSalt, B);
        DigestInputBuffer buf = new DigestInputBuffer();
        srpParams.encode(buf);
        if (this.serverCredentials != null) {
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = TlsUtils.getSignatureAndHashAlgorithm(this.context, this.serverCredentials);
            Digest d = TlsUtils.createHash(signatureAndHashAlgorithm);
            SecurityParameters securityParameters = this.context.getSecurityParameters();
            d.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
            d.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
            buf.updateDigest(d);
            byte[] hash = new byte[d.getDigestSize()];
            d.doFinal(hash, 0);
            byte[] signature = this.serverCredentials.generateCertificateSignature(hash);
            DigitallySigned signed_params = new DigitallySigned(signatureAndHashAlgorithm, signature);
            signed_params.encode(buf);
        }
        return buf.toByteArray();
    }

    @Override
    public void processServerKeyExchange(InputStream input) throws IOException {
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        SignerInputBuffer buf = null;
        InputStream teeIn = input;
        if (this.tlsSigner != null) {
            buf = new SignerInputBuffer();
            teeIn = new TeeInputStream(input, buf);
        }
        ServerSRPParams srpParams = ServerSRPParams.parse(teeIn);
        if (buf != null) {
            DigitallySigned signed_params = this.parseSignature(input);
            Signer signer = this.initVerifyer(this.tlsSigner, signed_params.getAlgorithm(), securityParameters);
            buf.updateSigner(signer);
            if (!signer.verifySignature(signed_params.getSignature())) {
                throw new TlsFatalAlert(51);
            }
        }
        this.srpGroup = new SRP6GroupParameters(srpParams.getN(), srpParams.getG());
        if (!this.groupVerifier.accept(this.srpGroup)) {
            throw new TlsFatalAlert(71);
        }
        this.srpSalt = srpParams.getS();
        try {
            this.srpPeerCredentials = SRP6Util.validatePublicValue(this.srpGroup.getN(), srpParams.getB());
        }
        catch (CryptoException e) {
            throw new TlsFatalAlert(47, (Throwable)e);
        }
        this.srpClient.init(this.srpGroup, TlsUtils.createHash((short)2), this.context.getSecureRandom());
    }

    @Override
    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        throw new TlsFatalAlert(10);
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void generateClientKeyExchange(OutputStream output) throws IOException {
        BigInteger A = this.srpClient.generateClientCredentials(this.srpSalt, this.identity, this.password);
        TlsSRPUtils.writeSRPParameter(A, output);
        this.context.getSecurityParameters().srpIdentity = Arrays.clone(this.identity);
    }

    @Override
    public void processClientKeyExchange(InputStream input) throws IOException {
        try {
            this.srpPeerCredentials = SRP6Util.validatePublicValue(this.srpGroup.getN(), TlsSRPUtils.readSRPParameter(input));
        }
        catch (CryptoException e) {
            throw new TlsFatalAlert(47, (Throwable)e);
        }
        this.context.getSecurityParameters().srpIdentity = Arrays.clone(this.identity);
    }

    @Override
    public byte[] generatePremasterSecret() throws IOException {
        try {
            BigInteger S = this.srpServer != null ? this.srpServer.calculateSecret(this.srpPeerCredentials) : this.srpClient.calculateSecret(this.srpPeerCredentials);
            return BigIntegers.asUnsignedByteArray(S);
        }
        catch (CryptoException e) {
            throw new TlsFatalAlert(47, (Throwable)e);
        }
    }

    protected Signer initVerifyer(TlsSigner tlsSigner, SignatureAndHashAlgorithm algorithm, SecurityParameters securityParameters) {
        Signer signer = tlsSigner.createVerifyer(algorithm, this.serverPublicKey);
        signer.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        signer.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        return signer;
    }
}

