/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.crypto.util;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.bouncycastle160.asn1.ASN1Encodable;
import org.bouncycastle160.asn1.ASN1InputStream;
import org.bouncycastle160.asn1.ASN1Integer;
import org.bouncycastle160.asn1.ASN1ObjectIdentifier;
import org.bouncycastle160.asn1.ASN1Primitive;
import org.bouncycastle160.asn1.oiw.ElGamalParameter;
import org.bouncycastle160.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle160.asn1.pkcs.DHParameter;
import org.bouncycastle160.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle160.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle160.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle160.asn1.sec.ECPrivateKey;
import org.bouncycastle160.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle160.asn1.x509.DSAParameter;
import org.bouncycastle160.asn1.x9.ECNamedCurveTable;
import org.bouncycastle160.asn1.x9.X962Parameters;
import org.bouncycastle160.asn1.x9.X9ECParameters;
import org.bouncycastle160.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle160.crypto.ec.CustomNamedCurves;
import org.bouncycastle160.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle160.crypto.params.DHParameters;
import org.bouncycastle160.crypto.params.DHPrivateKeyParameters;
import org.bouncycastle160.crypto.params.DSAParameters;
import org.bouncycastle160.crypto.params.DSAPrivateKeyParameters;
import org.bouncycastle160.crypto.params.ECDomainParameters;
import org.bouncycastle160.crypto.params.ECNamedDomainParameters;
import org.bouncycastle160.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle160.crypto.params.ElGamalParameters;
import org.bouncycastle160.crypto.params.ElGamalPrivateKeyParameters;
import org.bouncycastle160.crypto.params.RSAPrivateCrtKeyParameters;

public class PrivateKeyFactory {
    public static AsymmetricKeyParameter createKey(byte[] privateKeyInfoData) throws IOException {
        return PrivateKeyFactory.createKey(PrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(privateKeyInfoData)));
    }

    public static AsymmetricKeyParameter createKey(InputStream inStr) throws IOException {
        return PrivateKeyFactory.createKey(PrivateKeyInfo.getInstance(new ASN1InputStream(inStr).readObject()));
    }

    public static AsymmetricKeyParameter createKey(PrivateKeyInfo keyInfo) throws IOException {
        AlgorithmIdentifier algId = keyInfo.getPrivateKeyAlgorithm();
        if (algId.getAlgorithm().equals(PKCSObjectIdentifiers.rsaEncryption)) {
            RSAPrivateKey keyStructure = RSAPrivateKey.getInstance(keyInfo.parsePrivateKey());
            return new RSAPrivateCrtKeyParameters(keyStructure.getModulus(), keyStructure.getPublicExponent(), keyStructure.getPrivateExponent(), keyStructure.getPrime1(), keyStructure.getPrime2(), keyStructure.getExponent1(), keyStructure.getExponent2(), keyStructure.getCoefficient());
        }
        if (algId.getAlgorithm().equals(PKCSObjectIdentifiers.dhKeyAgreement)) {
            DHParameter params = DHParameter.getInstance(algId.getParameters());
            ASN1Integer derX = (ASN1Integer)keyInfo.parsePrivateKey();
            BigInteger lVal = params.getL();
            int l = lVal == null ? 0 : lVal.intValue();
            DHParameters dhParams = new DHParameters(params.getP(), params.getG(), null, l);
            return new DHPrivateKeyParameters(derX.getValue(), dhParams);
        }
        if (algId.getAlgorithm().equals(OIWObjectIdentifiers.elGamalAlgorithm)) {
            ElGamalParameter params = ElGamalParameter.getInstance(algId.getParameters());
            ASN1Integer derX = (ASN1Integer)keyInfo.parsePrivateKey();
            return new ElGamalPrivateKeyParameters(derX.getValue(), new ElGamalParameters(params.getP(), params.getG()));
        }
        if (algId.getAlgorithm().equals(X9ObjectIdentifiers.id_dsa)) {
            ASN1Integer derX = (ASN1Integer)keyInfo.parsePrivateKey();
            ASN1Encodable de = algId.getParameters();
            DSAParameters parameters = null;
            if (de != null) {
                DSAParameter params = DSAParameter.getInstance(de.toASN1Primitive());
                parameters = new DSAParameters(params.getP(), params.getQ(), params.getG());
            }
            return new DSAPrivateKeyParameters(derX.getValue(), parameters);
        }
        if (algId.getAlgorithm().equals(X9ObjectIdentifiers.id_ecPublicKey)) {
            ECDomainParameters dParams;
            X962Parameters params = new X962Parameters((ASN1Primitive)algId.getParameters());
            if (params.isNamedCurve()) {
                ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)params.getParameters();
                X9ECParameters x9 = CustomNamedCurves.getByOID(oid);
                if (x9 == null) {
                    x9 = ECNamedCurveTable.getByOID(oid);
                }
                dParams = new ECNamedDomainParameters(oid, x9.getCurve(), x9.getG(), x9.getN(), x9.getH(), x9.getSeed());
            } else {
                X9ECParameters x9 = X9ECParameters.getInstance(params.getParameters());
                dParams = new ECDomainParameters(x9.getCurve(), x9.getG(), x9.getN(), x9.getH(), x9.getSeed());
            }
            ECPrivateKey ec = ECPrivateKey.getInstance(keyInfo.parsePrivateKey());
            BigInteger d = ec.getKey();
            return new ECPrivateKeyParameters(d, dParams);
        }
        throw new RuntimeException("algorithm identifier in key not recognised");
    }
}

