/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.jcajce.provider.asymmetric.ecgost;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle160.asn1.x9.X9IntegerConverter;
import org.bouncycastle160.crypto.DerivationFunction;
import org.bouncycastle160.crypto.agreement.ECVKOAgreement;
import org.bouncycastle160.crypto.digests.GOST3411Digest;
import org.bouncycastle160.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle160.crypto.params.ECDomainParameters;
import org.bouncycastle160.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle160.crypto.params.ParametersWithUKM;
import org.bouncycastle160.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle160.jcajce.provider.asymmetric.ecgost.BCECGOST3410PublicKey;
import org.bouncycastle160.jcajce.provider.asymmetric.util.BaseAgreementSpi;
import org.bouncycastle160.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle160.jcajce.spec.UserKeyingMaterialSpec;
import org.bouncycastle160.jce.interfaces.ECPrivateKey;
import org.bouncycastle160.jce.interfaces.ECPublicKey;

public class KeyAgreementSpi
extends BaseAgreementSpi {
    private static final X9IntegerConverter converter = new X9IntegerConverter();
    private String kaAlgorithm;
    private ECDomainParameters parameters;
    private ECVKOAgreement agreement;
    private byte[] result;

    protected KeyAgreementSpi(String kaAlgorithm, ECVKOAgreement agreement, DerivationFunction kdf) {
        super(kaAlgorithm, kdf);
        this.kaAlgorithm = kaAlgorithm;
        this.agreement = agreement;
    }

    @Override
    protected Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        if (this.parameters == null) {
            throw new IllegalStateException(this.kaAlgorithm + " not initialised.");
        }
        if (!lastPhase) {
            throw new IllegalStateException(this.kaAlgorithm + " can only be between two parties.");
        }
        if (!(key instanceof PublicKey)) {
            throw new InvalidKeyException(this.kaAlgorithm + " key agreement requires " + KeyAgreementSpi.getSimpleName(ECPublicKey.class) + " for doPhase");
        }
        AsymmetricKeyParameter pubKey = KeyAgreementSpi.generatePublicKeyParameter((PublicKey)key);
        try {
            this.result = this.agreement.calculateAgreement(pubKey);
        }
        catch (Exception e) {
            throw new InvalidKeyException("calculation failed: " + e.getMessage()){

                @Override
                public Throwable getCause() {
                    return e;
                }
            };
        }
        return null;
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null && !(params instanceof UserKeyingMaterialSpec)) {
            throw new InvalidAlgorithmParameterException("No algorithm parameters supported");
        }
        this.initFromKey(key, params);
    }

    @Override
    protected void engineInit(Key key, SecureRandom random) throws InvalidKeyException {
        this.initFromKey(key, null);
    }

    private void initFromKey(Key key, AlgorithmParameterSpec parameterSpec) throws InvalidKeyException {
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException(this.kaAlgorithm + " key agreement requires " + KeyAgreementSpi.getSimpleName(ECPrivateKey.class) + " for initialisation");
        }
        ECPrivateKeyParameters privKey = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)key);
        this.parameters = privKey.getParameters();
        this.ukmParameters = parameterSpec instanceof UserKeyingMaterialSpec ? ((UserKeyingMaterialSpec)parameterSpec).getUserKeyingMaterial() : null;
        this.agreement.init(new ParametersWithUKM(privKey, this.ukmParameters));
    }

    private static String getSimpleName(Class clazz) {
        String fullName = clazz.getName();
        return fullName.substring(fullName.lastIndexOf(46) + 1);
    }

    @Override
    protected byte[] calcSecret() {
        return this.result;
    }

    static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey key) throws InvalidKeyException {
        return key instanceof BCECPublicKey ? ((BCECGOST3410PublicKey)key).engineGetKeyParameters() : ECUtil.generatePublicKeyParameter(key);
    }

    public static class ECVKO
    extends KeyAgreementSpi {
        public ECVKO() {
            super("ECGOST3410", new ECVKOAgreement(new GOST3411Digest()), null);
        }
    }
}

