/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.jcajce.provider.asymmetric.ecgost;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import org.bouncycastle160.asn1.cryptopro.ECGOST3410NamedCurves;
import org.bouncycastle160.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle160.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle160.crypto.params.ECDomainParameters;
import org.bouncycastle160.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle160.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle160.crypto.params.ECPublicKeyParameters;
import org.bouncycastle160.jcajce.provider.asymmetric.ecgost.BCECGOST3410PrivateKey;
import org.bouncycastle160.jcajce.provider.asymmetric.ecgost.BCECGOST3410PublicKey;
import org.bouncycastle160.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle160.jce.provider.BouncyCastleProvider;
import org.bouncycastle160.jce.spec.ECNamedCurveGenParameterSpec;
import org.bouncycastle160.jce.spec.ECNamedCurveSpec;
import org.bouncycastle160.jce.spec.ECParameterSpec;
import org.bouncycastle160.math.ec.ECCurve;
import org.bouncycastle160.math.ec.ECPoint;

public class KeyPairGeneratorSpi
extends KeyPairGenerator {
    Object ecParams = null;
    ECKeyPairGenerator engine = new ECKeyPairGenerator();
    String algorithm = "ECGOST3410";
    ECKeyGenerationParameters param;
    int strength = 239;
    SecureRandom random = null;
    boolean initialised = false;

    public KeyPairGeneratorSpi() {
        super("ECGOST3410");
    }

    @Override
    public void initialize(int strength, SecureRandom random) {
        this.strength = strength;
        this.random = random;
        if (this.ecParams != null) {
            try {
                this.initialize((ECGenParameterSpec)this.ecParams, random);
            }
            catch (InvalidAlgorithmParameterException e) {
                throw new InvalidParameterException("key size not configurable.");
            }
        } else {
            throw new InvalidParameterException("unknown key size.");
        }
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (params instanceof ECParameterSpec) {
            ECParameterSpec p = (ECParameterSpec)params;
            this.ecParams = params;
            this.param = new ECKeyGenerationParameters(new ECDomainParameters(p.getCurve(), p.getG(), p.getN(), p.getH()), random);
            this.engine.init(this.param);
            this.initialised = true;
        } else if (params instanceof java.security.spec.ECParameterSpec) {
            java.security.spec.ECParameterSpec p = (java.security.spec.ECParameterSpec)params;
            this.ecParams = params;
            ECCurve curve = EC5Util.convertCurve(p.getCurve());
            ECPoint g = EC5Util.convertPoint(curve, p.getGenerator(), false);
            this.param = new ECKeyGenerationParameters(new ECDomainParameters(curve, g, p.getOrder(), BigInteger.valueOf(p.getCofactor())), random);
            this.engine.init(this.param);
            this.initialised = true;
        } else if (params instanceof ECGenParameterSpec || params instanceof ECNamedCurveGenParameterSpec) {
            String curveName = params instanceof ECGenParameterSpec ? ((ECGenParameterSpec)params).getName() : ((ECNamedCurveGenParameterSpec)params).getName();
            ECDomainParameters ecP = ECGOST3410NamedCurves.getByName(curveName);
            if (ecP == null) {
                throw new InvalidAlgorithmParameterException("unknown curve name: " + curveName);
            }
            this.ecParams = new ECNamedCurveSpec(curveName, ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
            java.security.spec.ECParameterSpec p = (java.security.spec.ECParameterSpec)this.ecParams;
            ECCurve curve = EC5Util.convertCurve(p.getCurve());
            ECPoint g = EC5Util.convertPoint(curve, p.getGenerator(), false);
            this.param = new ECKeyGenerationParameters(new ECDomainParameters(curve, g, p.getOrder(), BigInteger.valueOf(p.getCofactor())), random);
            this.engine.init(this.param);
            this.initialised = true;
        } else if (params == null && BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa() != null) {
            ECParameterSpec p = BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
            this.ecParams = params;
            this.param = new ECKeyGenerationParameters(new ECDomainParameters(p.getCurve(), p.getG(), p.getN(), p.getH()), random);
            this.engine.init(this.param);
            this.initialised = true;
        } else {
            if (params == null && BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa() == null) {
                throw new InvalidAlgorithmParameterException("null parameter passed but no implicitCA set");
            }
            throw new InvalidAlgorithmParameterException("parameter object not a ECParameterSpec: " + params.getClass().getName());
        }
    }

    @Override
    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            throw new IllegalStateException("EC Key Pair Generator not initialised");
        }
        AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
        ECPublicKeyParameters pub = (ECPublicKeyParameters)pair.getPublic();
        ECPrivateKeyParameters priv = (ECPrivateKeyParameters)pair.getPrivate();
        if (this.ecParams instanceof ECParameterSpec) {
            ECParameterSpec p = (ECParameterSpec)this.ecParams;
            BCECGOST3410PublicKey pubKey = new BCECGOST3410PublicKey(this.algorithm, pub, p);
            return new KeyPair(pubKey, new BCECGOST3410PrivateKey(this.algorithm, priv, pubKey, p));
        }
        if (this.ecParams == null) {
            return new KeyPair(new BCECGOST3410PublicKey(this.algorithm, pub), new BCECGOST3410PrivateKey(this.algorithm, priv));
        }
        java.security.spec.ECParameterSpec p = (java.security.spec.ECParameterSpec)this.ecParams;
        BCECGOST3410PublicKey pubKey = new BCECGOST3410PublicKey(this.algorithm, pub, p);
        return new KeyPair(pubKey, new BCECGOST3410PrivateKey(this.algorithm, priv, pubKey, p));
    }
}

