/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.jcajce.provider.asymmetric.gost;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle160.crypto.CryptoServicesRegistrar;
import org.bouncycastle160.crypto.generators.GOST3410ParametersGenerator;
import org.bouncycastle160.crypto.params.GOST3410Parameters;
import org.bouncycastle160.jcajce.provider.asymmetric.util.BaseAlgorithmParameterGeneratorSpi;
import org.bouncycastle160.jce.spec.GOST3410ParameterSpec;
import org.bouncycastle160.jce.spec.GOST3410PublicKeyParameterSetSpec;

public abstract class AlgorithmParameterGeneratorSpi
extends BaseAlgorithmParameterGeneratorSpi {
    protected SecureRandom random;
    protected int strength = 1024;

    @Override
    protected void engineInit(int strength, SecureRandom random) {
        this.strength = strength;
        this.random = random;
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for GOST3410 parameter generation.");
    }

    @Override
    protected AlgorithmParameters engineGenerateParameters() {
        AlgorithmParameters params;
        GOST3410ParametersGenerator pGen = new GOST3410ParametersGenerator();
        if (this.random != null) {
            pGen.init(this.strength, 2, this.random);
        } else {
            pGen.init(this.strength, 2, CryptoServicesRegistrar.getSecureRandom());
        }
        GOST3410Parameters p = pGen.generateParameters();
        try {
            params = this.createParametersInstance("GOST3410");
            params.init(new GOST3410ParameterSpec(new GOST3410PublicKeyParameterSetSpec(p.getP(), p.getQ(), p.getA())));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return params;
    }
}

