/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.jcajce.provider.digest;

import org.bouncycastle160.asn1.iso.ISOIECObjectIdentifiers;
import org.bouncycastle160.crypto.CipherKeyGenerator;
import org.bouncycastle160.crypto.digests.WhirlpoolDigest;
import org.bouncycastle160.crypto.macs.HMac;
import org.bouncycastle160.jcajce.provider.config.ConfigurableProvider;
import org.bouncycastle160.jcajce.provider.digest.BCMessageDigest;
import org.bouncycastle160.jcajce.provider.digest.DigestAlgorithmProvider;
import org.bouncycastle160.jcajce.provider.symmetric.util.BaseKeyGenerator;
import org.bouncycastle160.jcajce.provider.symmetric.util.BaseMac;

public class Whirlpool {
    private Whirlpool() {
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = Whirlpool.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("MessageDigest.WHIRLPOOL", PREFIX + "$Digest");
            provider.addAlgorithm("MessageDigest", ISOIECObjectIdentifiers.whirlpool, PREFIX + "$Digest");
            this.addHMACAlgorithm(provider, "WHIRLPOOL", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACWHIRLPOOL", 512, new CipherKeyGenerator());
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new WhirlpoolDigest()));
        }
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new WhirlpoolDigest());
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            Digest d = (Digest)super.clone();
            d.digest = new WhirlpoolDigest((WhirlpoolDigest)this.digest);
            return d;
        }
    }
}

