/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.jcajce.provider.symmetric;

import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle160.crypto.generators.OpenSSLPBEParametersGenerator;
import org.bouncycastle160.crypto.params.KeyParameter;
import org.bouncycastle160.jcajce.provider.config.ConfigurableProvider;
import org.bouncycastle160.jcajce.provider.symmetric.util.BaseSecretKeyFactory;
import org.bouncycastle160.jcajce.provider.util.AlgorithmProvider;
import org.bouncycastle160.util.Strings;

public final class OpenSSLPBKDF {
    private OpenSSLPBKDF() {
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = OpenSSLPBKDF.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("SecretKeyFactory.PBKDF-OPENSSL", PREFIX + "$PBKDF");
        }
    }

    public static class PBKDF
    extends BaseSecretKeyFactory {
        public PBKDF() {
            super("PBKDF-OpenSSL", null);
        }

        @Override
        protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof PBEKeySpec) {
                PBEKeySpec pbeSpec = (PBEKeySpec)keySpec;
                if (pbeSpec.getSalt() == null) {
                    throw new InvalidKeySpecException("missing required salt");
                }
                if (pbeSpec.getIterationCount() <= 0) {
                    throw new InvalidKeySpecException("positive iteration count required: " + pbeSpec.getIterationCount());
                }
                if (pbeSpec.getKeyLength() <= 0) {
                    throw new InvalidKeySpecException("positive key length required: " + pbeSpec.getKeyLength());
                }
                if (pbeSpec.getPassword().length == 0) {
                    throw new IllegalArgumentException("password empty");
                }
                OpenSSLPBEParametersGenerator pGen = new OpenSSLPBEParametersGenerator();
                pGen.init(Strings.toByteArray(pbeSpec.getPassword()), pbeSpec.getSalt());
                return new SecretKeySpec(((KeyParameter)pGen.generateDerivedParameters(pbeSpec.getKeyLength())).getKey(), "OpenSSLPBKDF");
            }
            throw new InvalidKeySpecException("Invalid KeySpec");
        }
    }
}

