/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.jce;

import java.util.Enumeration;
import org.bouncycastle160.asn1.ASN1ObjectIdentifier;
import org.bouncycastle160.asn1.x9.X9ECParameters;
import org.bouncycastle160.crypto.ec.CustomNamedCurves;
import org.bouncycastle160.jce.spec.ECNamedCurveParameterSpec;

public class ECNamedCurveTable {
    public static ECNamedCurveParameterSpec getParameterSpec(String name) {
        X9ECParameters ecP = CustomNamedCurves.getByName(name);
        if (ecP == null) {
            try {
                ecP = CustomNamedCurves.getByOID(new ASN1ObjectIdentifier(name));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (ecP == null && (ecP = org.bouncycastle160.asn1.x9.ECNamedCurveTable.getByName(name)) == null) {
                try {
                    ecP = org.bouncycastle160.asn1.x9.ECNamedCurveTable.getByOID(new ASN1ObjectIdentifier(name));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        if (ecP == null) {
            return null;
        }
        return new ECNamedCurveParameterSpec(name, ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
    }

    public static Enumeration getNames() {
        return org.bouncycastle160.asn1.x9.ECNamedCurveTable.getNames();
    }
}

