/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.jce;

import java.io.IOException;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import org.bouncycastle160.asn1.ASN1Primitive;
import org.bouncycastle160.asn1.x509.TBSCertList;
import org.bouncycastle160.asn1.x509.TBSCertificateStructure;
import org.bouncycastle160.asn1.x509.X509Name;
import org.bouncycastle160.jce.X509Principal;

public class PrincipalUtil {
    public static X509Principal getIssuerX509Principal(X509Certificate cert) throws CertificateEncodingException {
        try {
            TBSCertificateStructure tbsCert = TBSCertificateStructure.getInstance(ASN1Primitive.fromByteArray(cert.getTBSCertificate()));
            return new X509Principal(X509Name.getInstance(tbsCert.getIssuer()));
        }
        catch (IOException e) {
            throw new CertificateEncodingException(e.toString());
        }
    }

    public static X509Principal getSubjectX509Principal(X509Certificate cert) throws CertificateEncodingException {
        try {
            TBSCertificateStructure tbsCert = TBSCertificateStructure.getInstance(ASN1Primitive.fromByteArray(cert.getTBSCertificate()));
            return new X509Principal(X509Name.getInstance(tbsCert.getSubject()));
        }
        catch (IOException e) {
            throw new CertificateEncodingException(e.toString());
        }
    }

    public static X509Principal getIssuerX509Principal(X509CRL crl) throws CRLException {
        try {
            TBSCertList tbsCertList = TBSCertList.getInstance(ASN1Primitive.fromByteArray(crl.getTBSCertList()));
            return new X509Principal(X509Name.getInstance(tbsCertList.getIssuer()));
        }
        catch (IOException e) {
            throw new CRLException(e.toString());
        }
    }
}

