/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.pqc.crypto.mceliece;

import java.security.SecureRandom;
import org.bouncycastle160.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle160.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle160.crypto.CryptoServicesRegistrar;
import org.bouncycastle160.crypto.KeyGenerationParameters;
import org.bouncycastle160.pqc.crypto.mceliece.McElieceCCA2KeyGenerationParameters;
import org.bouncycastle160.pqc.crypto.mceliece.McElieceCCA2Parameters;
import org.bouncycastle160.pqc.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import org.bouncycastle160.pqc.crypto.mceliece.McElieceCCA2PublicKeyParameters;
import org.bouncycastle160.pqc.math.linearalgebra.GF2Matrix;
import org.bouncycastle160.pqc.math.linearalgebra.GF2mField;
import org.bouncycastle160.pqc.math.linearalgebra.GoppaCode;
import org.bouncycastle160.pqc.math.linearalgebra.Permutation;
import org.bouncycastle160.pqc.math.linearalgebra.PolynomialGF2mSmallM;

public class McElieceCCA2KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    public static final String OID = "1.3.6.1.4.1.8301.3.1.3.4.2";
    private McElieceCCA2KeyGenerationParameters mcElieceCCA2Params;
    private int m;
    private int n;
    private int t;
    private int fieldPoly;
    private SecureRandom random;
    private boolean initialized = false;

    private void initializeDefault() {
        McElieceCCA2KeyGenerationParameters mcCCA2Params = new McElieceCCA2KeyGenerationParameters(CryptoServicesRegistrar.getSecureRandom(), new McElieceCCA2Parameters());
        this.init(mcCCA2Params);
    }

    @Override
    public void init(KeyGenerationParameters param) {
        this.mcElieceCCA2Params = (McElieceCCA2KeyGenerationParameters)param;
        this.random = CryptoServicesRegistrar.getSecureRandom();
        this.m = this.mcElieceCCA2Params.getParameters().getM();
        this.n = this.mcElieceCCA2Params.getParameters().getN();
        this.t = this.mcElieceCCA2Params.getParameters().getT();
        this.fieldPoly = this.mcElieceCCA2Params.getParameters().getFieldPoly();
        this.initialized = true;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        if (!this.initialized) {
            this.initializeDefault();
        }
        GF2mField field = new GF2mField(this.m, this.fieldPoly);
        PolynomialGF2mSmallM gp = new PolynomialGF2mSmallM(field, this.t, 'I', this.random);
        GF2Matrix h = GoppaCode.createCanonicalCheckMatrix(field, gp);
        GoppaCode.MaMaPe mmp = GoppaCode.computeSystematicForm(h, this.random);
        GF2Matrix shortH = mmp.getSecondMatrix();
        Permutation p = mmp.getPermutation();
        GF2Matrix shortG = (GF2Matrix)shortH.computeTranspose();
        int k = shortG.getNumRows();
        McElieceCCA2PublicKeyParameters pubKey = new McElieceCCA2PublicKeyParameters(this.n, this.t, shortG, this.mcElieceCCA2Params.getParameters().getDigest());
        McElieceCCA2PrivateKeyParameters privKey = new McElieceCCA2PrivateKeyParameters(this.n, k, field, gp, p, this.mcElieceCCA2Params.getParameters().getDigest());
        return new AsymmetricCipherKeyPair(pubKey, privKey);
    }
}

