/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.pqc.jcajce.provider.mceliece;

import java.io.IOException;
import java.security.PrivateKey;
import org.bouncycastle160.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle160.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle160.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle160.pqc.asn1.McElieceCCA2PrivateKey;
import org.bouncycastle160.pqc.asn1.PQCObjectIdentifiers;
import org.bouncycastle160.pqc.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import org.bouncycastle160.pqc.jcajce.provider.mceliece.Utils;
import org.bouncycastle160.pqc.math.linearalgebra.GF2Matrix;
import org.bouncycastle160.pqc.math.linearalgebra.GF2mField;
import org.bouncycastle160.pqc.math.linearalgebra.Permutation;
import org.bouncycastle160.pqc.math.linearalgebra.PolynomialGF2mSmallM;

public class BCMcElieceCCA2PrivateKey
implements PrivateKey {
    private static final long serialVersionUID = 1L;
    private McElieceCCA2PrivateKeyParameters params;

    public BCMcElieceCCA2PrivateKey(McElieceCCA2PrivateKeyParameters params) {
        this.params = params;
    }

    @Override
    public String getAlgorithm() {
        return "McEliece-CCA2";
    }

    public int getN() {
        return this.params.getN();
    }

    public int getK() {
        return this.params.getK();
    }

    public int getT() {
        return this.params.getGoppaPoly().getDegree();
    }

    public GF2mField getField() {
        return this.params.getField();
    }

    public PolynomialGF2mSmallM getGoppaPoly() {
        return this.params.getGoppaPoly();
    }

    public Permutation getP() {
        return this.params.getP();
    }

    public GF2Matrix getH() {
        return this.params.getH();
    }

    public PolynomialGF2mSmallM[] getQInv() {
        return this.params.getQInv();
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof BCMcElieceCCA2PrivateKey)) {
            return false;
        }
        BCMcElieceCCA2PrivateKey otherKey = (BCMcElieceCCA2PrivateKey)other;
        return this.getN() == otherKey.getN() && this.getK() == otherKey.getK() && this.getField().equals(otherKey.getField()) && this.getGoppaPoly().equals(otherKey.getGoppaPoly()) && this.getP().equals(otherKey.getP()) && this.getH().equals(otherKey.getH());
    }

    public int hashCode() {
        int code = this.params.getK();
        code = code * 37 + this.params.getN();
        code = code * 37 + this.params.getField().hashCode();
        code = code * 37 + this.params.getGoppaPoly().hashCode();
        code = code * 37 + this.params.getP().hashCode();
        return code * 37 + this.params.getH().hashCode();
    }

    @Override
    public byte[] getEncoded() {
        try {
            McElieceCCA2PrivateKey privateKey = new McElieceCCA2PrivateKey(this.getN(), this.getK(), this.getField(), this.getGoppaPoly(), this.getP(), Utils.getDigAlgId(this.params.getDigest()));
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.mcElieceCca2);
            PrivateKeyInfo pki = new PrivateKeyInfo(algorithmIdentifier, privateKey);
            return pki.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    AsymmetricKeyParameter getKeyParams() {
        return this.params;
    }
}

