/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.pqc.jcajce.provider.mceliece;

import java.io.ByteArrayOutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import org.bouncycastle160.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle160.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle160.crypto.CipherParameters;
import org.bouncycastle160.crypto.Digest;
import org.bouncycastle160.crypto.InvalidCipherTextException;
import org.bouncycastle160.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle160.crypto.params.ParametersWithRandom;
import org.bouncycastle160.crypto.util.DigestFactory;
import org.bouncycastle160.pqc.crypto.mceliece.McElieceCCA2KeyParameters;
import org.bouncycastle160.pqc.crypto.mceliece.McElieceFujisakiCipher;
import org.bouncycastle160.pqc.jcajce.provider.mceliece.McElieceCCA2KeysToParams;
import org.bouncycastle160.pqc.jcajce.provider.util.AsymmetricHybridCipher;

public class McElieceFujisakiCipherSpi
extends AsymmetricHybridCipher
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    private Digest digest;
    private McElieceFujisakiCipher cipher;
    private ByteArrayOutputStream buf;

    protected McElieceFujisakiCipherSpi(Digest digest, McElieceFujisakiCipher cipher) {
        this.digest = digest;
        this.cipher = cipher;
        this.buf = new ByteArrayOutputStream();
    }

    @Override
    public byte[] update(byte[] input, int inOff, int inLen) {
        this.buf.write(input, inOff, inLen);
        return new byte[0];
    }

    @Override
    public byte[] doFinal(byte[] input, int inOff, int inLen) throws BadPaddingException {
        this.update(input, inOff, inLen);
        byte[] data = this.buf.toByteArray();
        this.buf.reset();
        if (this.opMode == 1) {
            return this.cipher.messageEncrypt(data);
        }
        if (this.opMode == 2) {
            try {
                return this.cipher.messageDecrypt(data);
            }
            catch (InvalidCipherTextException e) {
                throw new BadPaddingException(e.getMessage());
            }
        }
        throw new IllegalStateException("unknown mode in doFinal");
    }

    @Override
    protected int encryptOutputSize(int inLen) {
        return 0;
    }

    @Override
    protected int decryptOutputSize(int inLen) {
        return 0;
    }

    @Override
    protected void initCipherEncrypt(Key key, AlgorithmParameterSpec params, SecureRandom sr) throws InvalidKeyException, InvalidAlgorithmParameterException {
        CipherParameters param = McElieceCCA2KeysToParams.generatePublicKeyParameter((PublicKey)key);
        param = new ParametersWithRandom(param, sr);
        this.digest.reset();
        this.cipher.init(true, param);
    }

    @Override
    protected void initCipherDecrypt(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AsymmetricKeyParameter param = McElieceCCA2KeysToParams.generatePrivateKeyParameter((PrivateKey)key);
        this.digest.reset();
        this.cipher.init(false, param);
    }

    @Override
    public String getName() {
        return "McElieceFujisakiCipher";
    }

    @Override
    public int getKeySize(Key key) throws InvalidKeyException {
        McElieceCCA2KeyParameters mcElieceCCA2KeyParameters = key instanceof PublicKey ? (McElieceCCA2KeyParameters)McElieceCCA2KeysToParams.generatePublicKeyParameter((PublicKey)key) : (McElieceCCA2KeyParameters)McElieceCCA2KeysToParams.generatePrivateKeyParameter((PrivateKey)key);
        return this.cipher.getKeySize(mcElieceCCA2KeyParameters);
    }

    public static class McElieceFujisaki
    extends McElieceFujisakiCipherSpi {
        public McElieceFujisaki() {
            super(DigestFactory.createSHA1(), new McElieceFujisakiCipher());
        }
    }
}

