/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.pqc.math.linearalgebra;

import org.bouncycastle160.pqc.math.linearalgebra.GF2mField;
import org.bouncycastle160.pqc.math.linearalgebra.IntUtils;
import org.bouncycastle160.pqc.math.linearalgebra.Matrix;
import org.bouncycastle160.pqc.math.linearalgebra.Permutation;
import org.bouncycastle160.pqc.math.linearalgebra.Vector;

public class GF2mMatrix
extends Matrix {
    protected GF2mField field;
    protected int[][] matrix;

    public GF2mMatrix(GF2mField field, byte[] enc) {
        int d;
        this.field = field;
        int count = 1;
        for (d = 8; field.getDegree() > d; d += 8) {
            ++count;
        }
        if (enc.length < 5) {
            throw new IllegalArgumentException(" Error: given array is not encoded matrix over GF(2^m)");
        }
        this.numRows = (enc[3] & 0xFF) << 24 ^ (enc[2] & 0xFF) << 16 ^ (enc[1] & 0xFF) << 8 ^ enc[0] & 0xFF;
        int n = count * this.numRows;
        if (this.numRows <= 0 || (enc.length - 4) % n != 0) {
            throw new IllegalArgumentException(" Error: given array is not encoded matrix over GF(2^m)");
        }
        this.numColumns = (enc.length - 4) / n;
        this.matrix = new int[this.numRows][this.numColumns];
        count = 4;
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numColumns; ++j) {
                for (int jj = 0; jj < d; jj += 8) {
                    int[] nArray = this.matrix[i];
                    int n2 = j;
                    nArray[n2] = nArray[n2] ^ (enc[count++] & 0xFF) << jj;
                }
                if (this.field.isElementOfThisField(this.matrix[i][j])) continue;
                throw new IllegalArgumentException(" Error: given array is not encoded matrix over GF(2^m)");
            }
        }
    }

    public GF2mMatrix(GF2mMatrix other) {
        this.numRows = other.numRows;
        this.numColumns = other.numColumns;
        this.field = other.field;
        this.matrix = new int[this.numRows][];
        for (int i = 0; i < this.numRows; ++i) {
            this.matrix[i] = IntUtils.clone(other.matrix[i]);
        }
    }

    protected GF2mMatrix(GF2mField field, int[][] matrix) {
        this.field = field;
        this.matrix = matrix;
        this.numRows = matrix.length;
        this.numColumns = matrix[0].length;
    }

    @Override
    public byte[] getEncoded() {
        int d;
        int count = 1;
        for (d = 8; this.field.getDegree() > d; d += 8) {
            ++count;
        }
        byte[] bf = new byte[this.numRows * this.numColumns * count + 4];
        bf[0] = (byte)(this.numRows & 0xFF);
        bf[1] = (byte)(this.numRows >>> 8 & 0xFF);
        bf[2] = (byte)(this.numRows >>> 16 & 0xFF);
        bf[3] = (byte)(this.numRows >>> 24 & 0xFF);
        count = 4;
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numColumns; ++j) {
                for (int jj = 0; jj < d; jj += 8) {
                    bf[count++] = (byte)(this.matrix[i][j] >>> jj);
                }
            }
        }
        return bf;
    }

    @Override
    public boolean isZero() {
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numColumns; ++j) {
                if (this.matrix[i][j] == 0) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Matrix computeInverse() {
        int i;
        if (this.numRows != this.numColumns) {
            throw new ArithmeticException("Matrix is not invertible.");
        }
        int[][] tmpMatrix = new int[this.numRows][this.numRows];
        for (int i2 = this.numRows - 1; i2 >= 0; --i2) {
            tmpMatrix[i2] = IntUtils.clone(this.matrix[i2]);
        }
        int[][] invMatrix = new int[this.numRows][this.numRows];
        for (i = this.numRows - 1; i >= 0; --i) {
            invMatrix[i][i] = 1;
        }
        for (i = 0; i < this.numRows; ++i) {
            if (tmpMatrix[i][i] == 0) {
                boolean foundNonZero = false;
                for (int j = i + 1; j < this.numRows; ++j) {
                    if (tmpMatrix[j][i] == 0) continue;
                    foundNonZero = true;
                    GF2mMatrix.swapColumns(tmpMatrix, i, j);
                    GF2mMatrix.swapColumns(invMatrix, i, j);
                    j = this.numRows;
                }
                if (!foundNonZero) {
                    throw new ArithmeticException("Matrix is not invertible.");
                }
            }
            int coef = tmpMatrix[i][i];
            int invCoef = this.field.inverse(coef);
            this.multRowWithElementThis(tmpMatrix[i], invCoef);
            this.multRowWithElementThis(invMatrix[i], invCoef);
            for (int j = 0; j < this.numRows; ++j) {
                if (j == i || (coef = tmpMatrix[j][i]) == 0) continue;
                int[] tmpRow = this.multRowWithElement(tmpMatrix[i], coef);
                int[] tmpInvRow = this.multRowWithElement(invMatrix[i], coef);
                this.addToRow(tmpRow, tmpMatrix[j]);
                this.addToRow(tmpInvRow, invMatrix[j]);
            }
        }
        return new GF2mMatrix(this.field, invMatrix);
    }

    private static void swapColumns(int[][] matrix, int first, int second) {
        int[] tmp = matrix[first];
        matrix[first] = matrix[second];
        matrix[second] = tmp;
    }

    private void multRowWithElementThis(int[] row, int element) {
        for (int i = row.length - 1; i >= 0; --i) {
            row[i] = this.field.mult(row[i], element);
        }
    }

    private int[] multRowWithElement(int[] row, int element) {
        int[] result = new int[row.length];
        for (int i = row.length - 1; i >= 0; --i) {
            result[i] = this.field.mult(row[i], element);
        }
        return result;
    }

    private void addToRow(int[] fromRow, int[] toRow) {
        for (int i = toRow.length - 1; i >= 0; --i) {
            toRow[i] = this.field.add(fromRow[i], toRow[i]);
        }
    }

    @Override
    public Matrix rightMultiply(Matrix a) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public Matrix rightMultiply(Permutation perm) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public Vector leftMultiply(Vector vector) {
        throw new RuntimeException("Not implemented.");
    }

    @Override
    public Vector rightMultiply(Vector vector) {
        throw new RuntimeException("Not implemented.");
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof GF2mMatrix)) {
            return false;
        }
        GF2mMatrix otherMatrix = (GF2mMatrix)other;
        if (!this.field.equals(otherMatrix.field) || otherMatrix.numRows != this.numColumns || otherMatrix.numColumns != this.numColumns) {
            return false;
        }
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numColumns; ++j) {
                if (this.matrix[i][j] == otherMatrix.matrix[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hash = (this.field.hashCode() * 31 + this.numRows) * 31 + this.numColumns;
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numColumns; ++j) {
                hash = hash * 31 + this.matrix[i][j];
            }
        }
        return hash;
    }

    @Override
    public String toString() {
        String str = this.numRows + " x " + this.numColumns + " Matrix over " + this.field.toString() + ": \n";
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numColumns; ++j) {
                str = str + this.field.elementToStr(this.matrix[i][j]) + " : ";
            }
            str = str + "\n";
        }
        return str;
    }
}

