/*
 * Decompiled with CFR 0.152.
 */
package cn.didi.union.client.impl;

import cn.didi.union.auth.Auth;
import cn.didi.union.auth.Uuid;
import cn.didi.union.client.BasicClient;
import cn.didi.union.common.Constants;
import cn.didi.union.models.DunionClientConfig;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.TreeMap;
import org.slf4j.Logger;

public class BasicClientImpl
implements BasicClient {
    private static final Logger LOGGER = Constants.dunionClientLogger;
    private static final String DIDI_HEADER_RID = "Didi-Header-Rid";
    private static final String USER_AGENT = "User-Agent";
    private static final String SDK_VERSION = "dunion-go-openapi-sdk-1.0";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String doPost(DunionClientConfig dunionClientConfig, String urlPath, int timeout, TreeMap<String, Object> params) {
        HttpURLConnection connection = null;
        StringBuilder msg = new StringBuilder();
        TreeMap<String, Object> headers = new TreeMap<String, Object>();
        LOGGER.info("doPost start, dunionClientConfig:{}, urlPath:{},timeout:{}, params:{}", new Object[]{dunionClientConfig.toString(), urlPath, timeout, params.toString()});
        headers.put("App-Key", dunionClientConfig.getAppKey());
        headers.put("Timestamp", (int)(System.currentTimeMillis() / 1000L));
        String sign = Auth.genSign(headers, params, dunionClientConfig.getAccessKey());
        headers.put(DIDI_HEADER_RID, Uuid.getUUID());
        URL url = new URL(urlPath);
        connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty(USER_AGENT, SDK_VERSION);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setRequestProperty("Sign", sign);
        for (String key : headers.keySet()) {
            connection.setRequestProperty(key, headers.get(key).toString());
        }
        int configTimeout = dunionClientConfig.getTimeout();
        if (timeout != 0) {
            configTimeout = timeout;
        }
        connection.setConnectTimeout(configTimeout);
        connection.connect();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8));
        String json = new Gson().toJson(params);
        writer.write(json);
        writer.close();
        DataOutputStream out = new DataOutputStream(connection.getOutputStream());
        out.flush();
        out.close();
        int code = connection.getResponseCode();
        if (code == 200) {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = reader.readLine()) != null) {
                msg.append(line).append("\n");
            }
            reader.close();
        }
        LOGGER.info("doPost get result, urlPath:{}, configTimeout:{}, headers:{}, msg:{}", new Object[]{urlPath, configTimeout, headers, msg});
        if (null == connection) return msg.toString();
        try {
            connection.disconnect();
            return msg.toString();
        }
        catch (Exception e) {
            LOGGER.error("doPost connection close error, urlPath:{}, headers:{}, error:{}", new Object[]{urlPath, headers, e.getMessage()});
        }
        return msg.toString();
        catch (Exception e) {
            try {
                LOGGER.error("doPost error, urlPath:{}, headers:{}, error:{}", new Object[]{urlPath, headers, e.getMessage()});
                if (null == connection) return msg.toString();
            }
            catch (Throwable throwable) {
                if (null == connection) throw throwable;
                try {
                    connection.disconnect();
                    throw throwable;
                }
                catch (Exception e2) {
                    LOGGER.error("doPost connection close error, urlPath:{}, headers:{}, error:{}", new Object[]{urlPath, headers, e2.getMessage()});
                }
                throw throwable;
            }
            try {
                connection.disconnect();
                return msg.toString();
            }
            catch (Exception e3) {
                LOGGER.error("doPost connection close error, urlPath:{}, headers:{}, error:{}", new Object[]{urlPath, headers, e3.getMessage()});
            }
            return msg.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String doGet(DunionClientConfig dunionClientConfig, String urlPath, int timeout, TreeMap<String, Object> params) {
        HttpURLConnection connection = null;
        StringBuilder msg = new StringBuilder();
        TreeMap<String, Object> headers = new TreeMap<String, Object>();
        LOGGER.info("doGet start, dunionClientConfig:{}, urlPath:{}, timeout:{}, params:{}", new Object[]{dunionClientConfig.toString(), urlPath, timeout, params.toString()});
        headers.put("App-Key", dunionClientConfig.getAppKey());
        headers.put("Timestamp", (int)(System.currentTimeMillis() / 1000L));
        String sign = Auth.genSign(headers, params, dunionClientConfig.getAccessKey());
        String uuid = Uuid.getUUID();
        headers.put(DIDI_HEADER_RID, uuid);
        StringBuilder sb = new StringBuilder();
        sb.append(urlPath);
        sb.append("?");
        for (String key : params.keySet()) {
            sb.append("&").append(key).append("=").append(params.get(key));
        }
        String str = sb.toString().replaceFirst("&", "");
        URL url = new URL(str);
        connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        int configTimeout = dunionClientConfig.getTimeout();
        if (timeout != 0) {
            configTimeout = timeout;
        }
        connection.setConnectTimeout(configTimeout);
        connection.setRequestProperty("Sign", sign);
        for (String key : headers.keySet()) {
            connection.setRequestProperty(key, headers.get(key).toString());
        }
        connection.setRequestProperty(USER_AGENT, SDK_VERSION);
        connection.connect();
        if (connection.getResponseCode() == 200) {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = reader.readLine()) != null) {
                msg.append(line).append("\n");
            }
            reader.close();
        }
        LOGGER.info("doGet get result, urlPath:{}, configTimeout:{}, headers:{}, msg:{}", new Object[]{urlPath, configTimeout, headers, msg});
        if (null == connection) return msg.toString();
        try {
            connection.disconnect();
            return msg.toString();
        }
        catch (Exception e) {
            LOGGER.error("doGet connection close error, urlPath:{}, headers:{}, error:{}", new Object[]{urlPath, headers, e.getMessage()});
        }
        return msg.toString();
        catch (Exception e) {
            try {
                LOGGER.error("doGet error, urlPath:{}, headers:{}, error:{}", new Object[]{urlPath, headers, e.getMessage()});
                if (null == connection) return msg.toString();
            }
            catch (Throwable throwable) {
                if (null == connection) throw throwable;
                try {
                    connection.disconnect();
                    throw throwable;
                }
                catch (Exception e2) {
                    LOGGER.error("doGet connection close error, urlPath:{}, headers:{}, error:{}", new Object[]{urlPath, headers, e2.getMessage()});
                }
                throw throwable;
            }
            try {
                connection.disconnect();
                return msg.toString();
            }
            catch (Exception e3) {
                LOGGER.error("doGet connection close error, urlPath:{}, headers:{}, error:{}", new Object[]{urlPath, headers, e3.getMessage()});
            }
            return msg.toString();
        }
    }
}

