/*
 * Decompiled with CFR 0.152.
 */
package cn.didi.union.client.impl;

import cn.didi.union.client.BasicClient;
import cn.didi.union.client.DunionClientFactory;
import cn.didi.union.client.UnionClient;
import cn.didi.union.client.impl.UnionClientImpl;
import cn.didi.union.models.DunionClientConfig;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public class DunionClientFactoryImpl
implements DunionClientFactory {
    private final DunionClientConfig dunionClientConfig;
    private final AtomicReference<UnionClient> unionClientRef = new AtomicReference();

    public DunionClientFactoryImpl(DunionClientConfig dunionClientConfig) {
        this.dunionClientConfig = dunionClientConfig;
    }

    @Override
    public UnionClient getUnionClient() {
        return this.newClient(this.unionClientRef, UnionClientImpl::new);
    }

    private synchronized <T extends BasicClient> T newClient(AtomicReference<T> reference, Function<DunionClientConfig, T> factory) {
        BasicClient client = (BasicClient)reference.get();
        if (Objects.isNull(client)) {
            client = (BasicClient)factory.apply(this.dunionClientConfig);
            reference.lazySet(client);
        }
        return (T)client;
    }
}

