/*
 * Decompiled with CFR 0.152.
 */
package cn.didi.union.client.impl;

import cn.didi.union.client.UnionClient;
import cn.didi.union.client.impl.BasicClientImpl;
import cn.didi.union.common.Constants;
import cn.didi.union.enums.LinkType;
import cn.didi.union.enums.OrderMockType;
import cn.didi.union.enums.OrderType;
import cn.didi.union.enums.PwdType;
import cn.didi.union.errors.BizError;
import cn.didi.union.errors.ParamError;
import cn.didi.union.errors.SystemError;
import cn.didi.union.models.DunionClientConfig;
import cn.didi.union.models.ExchangePwdResponse;
import cn.didi.union.models.LinkResponse;
import cn.didi.union.models.OrderCallbackResponse;
import cn.didi.union.models.OrderResponse;
import cn.didi.union.models.OrderSelfQueryResponse;
import cn.didi.union.models.PosterResponse;
import cn.didi.union.models.QrCodeResponse;
import cn.didi.union.models.Result;
import com.google.gson.Gson;
import java.util.TreeMap;
import org.slf4j.Logger;

public class UnionClientImpl
extends BasicClientImpl
implements UnionClient {
    private static final Logger LOGGER = Constants.dunionClientLogger;
    private final DunionClientConfig dunionClientConfig;
    private static final String linkPath = "https://union.didi.cn/openapi/v1.0/link/generate";
    private static final String codePath = "https://union.didi.cn/openapi/v1.0/code/generate";
    private static final String posterPath = "https://union.didi.cn/openapi/v1.0/poster/generate";
    private static final String exchangePwdPath = "https://union.didi.cn/openapi/v1.0/exchange/pwd/generate";
    private static final String orderListPath = "https://union.didi.cn/openapi/v1.0/order/list";
    private static final String orderMockPath = "https://union.didi.cn/openapi/v1.0/orderMock/callback";
    private static final String orderSelfQueryPath = "https://union.didi.cn/openapi/v1.0/order/selfQuery";

    public UnionClientImpl(DunionClientConfig dunionClientConfig) {
        this.dunionClientConfig = dunionClientConfig;
    }

    @Override
    public Result<LinkResponse> generateH5Link(long activityId, long promotionId, String sourceId, int timeout) {
        try {
            TreeMap<String, Object> params = new TreeMap<String, Object>();
            params.put("activity_id", activityId);
            params.put("promotion_id", promotionId);
            params.put("source_id", sourceId);
            params.put("link_type", LinkType.H5.getValue());
            String resultStr = this.doPost(this.dunionClientConfig, linkPath, timeout, params);
            if (resultStr != null && !resultStr.equals("")) {
                LinkResponse model = (LinkResponse)new Gson().fromJson(resultStr, LinkResponse.class);
                return Result.Builder.builder().success(true).model(model).build();
            }
            LOGGER.error("generateH5Link fail");
            return Result.Builder.builder().success(false).error(new SystemError("generateH5Link fail")).model(null).build();
        }
        catch (Exception e) {
            LOGGER.error("generateH5Link error:{}", (Object)e.getMessage());
            return Result.Builder.builder().success(false).error(new BizError(e.getMessage())).model(null).build();
        }
    }

    @Override
    public Result<LinkResponse> generateMiniLink(long activityId, long promotionId, String sourceId, int timeout) {
        try {
            TreeMap<String, Object> params = new TreeMap<String, Object>();
            params.put("activity_id", activityId);
            params.put("promotion_id", promotionId);
            params.put("source_id", sourceId);
            params.put("link_type", LinkType.Mini.getValue());
            String resultStr = this.doPost(this.dunionClientConfig, linkPath, timeout, params);
            if (resultStr != null && !resultStr.equals("")) {
                LinkResponse model = (LinkResponse)new Gson().fromJson(resultStr, LinkResponse.class);
                return Result.Builder.builder().success(true).error(null).model(model).build();
            }
            LOGGER.error("generateMiniLink fail");
            return Result.Builder.builder().success(false).error(new SystemError("generateMiniLink fail")).model(null).build();
        }
        catch (Exception e) {
            LOGGER.error("generateMiniLink error:{}", (Object)e.getMessage());
            return Result.Builder.builder().success(false).error(new BizError(e.getMessage())).model(null).build();
        }
    }

    @Override
    public Result<QrCodeResponse> generateH5Code(String dsi, String sourceId, int timeout) {
        try {
            TreeMap<String, Object> params = new TreeMap<String, Object>();
            params.put("dsi", dsi);
            params.put("source_id", sourceId);
            params.put("type", LinkType.H5.getValue());
            String resultStr = this.doGet(this.dunionClientConfig, codePath, timeout, params);
            if (resultStr != null && !resultStr.equals("")) {
                QrCodeResponse model = (QrCodeResponse)new Gson().fromJson(resultStr, QrCodeResponse.class);
                return Result.Builder.builder().success(true).error(null).model(model).build();
            }
            LOGGER.error("generateH5Code fail");
            return Result.Builder.builder().success(false).error(new SystemError("generateH5Code fail")).model(null).build();
        }
        catch (Exception e) {
            LOGGER.error("generateH5Code error:{}", (Object)e.getMessage());
            return Result.Builder.builder().success(false).error(new BizError(e.getMessage())).model(null).build();
        }
    }

    @Override
    public Result<QrCodeResponse> generateMiniCode(String dsi, String sourceId, int timeout) {
        try {
            TreeMap<String, Object> params = new TreeMap<String, Object>();
            params.put("dsi", dsi);
            params.put("source_id", sourceId);
            params.put("type", LinkType.Mini.getValue());
            String resultStr = this.doGet(this.dunionClientConfig, codePath, timeout, params);
            if (resultStr != null && !resultStr.equals("")) {
                QrCodeResponse model = (QrCodeResponse)new Gson().fromJson(resultStr, QrCodeResponse.class);
                return Result.Builder.builder().success(true).error(null).model(model).build();
            }
            LOGGER.error("generateMiniCode fail");
            return Result.Builder.builder().success(false).error(new SystemError("generateMiniCode fail")).model(null).build();
        }
        catch (Exception e) {
            LOGGER.error("generateMiniCode error:{}", (Object)e.getMessage());
            return Result.Builder.builder().success(false).error(new BizError(e.getMessage())).model(null).build();
        }
    }

    @Override
    public Result<PosterResponse> generatePoster(String dsi, String sourceId, int timeout) {
        try {
            TreeMap<String, Object> params = new TreeMap<String, Object>();
            params.put("dsi", dsi);
            params.put("source_id", sourceId);
            String resultStr = this.doGet(this.dunionClientConfig, posterPath, timeout, params);
            if (resultStr != null && !resultStr.equals("")) {
                PosterResponse model = (PosterResponse)new Gson().fromJson(resultStr, PosterResponse.class);
                return Result.Builder.builder().success(true).error(null).model(model).build();
            }
            LOGGER.error("generatePoster fail");
            return Result.Builder.builder().success(false).error(new SystemError("generatePoster fail")).model(null).build();
        }
        catch (Exception e) {
            LOGGER.error("generatePoster error:{}", (Object)e.getMessage());
            return Result.Builder.builder().success(false).error(new BizError(e.getMessage())).model(null).build();
        }
    }

    @Override
    public Result<ExchangePwdResponse> generateCouponPwd(long activityId, long promotionId, String sourceId, int timeout) {
        try {
            TreeMap<String, Object> params = new TreeMap<String, Object>();
            params.put("activity_id", activityId);
            params.put("promotion_id", promotionId);
            params.put("source_id", sourceId);
            params.put("pwd_type", PwdType.Coupon.getValue());
            String resultStr = this.doGet(this.dunionClientConfig, exchangePwdPath, timeout, params);
            if (resultStr != null && !resultStr.equals("")) {
                ExchangePwdResponse model = (ExchangePwdResponse)new Gson().fromJson(resultStr, ExchangePwdResponse.class);
                return Result.Builder.builder().success(true).model(model).build();
            }
            LOGGER.error("generateCouponPwd fail");
            return Result.Builder.builder().success(false).error(new SystemError("generateCouponPwd fail")).model(null).build();
        }
        catch (Exception e) {
            LOGGER.error("generateCouponPwd error:{}", (Object)e.getMessage());
            return Result.Builder.builder().success(false).error(new BizError(e.getMessage())).model(null).build();
        }
    }

    @Override
    public Result<QrCodeResponse> generateH5CodeDirectly(long activityId, long promotionId, String sourceId, int timeout) {
        try {
            Result<LinkResponse> linkResult = this.getLinkResult(activityId, promotionId, sourceId, timeout);
            if (linkResult != null && linkResult.getModel() != null && linkResult.getModel().getData() != null) {
                return this.generateH5Code(linkResult.getModel().getData().getDsi(), sourceId, timeout);
            }
            LOGGER.error("generateH5CodeDirectly fail");
            return Result.Builder.builder().success(false).error(new SystemError("generateH5CodeDirectly fail")).model(null).build();
        }
        catch (Exception e) {
            LOGGER.error("generateH5CodeDirectly error:{}", (Object)e.getMessage());
            return Result.Builder.builder().success(false).error(new BizError(e.getMessage())).model(null).build();
        }
    }

    @Override
    public Result<QrCodeResponse> generateMiniCodeDirectly(long activityId, long promotionId, String sourceId, int timeout) {
        try {
            Result<LinkResponse> linkResult = this.getLinkResult(activityId, promotionId, sourceId, timeout);
            if (linkResult != null && linkResult.getModel() != null && linkResult.getModel().getData() != null) {
                return this.generateMiniCode(linkResult.getModel().getData().getDsi(), sourceId, timeout);
            }
            LOGGER.error("generateMiniCodeDirectly fail");
            return Result.Builder.builder().success(false).error(new SystemError("generateMiniCodeDirectly fail")).model(null).build();
        }
        catch (Exception e) {
            LOGGER.error("generateMiniCodeDirectly error:{}", (Object)e.getMessage());
            return Result.Builder.builder().success(false).error(new BizError(e.getMessage())).model(null).build();
        }
    }

    @Override
    public Result<PosterResponse> generatePosterDirectly(long activityId, long promotionId, String sourceId, int timeout) {
        try {
            Result<LinkResponse> linkResult = this.generateMiniLink(activityId, promotionId, sourceId, timeout);
            if (linkResult == null) {
                return Result.Builder.builder().success(false).error(new BizError("get link fail")).model(null).build();
            }
            if (!linkResult.isSuccess()) {
                return Result.Builder.builder().success(false).error(linkResult.getError()).model(null).build();
            }
            if (linkResult.getModel() != null && linkResult.getModel().getData() != null) {
                return this.generatePoster(linkResult.getModel().getData().getDsi(), sourceId, timeout);
            }
            LOGGER.error("generatePosterDirectly fail");
            return Result.Builder.builder().success(false).error(new SystemError("generatePosterDirectly fail")).model(null).build();
        }
        catch (Exception e) {
            LOGGER.error("generatePosterDirectly error:{}", (Object)e.getMessage());
            return Result.Builder.builder().success(false).error(new BizError(e.getMessage())).model(null).build();
        }
    }

    public Result<LinkResponse> getLinkResult(long activityId, long promotionId, String sourceId, int timeout) {
        LOGGER.info("generateCodeDirectly start, activityId:{}, promotionId:{}, sourceId:{}", new Object[]{activityId, promotionId, sourceId});
        Result<LinkResponse> linkResult = this.generateMiniLink(activityId, promotionId, sourceId, timeout);
        if (linkResult == null) {
            return Result.Builder.builder().success(false).error(new BizError("get link fail")).model(null).build();
        }
        if (!linkResult.isSuccess()) {
            return Result.Builder.builder().success(false).error(linkResult.getError()).model(null).build();
        }
        return linkResult;
    }

    @Override
    public Result<OrderResponse> queryOrderList(long startTime, long endTime, OrderType type, int page, int size, int timeout) {
        if (page <= 0 || page > 100 || size <= 0 || size > 100) {
            return Result.Builder.builder().success(false).error(new ParamError("\u5206\u9875\u53c2\u6570\u4e0d\u5408\u6cd5")).model(null).build();
        }
        try {
            String resultStr;
            TreeMap<String, Object> params = new TreeMap<String, Object>();
            params.put("pay_start_time", startTime);
            params.put("pay_end_time", endTime);
            params.put("page", page);
            params.put("size", size);
            if (type != null && OrderType.All != type) {
                params.put("type", type.getValue());
            }
            if ((resultStr = this.doGet(this.dunionClientConfig, orderListPath, timeout, params)) != null && !resultStr.equals("")) {
                OrderResponse model = (OrderResponse)new Gson().fromJson(resultStr, OrderResponse.class);
                return Result.Builder.builder().success(true).error(null).model(model).build();
            }
            LOGGER.error("queryOrderList fail");
            return Result.Builder.builder().success(false).error(new SystemError("queryOrderList fail")).model(null).build();
        }
        catch (Exception e) {
            LOGGER.error("queryOrderList error:{}", (Object)e.getMessage());
            return Result.Builder.builder().success(false).error(new BizError(e.getMessage())).model(null).build();
        }
    }

    @Override
    public Result<OrderCallbackResponse> mockOrderCallback(String dsi, String sourceId, OrderMockType type, int timeout) {
        if (type == null) {
            return Result.Builder.builder().success(false).error(new ParamError("\u5206\u9875\u53c2\u6570\u4e0d\u5408\u6cd5")).model(null).build();
        }
        try {
            TreeMap<String, Object> params = new TreeMap<String, Object>();
            params.put("dsi", dsi);
            params.put("source_id", sourceId);
            params.put("type", type.getValue());
            String resultStr = this.doGet(this.dunionClientConfig, orderMockPath, timeout, params);
            if (resultStr != null && !resultStr.equals("")) {
                OrderCallbackResponse model = (OrderCallbackResponse)new Gson().fromJson(resultStr, OrderCallbackResponse.class);
                return Result.Builder.builder().success(true).error(null).model(model).build();
            }
            LOGGER.error("mockOrderCallback fail");
            return Result.Builder.builder().success(false).error(new SystemError("mockOrderCallback fail")).model(null).build();
        }
        catch (Exception e) {
            LOGGER.error("mockOrderCallback error:{}", (Object)e.getMessage());
            return Result.Builder.builder().success(false).error(new BizError(e.getMessage())).model(null).build();
        }
    }

    @Override
    public Result<OrderSelfQueryResponse> selfQueryOrder(String orderId, int timeout) {
        try {
            TreeMap<String, Object> params = new TreeMap<String, Object>();
            params.put("order_id", orderId);
            String resultStr = this.doGet(this.dunionClientConfig, orderSelfQueryPath, timeout, params);
            if (resultStr != null && !resultStr.equals("")) {
                OrderSelfQueryResponse model = (OrderSelfQueryResponse)new Gson().fromJson(resultStr, OrderSelfQueryResponse.class);
                return Result.Builder.builder().success(true).error(null).model(model).build();
            }
            LOGGER.error("selfQueryOrder fail");
            return Result.Builder.builder().success(false).error(new SystemError("selfQueryOrder fail")).model(null).build();
        }
        catch (Exception e) {
            LOGGER.error("selfQueryOrder error:{}", (Object)e.getMessage());
            return Result.Builder.builder().success(false).error(new BizError(e.getMessage())).model(null).build();
        }
    }
}

