/*
 * Decompiled with CFR 0.152.
 */
package cn.didi.union.models;

public class DunionClientConfig {
    private final String appKey;
    private final String accessKey;
    private final int timeout;

    DunionClientConfig(Builder builder) {
        this.appKey = builder.appKey;
        this.accessKey = builder.accessKey;
        this.timeout = builder.timeout;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String toString() {
        return this.getClass().getName() + ",appKey:" + this.getAppKey() + ",accessKey:" + this.getAccessKey() + ",timeout:" + this.getTimeout();
    }

    public static class Builder {
        private String appKey;
        private String accessKey;
        private int timeout;

        public Builder builder() {
            return new Builder();
        }

        public Builder appKey(String appKey) {
            this.appKey = appKey;
            return this;
        }

        public Builder accessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        public Builder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public DunionClientConfig build() {
            if (this.timeout == 0) {
                this.timeout = 2000;
            }
            return new DunionClientConfig(this);
        }
    }
}

