/*
 * Decompiled with CFR 0.152.
 */
package cn.didi.union.models;

import cn.didi.union.errors.ErrorBase;

public class Result<T> {
    private final boolean success;
    private final ErrorBase error;
    private final T model;

    Result(Builder<T> builder) {
        this.success = ((Builder)builder).success;
        this.error = ((Builder)builder).error;
        this.model = ((Builder)builder).model;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public ErrorBase getError() {
        return this.error;
    }

    public T getModel() {
        return this.model;
    }

    public static class Builder<T> {
        private boolean success;
        private ErrorBase error;
        private T model;

        private Builder() {
        }

        public static <K> Builder<K> builder() {
            return new Builder();
        }

        public Builder<T> success(boolean success) {
            this.success = success;
            return this;
        }

        public Builder<T> error(ErrorBase error) {
            this.error = error;
            return this;
        }

        public Builder<T> model(T model) {
            this.model = model;
            return this;
        }

        public Result<T> build() {
            return new Result(this);
        }
    }
}

