/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.dataframe;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.client.ml.NodeAttributes;
import org.elasticsearch.client.ml.dataframe.DataFrameAnalyticsState;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.inject.internal.ToStringBuilder;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;

public class DataFrameAnalyticsStats {
    static final ParseField ID = new ParseField("id", new String[0]);
    static final ParseField STATE = new ParseField("state", new String[0]);
    static final ParseField FAILURE_REASON = new ParseField("failure_reason", new String[0]);
    static final ParseField PROGRESS_PERCENT = new ParseField("progress_percent", new String[0]);
    static final ParseField NODE = new ParseField("node", new String[0]);
    static final ParseField ASSIGNMENT_EXPLANATION = new ParseField("assignment_explanation", new String[0]);
    private static final ConstructingObjectParser<DataFrameAnalyticsStats, Void> PARSER = new ConstructingObjectParser("data_frame_analytics_stats", true, args -> new DataFrameAnalyticsStats((String)args[0], (DataFrameAnalyticsState)((Object)((Object)args[1])), (String)args[2], (Integer)args[3], (NodeAttributes)args[4], (String)args[5]));
    private final String id;
    private final DataFrameAnalyticsState state;
    private final String failureReason;
    private final Integer progressPercent;
    private final NodeAttributes node;
    private final String assignmentExplanation;

    public static DataFrameAnalyticsStats fromXContent(XContentParser parser) throws IOException {
        return (DataFrameAnalyticsStats)PARSER.parse(parser, null);
    }

    public DataFrameAnalyticsStats(String id, DataFrameAnalyticsState state, @Nullable String failureReason, @Nullable Integer progressPercent, @Nullable NodeAttributes node, @Nullable String assignmentExplanation) {
        this.id = id;
        this.state = state;
        this.failureReason = failureReason;
        this.progressPercent = progressPercent;
        this.node = node;
        this.assignmentExplanation = assignmentExplanation;
    }

    public String getId() {
        return this.id;
    }

    public DataFrameAnalyticsState getState() {
        return this.state;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public Integer getProgressPercent() {
        return this.progressPercent;
    }

    public NodeAttributes getNode() {
        return this.node;
    }

    public String getAssignmentExplanation() {
        return this.assignmentExplanation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataFrameAnalyticsStats other = (DataFrameAnalyticsStats)o;
        return Objects.equals(this.id, other.id) && Objects.equals((Object)this.state, (Object)other.state) && Objects.equals(this.failureReason, other.failureReason) && Objects.equals(this.progressPercent, other.progressPercent) && Objects.equals(this.node, other.node) && Objects.equals(this.assignmentExplanation, other.assignmentExplanation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.state, this.failureReason, this.progressPercent, this.node, this.assignmentExplanation});
    }

    public String toString() {
        return new ToStringBuilder(this.getClass()).add("id", (Object)this.id).add("state", (Object)this.state).add("failureReason", (Object)this.failureReason).add("progressPercent", (Object)this.progressPercent).add("node", (Object)this.node).add("assignmentExplanation", (Object)this.assignmentExplanation).toString();
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ID);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return DataFrameAnalyticsState.fromString(p.text());
            }
            throw new IllegalArgumentException("Unsupported token [" + p.currentToken() + "]");
        }, STATE, ObjectParser.ValueType.STRING);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), FAILURE_REASON);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), PROGRESS_PERCENT);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), NodeAttributes.PARSER, NODE);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), ASSIGNMENT_EXPLANATION);
    }
}

