/*
 * Decompiled with CFR 0.152.
 */
package org.eluder.coveralls.maven.plugin.source;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eluder.coveralls.maven.plugin.ProcessingException;
import org.eluder.coveralls.maven.plugin.domain.Source;
import org.eluder.coveralls.maven.plugin.source.SourceCallback;

public class UniqueSourceCallback
implements SourceCallback {
    private final Map<Source, Source> cache = new LinkedHashMap<Source, Source>();
    private final SourceCallback delegate;

    public UniqueSourceCallback(SourceCallback delegate) {
        this.delegate = delegate;
    }

    @Override
    public void onBegin() throws ProcessingException, IOException {
        this.delegate.onBegin();
    }

    @Override
    public void onSource(Source source) throws ProcessingException, IOException {
        Source merged = source.merge(this.cache.get(source));
        this.cache.put(merged, merged);
    }

    @Override
    public void onComplete() throws ProcessingException, IOException {
        for (Source source : this.cache.values()) {
            this.delegate.onSource(source);
        }
        this.delegate.onComplete();
    }
}

