/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.Pipeline;
import org.gitlab4j.api.models.PipelineSchedule;
import org.gitlab4j.api.models.PipelineStatus;
import org.gitlab4j.api.models.Trigger;
import org.gitlab4j.api.models.Variable;

public class PipelineApi
extends AbstractApi
implements Constants {
    public PipelineApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public List<Pipeline> getPipelines(Object projectIdOrPath) throws GitLabApiException {
        return this.getPipelines(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<Pipeline> getPipelines(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "pipelines");
        return (List)response.readEntity((GenericType)new GenericType<List<Pipeline>>(){});
    }

    public Pager<Pipeline> getPipelines(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Pipeline>(this, Pipeline.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "pipelines");
    }

    public Stream<Pipeline> getPipelinesStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getPipelines(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public List<Pipeline> getPipelines(Object projectIdOrPath, Constants.PipelineScope scope, PipelineStatus status, String ref, boolean yamlErrors, String name, String username, Constants.PipelineOrderBy orderBy, Constants.SortOrder sort) throws GitLabApiException {
        return this.getPipelines(projectIdOrPath, scope, status, ref, yamlErrors, name, username, orderBy, sort, this.getDefaultPerPage()).all();
    }

    public List<Pipeline> getPipelines(Object projectIdOrPath, Constants.PipelineScope scope, PipelineStatus status, String ref, boolean yamlErrors, String name, String username, Constants.PipelineOrderBy orderBy, Constants.SortOrder sort, int page, int perPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("scope", (Object)scope).withParam("status", (Object)status).withParam("ref", ref).withParam("yaml_errors", yamlErrors).withParam("name", name).withParam("username", username).withParam("order_by", (Object)orderBy).withParam("sort", (Object)sort).withParam("page", page).withParam("per_page", perPage);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "pipelines");
        return (List)response.readEntity((GenericType)new GenericType<List<Pipeline>>(){});
    }

    public Stream<Pipeline> getPipelinesStream(Object projectIdOrPath, Constants.PipelineScope scope, PipelineStatus status, String ref, boolean yamlErrors, String name, String username, Constants.PipelineOrderBy orderBy, Constants.SortOrder sort) throws GitLabApiException {
        return this.getPipelines(projectIdOrPath, scope, status, ref, yamlErrors, name, username, orderBy, sort, this.getDefaultPerPage()).stream();
    }

    public Pager<Pipeline> getPipelines(Object projectIdOrPath, Constants.PipelineScope scope, PipelineStatus status, String ref, boolean yamlErrors, String name, String username, Constants.PipelineOrderBy orderBy, Constants.SortOrder sort, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("scope", (Object)scope).withParam("status", (Object)status).withParam("ref", ref).withParam("yaml_errors", yamlErrors).withParam("name", name).withParam("username", username).withParam("order_by", (Object)orderBy).withParam("sort", (Object)sort);
        return new Pager<Pipeline>(this, Pipeline.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "pipelines");
    }

    public Pipeline getPipeline(Object projectIdOrPath, int pipelineId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "pipelines", pipelineId);
        return (Pipeline)response.readEntity(Pipeline.class);
    }

    public Pipeline createPipeline(Object projectIdOrPath, String ref) throws GitLabApiException {
        return this.createPipeline(projectIdOrPath, ref, Variable.convertMapToList(null));
    }

    public Pipeline createPipeline(Object projectIdOrPath, String ref, Map<String, String> variables) throws GitLabApiException {
        return this.createPipeline(projectIdOrPath, ref, Variable.convertMapToList(variables));
    }

    public Pipeline createPipeline(Object projectIdOrPath, String ref, List<Variable> variables) throws GitLabApiException {
        if (ref == null || ref.trim().isEmpty()) {
            throw new GitLabApiException("ref cannot be null or empty");
        }
        if (variables == null || variables.isEmpty()) {
            GitLabApiForm formData = new GitLabApiForm().withParam("ref", ref, true);
            Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "pipeline"});
            return (Pipeline)response.readEntity(Pipeline.class);
        }
        class CreatePipelineForm {
            public String ref;
            public List<Variable> variables;

            CreatePipelineForm(String ref, List<Variable> variables) {
                this.ref = ref;
                this.variables = variables;
            }
        }
        CreatePipelineForm pipelineForm = new CreatePipelineForm(ref, variables);
        Response response = this.post(Response.Status.CREATED, pipelineForm, "projects", this.getProjectIdOrPath(projectIdOrPath), "pipeline");
        return (Pipeline)response.readEntity(Pipeline.class);
    }

    public void deletePipeline(Object projectIdOrPath, int pipelineId) throws GitLabApiException {
        this.delete(Response.Status.ACCEPTED, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "pipelines", pipelineId);
    }

    public Pipeline retryPipelineJob(Object projectIdOrPath, int pipelineId) throws GitLabApiException {
        Form formData = null;
        Response response = this.post(Response.Status.OK, formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "pipelines", pipelineId, "retry"});
        return (Pipeline)response.readEntity(Pipeline.class);
    }

    public Pipeline cancelPipelineJobs(Object projectIdOrPath, int pipelineId) throws GitLabApiException {
        Form formData = null;
        Response response = this.post(Response.Status.OK, formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "pipelines", pipelineId, "cancel"});
        return (Pipeline)response.readEntity(Pipeline.class);
    }

    public List<PipelineSchedule> getPipelineSchedules(Object projectIdOrPath) throws GitLabApiException {
        return this.getPipelineSchedules(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<PipelineSchedule> getPipelineSchedules(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "pipeline_schedules");
        return (List)response.readEntity((GenericType)new GenericType<List<PipelineSchedule>>(){});
    }

    public Pager<PipelineSchedule> getPipelineSchedules(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<PipelineSchedule>(this, PipelineSchedule.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "pipeline_schedules");
    }

    public Stream<PipelineSchedule> getPipelineSchedulesStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getPipelineSchedules(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public PipelineSchedule getPipelineSchedule(Object projectIdOrPath, Integer pipelineScheduleId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "pipeline_schedules", pipelineScheduleId);
        return (PipelineSchedule)response.readEntity(PipelineSchedule.class);
    }

    public Optional<PipelineSchedule> getOptionalPipelineSchedule(Object projectIdOrPath, Integer pipelineScheduleId) {
        try {
            return Optional.ofNullable(this.getPipelineSchedule(projectIdOrPath, pipelineScheduleId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public PipelineSchedule createPipelineSchedule(Object projectIdOrPath, PipelineSchedule pipelineSchedule) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("description", pipelineSchedule.getDescription(), true).withParam("ref", pipelineSchedule.getRef(), true).withParam("cron", pipelineSchedule.getCron(), true).withParam("cron_timezone", pipelineSchedule.getCronTimezone(), false).withParam("active", pipelineSchedule.getActive(), false);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "pipeline_schedules"});
        return (PipelineSchedule)response.readEntity(PipelineSchedule.class);
    }

    public void deletePipelineSchedule(Object projectIdOrPath, Integer pipelineScheduleId) throws GitLabApiException {
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "pipeline_schedules", pipelineScheduleId);
    }

    public PipelineSchedule updatePipelineSchedule(Object projectIdOrPath, PipelineSchedule pipelineSchedule) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("description", pipelineSchedule.getDescription(), false).withParam("ref", pipelineSchedule.getRef(), false).withParam("cron", pipelineSchedule.getCron(), false).withParam("cron_timezone", pipelineSchedule.getCronTimezone(), false).withParam("active", pipelineSchedule.getActive(), false);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "pipeline_schedules", pipelineSchedule.getId()});
        return (PipelineSchedule)response.readEntity(PipelineSchedule.class);
    }

    public PipelineSchedule takeOwnershipPipelineSchedule(Object projectIdOrPath, Integer pipelineScheduleId) throws GitLabApiException {
        Response response = this.post(Response.Status.OK, "", "projects", this.getProjectIdOrPath(projectIdOrPath), "pipeline_schedules", pipelineScheduleId, "take_ownership");
        return (PipelineSchedule)response.readEntity(PipelineSchedule.class);
    }

    public Variable createPipelineScheduleVariable(Object projectIdOrPath, Integer pipelineScheduleId, String key, String value) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("key", key, true).withParam("value", value, true);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "pipeline_schedules", pipelineScheduleId, "variables"});
        return (Variable)response.readEntity(Variable.class);
    }

    public Variable updatePipelineScheduleVariable(Object projectIdOrPath, Integer pipelineScheduleId, String key, String value) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("value", value, true);
        Response response = this.putWithFormData(Response.Status.CREATED, formData, "projects", this.getProjectIdOrPath(projectIdOrPath), "pipeline_schedules", pipelineScheduleId, "variables", key);
        return (Variable)response.readEntity(Variable.class);
    }

    public void deletePipelineScheduleVariable(Object projectIdOrPath, Integer pipelineScheduleId, String key) throws GitLabApiException {
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "pipeline_schedules", pipelineScheduleId, "variables", key);
    }

    public List<Trigger> getPipelineTriggers(Object projectIdOrPath) throws GitLabApiException {
        return this.getPipelineTriggers(projectIdOrPath, this.getDefaultPerPage()).all();
    }

    public List<Trigger> getPipelineTriggers(Object projectIdOrPath, int page, int perPage) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, this.getPageQueryParams(page, perPage), "projects", this.getProjectIdOrPath(projectIdOrPath), "triggers");
        return (List)response.readEntity((GenericType)new GenericType<List<Trigger>>(){});
    }

    public Pager<Trigger> getPipelineTriggers(Object projectIdOrPath, int itemsPerPage) throws GitLabApiException {
        return new Pager<Trigger>(this, Trigger.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "triggers");
    }

    public Stream<Trigger> getPipelineTriggersStream(Object projectIdOrPath) throws GitLabApiException {
        return this.getPipelineTriggers(projectIdOrPath, this.getDefaultPerPage()).stream();
    }

    public Trigger getPipelineTrigger(Object projectIdOrPath, Integer triggerId) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "triggers", triggerId);
        return (Trigger)response.readEntity(Trigger.class);
    }

    public Optional<Trigger> getOptionalPipelineTrigger(Object projectIdOrPath, Integer triggerId) {
        try {
            return Optional.ofNullable(this.getPipelineTrigger(projectIdOrPath, triggerId));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public Trigger createPipelineTrigger(Object projectIdOrPath, String description) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("description", description, true);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "triggers"});
        return (Trigger)response.readEntity(Trigger.class);
    }

    public Trigger updatePipelineTrigger(Object projectIdOrPath, Integer triggerId, String description) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("description", description, false);
        Response response = this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "triggers", triggerId});
        return (Trigger)response.readEntity(Trigger.class);
    }

    public void deletePipelineTrigger(Object projectIdOrPath, Integer triggerId) throws GitLabApiException {
        this.delete(Response.Status.NO_CONTENT, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "triggers", triggerId);
    }

    public Trigger takeOwnewrshipOfPipelineTrigger(Object projectIdOrPath, Integer triggerId) throws GitLabApiException {
        Response response = this.put(Response.Status.OK, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "triggers", triggerId, "take_ownership");
        return (Trigger)response.readEntity(Trigger.class);
    }

    public Pipeline triggerPipeline(Object projectIdOrPath, Trigger trigger, String ref, List<Variable> variables) throws GitLabApiException {
        if (trigger == null) {
            throw new GitLabApiException("trigger cannot be null");
        }
        return this.triggerPipeline(projectIdOrPath, trigger.getToken(), ref, variables);
    }

    public Pipeline triggerPipeline(Object projectIdOrPath, String token, String ref, List<Variable> variables) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("token", token, true).withParam("ref", ref, true).withParam(variables);
        Response response = this.post(Response.Status.CREATED, (Form)formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "trigger", "pipeline"});
        return (Pipeline)response.readEntity(Pipeline.class);
    }

    public List<Variable> getPipelineVariables(Object projectIdOrPath, Integer pipelineId) throws GitLabApiException {
        return this.getPipelineVariables(projectIdOrPath, pipelineId, this.getDefaultPerPage()).all();
    }

    public Pager<Variable> getPipelineVariables(Object projectIdOrPath, Integer pipelineId, int itemsPerPage) throws GitLabApiException {
        return new Pager<Variable>(this, Variable.class, itemsPerPage, null, "projects", this.getProjectIdOrPath(projectIdOrPath), "pipelines", pipelineId, "variables");
    }

    public Stream<Variable> getPipelineVariablesStream(Object projectIdOrPath, Integer pipelineId) throws GitLabApiException {
        return this.getPipelineVariables(projectIdOrPath, pipelineId, this.getDefaultPerPage()).stream();
    }
}

