/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.Constants;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.Pager;
import org.gitlab4j.api.models.Blame;
import org.gitlab4j.api.models.RepositoryFile;

public class RepositoryFileApi
extends AbstractApi {
    public RepositoryFileApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public Optional<RepositoryFile> getOptionalFileInfo(Object projectIdOrPath, String filePath, String ref) {
        try {
            return Optional.ofNullable(this.getFileInfo(projectIdOrPath, filePath, ref));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public RepositoryFile getFileInfo(Object projectIdOrPath, String filePath, String ref) throws GitLabApiException {
        Form form = new Form();
        this.addFormParam(form, "ref", ref != null ? this.urlEncode(ref) : null, true);
        Response response = this.head(Response.Status.OK, (MultivaluedMap<String, String>)form.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "files", this.urlEncode(filePath));
        RepositoryFile file = new RepositoryFile();
        file.setBlobId(response.getHeaderString("X-Gitlab-Blob-Id"));
        file.setCommitId(response.getHeaderString("X-Gitlab-Commit-Id"));
        String encoding = response.getHeaderString("X-Gitlab-Encoding");
        file.setEncoding(Constants.Encoding.forValue(encoding));
        file.setFileName(response.getHeaderString("X-Gitlab-File-Name"));
        file.setFilePath(response.getHeaderString("X-Gitlab-File-Path"));
        file.setLastCommitId(response.getHeaderString("X-Gitlab-Last-Commit-Id"));
        file.setRef(response.getHeaderString("X-Gitlab-Ref"));
        String sizeStr = response.getHeaderString("X-Gitlab-Size");
        file.setSize(sizeStr != null ? Integer.valueOf(sizeStr) : -1);
        return file;
    }

    public Optional<RepositoryFile> getOptionalFile(Object projectIdOrPath, String filePath, String ref) {
        try {
            return Optional.ofNullable(this.getFile(projectIdOrPath, filePath, ref, true));
        }
        catch (GitLabApiException glae) {
            return GitLabApi.createOptionalFromException(glae);
        }
    }

    public RepositoryFile getFile(Object projectIdOrPath, String filePath, String ref) throws GitLabApiException {
        return this.getFile(projectIdOrPath, filePath, ref, true);
    }

    @Deprecated
    public RepositoryFile getFile(String filePath, Integer projectId, String ref) throws GitLabApiException {
        if (this.isApiVersion(GitLabApi.ApiVersion.V3)) {
            return this.getFileV3(filePath, projectId, ref);
        }
        return this.getFile(projectId, filePath, ref, true);
    }

    public RepositoryFile getFile(Object projectIdOrPath, String filePath, String ref, boolean includeContent) throws GitLabApiException {
        if (!includeContent) {
            return this.getFileInfo(projectIdOrPath, filePath, ref);
        }
        Form form = new Form();
        this.addFormParam(form, "ref", ref != null ? this.urlEncode(ref) : null, true);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)form.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "files", this.urlEncode(filePath));
        return (RepositoryFile)response.readEntity(RepositoryFile.class);
    }

    @Deprecated
    protected RepositoryFile getFileV3(String filePath, Integer projectId, String ref) throws GitLabApiException {
        Form form = new Form();
        this.addFormParam(form, "file_path", filePath, true);
        this.addFormParam(form, "ref", ref, true);
        Response response = this.get(Response.Status.OK, (MultivaluedMap<String, String>)form.asMap(), "projects", projectId, "repository", "files");
        return (RepositoryFile)response.readEntity(RepositoryFile.class);
    }

    public RepositoryFile createFile(Object projectIdOrPath, RepositoryFile file, String branchName, String commitMessage) throws GitLabApiException {
        Form formData = this.createForm(file, branchName, commitMessage);
        Response response = this.isApiVersion(GitLabApi.ApiVersion.V3) ? this.post(Response.Status.CREATED, formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "files"}) : this.post(Response.Status.CREATED, formData, new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "files", this.urlEncode(file.getFilePath())});
        return (RepositoryFile)response.readEntity(RepositoryFile.class);
    }

    @Deprecated
    public RepositoryFile createFile(RepositoryFile file, Integer projectId, String branchName, String commitMessage) throws GitLabApiException {
        return this.createFile(projectId, file, branchName, commitMessage);
    }

    public RepositoryFile updateFile(Object projectIdOrPath, RepositoryFile file, String branchName, String commitMessage) throws GitLabApiException {
        Form formData = this.createForm(file, branchName, commitMessage);
        Response response = this.isApiVersion(GitLabApi.ApiVersion.V3) ? this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "files"}) : this.put(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), new Object[]{"projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "files", this.urlEncode(file.getFilePath())});
        return (RepositoryFile)response.readEntity(RepositoryFile.class);
    }

    @Deprecated
    public RepositoryFile updateFile(RepositoryFile file, Integer projectId, String branchName, String commitMessage) throws GitLabApiException {
        return this.updateFile(projectId, file, branchName, commitMessage);
    }

    public void deleteFile(Object projectIdOrPath, String filePath, String branchName, String commitMessage) throws GitLabApiException {
        Response.Status expectedStatus;
        if (filePath == null) {
            throw new RuntimeException("filePath cannot be null");
        }
        Form form = new Form();
        this.addFormParam(form, this.isApiVersion(GitLabApi.ApiVersion.V3) ? "branch_name" : "branch", branchName != null ? this.urlEncode(branchName) : null, true);
        this.addFormParam(form, "commit_message", commitMessage, true);
        Response.Status status = expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        if (this.isApiVersion(GitLabApi.ApiVersion.V3)) {
            this.addFormParam(form, "file_path", filePath, true);
            this.delete(expectedStatus, (MultivaluedMap<String, String>)form.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "files");
        } else {
            this.delete(expectedStatus, (MultivaluedMap<String, String>)form.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "files", this.urlEncode(filePath));
        }
    }

    @Deprecated
    public void deleteFile(String filePath, Integer projectId, String branchName, String commitMessage) throws GitLabApiException {
        this.deleteFile(projectId, filePath, branchName, commitMessage);
    }

    public File getRawFile(Object projectIdOrPath, String commitOrBranchName, String filepath, File directory) throws GitLabApiException {
        InputStream in = this.getRawFile(projectIdOrPath, commitOrBranchName, filepath);
        try {
            if (directory == null) {
                directory = new File(System.getProperty("java.io.tmpdir"));
            }
            String filename = new File(filepath).getName();
            File file = new File(directory, filename);
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            File file2 = file;
            return file2;
        }
        catch (IOException ioe) {
            throw new GitLabApiException(ioe);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public InputStream getRawFile(Object projectIdOrPath, String ref, String filepath) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("ref", ref != null ? ref : null, true);
        if (this.isApiVersion(GitLabApi.ApiVersion.V3)) {
            Response response = this.getWithAccepts(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "*", "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "blobs", ref);
            return (InputStream)response.readEntity(InputStream.class);
        }
        Response response = this.getWithAccepts(Response.Status.OK, (MultivaluedMap<String, String>)formData.asMap(), "*", "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "files", this.urlEncode(filepath), "raw");
        return (InputStream)response.readEntity(InputStream.class);
    }

    protected Form createForm(RepositoryFile file, String branchName, String commitMessage) {
        Form form = new Form();
        if (this.isApiVersion(GitLabApi.ApiVersion.V3)) {
            this.addFormParam(form, "file_path", file.getFilePath(), true);
            this.addFormParam(form, "branch_name", branchName, true);
        } else {
            this.addFormParam(form, "branch", branchName, true);
        }
        this.addFormParam(form, "encoding", (Object)file.getEncoding(), false);
        String content = file.getContent();
        if (content == null) {
            throw new IllegalArgumentException("content cannot be null");
        }
        form.param("content", content);
        this.addFormParam(form, "commit_message", commitMessage, true);
        return form;
    }

    public List<Blame> getBlame(Object projectIdOrPath, String filePath, String ref) throws GitLabApiException {
        return this.getBlame(projectIdOrPath, filePath, ref, this.getDefaultPerPage()).all();
    }

    public Pager<Blame> getBlame(Object projectIdOrPath, String filePath, String ref, int itemsPerPage) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("ref", ref, true);
        return new Pager<Blame>(this, Blame.class, itemsPerPage, (MultivaluedMap<String, String>)formData.asMap(), "projects", this.getProjectIdOrPath(projectIdOrPath), "repository", "files", this.urlEncode(filePath), "blame");
    }

    public Stream<Blame> getBlameStream(Object projectIdOrPath, String filePath, String ref) throws GitLabApiException {
        return this.getBlame(projectIdOrPath, filePath, ref, this.getDefaultPerPage()).stream();
    }
}

