/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.metaclass;

import java.sql.SQLException;
import java.util.regex.Pattern;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.orm.hibernate.HibernateDatastore;
import org.codehaus.groovy.grails.orm.hibernate.metaclass.AbstractSavePersistentMethod;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.HibernateCallback;

public class MergePersistentMethod
extends AbstractSavePersistentMethod {
    public static final String METHOD_SIGNATURE = "merge";
    public static final Pattern METHOD_PATTERN = Pattern.compile("^merge$");

    public MergePersistentMethod(SessionFactory sessionFactory, ClassLoader classLoader, GrailsApplication application, HibernateDatastore datastore) {
        super(METHOD_PATTERN, sessionFactory, classLoader, application, datastore);
    }

    public MergePersistentMethod(SessionFactory sessionFactory, ClassLoader classLoader, GrailsApplication application, GrailsDomainClass dc, HibernateDatastore datastore) {
        super(METHOD_PATTERN, sessionFactory, classLoader, application, dc, datastore);
    }

    protected Object performSave(final Object target, final boolean flush) {
        return this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Object>(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Object merged = session.merge(target);
                session.lock(merged, LockMode.NONE);
                if (flush) {
                    session.flush();
                }
                return merged;
            }
        });
    }

    protected Object performInsert(Object target, boolean shouldFlush) {
        throw new IllegalArgumentException("The [insert] argument is not supported by the [merge] method");
    }
}

