/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;

public class UnsignedShortArrayList
implements Cloneable {
    private char[] myData;
    private int mySize;

    public UnsignedShortArrayList(int initialCapacity) {
        this.myData = new char[initialCapacity];
    }

    public UnsignedShortArrayList() {
        this(10);
    }

    public void trimToSize() {
        if (this.mySize < this.myData.length) {
            this.myData = ArrayUtil.realloc(this.myData, this.mySize);
        }
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.myData.length;
        if (minCapacity > oldCapacity) {
            char[] oldData = this.myData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.myData = new char[newCapacity];
            System.arraycopy(oldData, 0, this.myData, 0, this.mySize);
        }
    }

    public int size() {
        return this.mySize;
    }

    public Object clone() {
        try {
            UnsignedShortArrayList v = (UnsignedShortArrayList)super.clone();
            v.myData = (char[])this.myData.clone();
            return v;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @NotNull
    public int[] toArray() {
        int[] nArray = this.toArray(0, this.mySize);
        if (nArray == null) {
            UnsignedShortArrayList.$$$reportNull$$$0(0);
        }
        return nArray;
    }

    @NotNull
    public int[] toArray(int startIndex, int length) {
        int[] result2 = new int[length];
        for (int i = startIndex; i < length; ++i) {
            int c;
            result2[i - startIndex] = c = this.myData[i];
        }
        if (result2 == null) {
            UnsignedShortArrayList.$$$reportNull$$$0(3);
        }
        return result2;
    }

    public int getQuick(int index2) {
        return this.myData[index2];
    }

    public void setQuick(int index2, int element) {
        UnsignedShortArrayList.assertShort(element);
        this.myData[index2] = (char)element;
    }

    private static void assertShort(int element) {
        assert (element >= 0 && element < 65536) : element;
    }

    public void add(int element) {
        this.ensureCapacity(this.mySize + 1);
        this.setQuick(this.mySize++, element);
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/containers/UnsignedShortArrayList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/UnsignedShortArrayList";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

