/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.callUtil;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.incremental.KotlinLookupLocation;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtInstanceExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallTransformer;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatchStatus;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentUnmapped;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000r\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u001a\u0010\u0004\u001a\u00020\u0001\"\b\b\u0000\u0010\u0005*\u00020\u0006*\b\u0012\u0004\u0012\u0002H\u00050\u0007\u001a\n\u0010\b\u001a\u00020\t*\u00020\n\u001a\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f*\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fH\u0002\u001a\u0014\u0010\u000e\u001a\u0004\u0018\u00010\n*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0012\u0010\u0011\u001a\u00020\n*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u0004\u0018\u00010\u0002\u001a\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0013*\u0006\u0012\u0002\b\u00030\u0007\u001a\u001a\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0007*\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010\u001a&\u0010\u0017\u001a\u0004\u0018\u00010\u0018\"\b\b\u0000\u0010\u0005*\u00020\u0006*\b\u0012\u0004\u0012\u0002H\u00050\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\r\u001a\u001e\u0010\u001a\u001a\u0004\u0018\u00010\n*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u001b\u001a\u00020\u0001\u001a(\u0010\u001c\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u0007*\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u001b\u001a\u00020\u0001\u001a\u001a\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u0007*\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u0013*\u0006\u0012\u0002\b\u00030\u0007\u001a\u001e\u0010 \u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u0007*\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u001e\u0010 \u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u0007*\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u001a\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0007*\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u001a\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0007*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0014\u0010\"\u001a\u0004\u0018\u00010#*\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0014\u0010$\u001a\u0004\u0018\u00010\r*\u00020\n2\u0006\u0010%\u001a\u00020\u0013\u001a\n\u0010&\u001a\u00020\u0002*\u00020\n\u001a\u0010\u0010'\u001a\b\u0012\u0004\u0012\u00020\r0\f*\u00020\n\u001a\u0010\u0010'\u001a\b\u0012\u0004\u0012\u00020\r0\f*\u00020(\u001a\u001a\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020*0\u0007*\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010\u001a\"\u0010+\u001a\u00020\u0001\"\b\b\u0000\u0010\u0005*\u00020\u0006*\b\u0012\u0004\u0012\u0002H\u00050\u00072\u0006\u0010,\u001a\u00020\u0018\u001a\u001a\u0010-\u001a\u00020\u0001\"\b\b\u0000\u0010\u0005*\u00020\u0006*\b\u0012\u0004\u0012\u0002H\u00050\u0007\u001a\u001a\u0010.\u001a\u00020\u0001\"\b\b\u0000\u0010\u0005*\u00020\u0006*\b\u0012\u0004\u0012\u0002H\u00050\u0007\u001a(\u0010/\u001a\u00020\u0001\"\u000e\b\u0000\u00100*\b\u0012\u0004\u0012\u0002H001*\u00020\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H001\u001a\n\u00102\u001a\u00020\u0001*\u00020\n\u001a\n\u00103\u001a\u00020\u0001*\u00020\n\u001a\u001a\u00104\u001a\u00020\u0001\"\b\b\u0000\u0010\u0005*\u00020\u0006*\b\u0012\u0004\u0012\u0002H\u00050\u0007\u001a\u001a\u00105\u001a\u00020\u0001\"\b\b\u0000\u0010\u0005*\u00020\u0006*\b\u0012\u0004\u0012\u0002H\u00050\u0007\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\u00a8\u00066"}, d2={"isFakeElement", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/psi/KtElement;)Z", "allArgumentsMapped", "D", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "createLookupLocation", "Lorg/jetbrains/kotlin/incremental/KotlinLookupLocation;", "Lorg/jetbrains/kotlin/psi/Call;", "filterArgsInParentheses", "", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "getCall", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getCallWithAssert", "getCalleeExpressionIfAny", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getFirstArgumentExpression", "getFunctionResolvedCallWithAssert", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getParameterForArgument", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "valueArgument", "getParentCall", "strict", "getParentResolvedCall", "getPropertyResolvedCallWithAssert", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "getReceiverExpression", "getResolvedCall", "getResolvedCallWithAssert", "getType", "Lorg/jetbrains/kotlin/types/KotlinType;", "getValueArgumentForExpression", "expression", "getValueArgumentListOrElement", "getValueArgumentsInParentheses", "Lorg/jetbrains/kotlin/psi/KtCallElement;", "getVariableResolvedCallWithAssert", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "hasTypeMismatchErrorOnParameter", "parameter", "hasUnmappedArguments", "hasUnmappedParameters", "hasUnresolvedArguments", "C", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "isCallableReference", "isSafeCall", "noErrorsInValueArguments", "usesDefaultArguments", "frontend"})
public final class CallUtilKt {
    public static final <D extends CallableDescriptor> boolean noErrorsInValueArguments(@NotNull ResolvedCall<D> $receiver) {
        boolean bl;
        block4: {
            Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
            Call call2 = $receiver.getCall();
            Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"call");
            List<? extends ValueArgument> list2 = call2.getValueArguments();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"call.valueArguments");
            Iterable $receiver$iv = list2;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    ValueArgument argument;
                    ValueArgument valueArgument = argument = (ValueArgument)element$iv;
                    if (valueArgument == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!$receiver.getArgumentMapping(valueArgument).isError()) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static final <D extends CallableDescriptor> boolean hasUnmappedArguments(@NotNull ResolvedCall<D> $receiver) {
        boolean bl;
        block4: {
            Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
            Call call2 = $receiver.getCall();
            Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"call");
            List<? extends ValueArgument> list2 = call2.getValueArguments();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"call.valueArguments");
            Iterable $receiver$iv = list2;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    ValueArgument argument;
                    ValueArgument valueArgument = argument = (ValueArgument)element$iv;
                    if (valueArgument == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!Intrinsics.areEqual((Object)$receiver.getArgumentMapping(valueArgument), (Object)ArgumentUnmapped.INSTANCE)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final <D extends CallableDescriptor> boolean hasUnmappedParameters(@NotNull ResolvedCall<D> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Map<ValueParameterDescriptor, ResolvedValueArgument> parameterToArgumentMap = $receiver.getValueArguments();
        Set<ValueParameterDescriptor> set = parameterToArgumentMap.keySet();
        List<ValueParameterDescriptor> list2 = $receiver.getResultingDescriptor().getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"resultingDescriptor.valueParameters");
        return !set.containsAll((Collection)list2);
    }

    public static final <D extends CallableDescriptor> boolean allArgumentsMapped(@NotNull ResolvedCall<D> $receiver) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
            Call call2 = $receiver.getCall();
            Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"call");
            List<? extends ValueArgument> list2 = call2.getValueArguments();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"call.valueArguments");
            Iterable $receiver$iv = list2;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    ValueArgument argument = (ValueArgument)element$iv;
                    if ($receiver.getArgumentMapping(argument) instanceof ArgumentMatch) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static final <D extends CallableDescriptor> boolean hasTypeMismatchErrorOnParameter(@NotNull ResolvedCall<D> $receiver, @NotNull ValueParameterDescriptor parameter) {
        boolean bl;
        block4: {
            Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
            ResolvedValueArgument resolvedValueArgument = $receiver.getValueArguments().get(parameter);
            if (resolvedValueArgument == null) {
                return true;
            }
            List<ValueArgument> list2 = resolvedValueArgument.getArguments();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"resolvedValueArgument.arguments");
            Iterable $receiver$iv = list2;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    ValueArgument argument = (ValueArgument)element$iv;
                    ArgumentMapping argumentMapping = $receiver.getArgumentMapping(argument);
                    boolean bl2 = argumentMapping instanceof ArgumentMatch && ((ArgumentMatch)argumentMapping).getStatus() == ArgumentMatchStatus.TYPE_MISMATCH;
                    if (!bl2) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public static final <D extends CallableDescriptor> ValueParameterDescriptor getParameterForArgument(@NotNull ResolvedCall<D> $receiver, @Nullable ValueArgument valueArgument) {
        ArgumentMapping argumentMapping;
        ArgumentMapping argumentMapping2;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        ValueArgument valueArgument2 = valueArgument;
        if (valueArgument2 != null) {
            ValueArgument valueArgument3;
            ValueArgument it = valueArgument3 = valueArgument2;
            argumentMapping2 = $receiver.getArgumentMapping(it);
        } else {
            argumentMapping2 = argumentMapping = null;
        }
        if (!(argumentMapping2 instanceof ArgumentMatch)) {
            argumentMapping = null;
        }
        ArgumentMatch argumentMatch = (ArgumentMatch)argumentMapping;
        return argumentMatch != null ? argumentMatch.getValueParameter() : null;
    }

    public static final <D extends CallableDescriptor> boolean usesDefaultArguments(@NotNull ResolvedCall<D> $receiver) {
        boolean bl;
        block5: {
            Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
            List<ResolvedValueArgument> list2 = $receiver.getValueArgumentsByIndex();
            if (list2 != null) {
                Iterable $receiver$iv = list2;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        ResolvedValueArgument it = (ResolvedValueArgument)element$iv;
                        if (!(it instanceof DefaultValueArgument)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final <C extends ResolutionContext<C>> boolean hasUnresolvedArguments(@NotNull Call $receiver, @NotNull ResolutionContext<C> context) {
        boolean bl;
        block8: {
            void $receiver$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull(context, (String)"context");
            List<? extends ValueArgument> list2 = $receiver.getValueArguments();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"valueArguments");
            Iterable $receiver$iv = list2;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                ValueArgument valueArgument = (ValueArgument)item$iv$iv;
                Collection collection = destination$iv$iv;
                KtExpression ktExpression = it.getArgumentExpression();
                collection.add(ktExpression);
            }
            List arguments2 = (List)destination$iv$iv;
            $receiver$iv = arguments2;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    boolean bl2;
                    KtExpression argument = (KtExpression)element$iv;
                    if (argument == null || ArgumentTypeResolver.isFunctionLiteralOrCallableReference(argument, context)) {
                        bl2 = false;
                    } else {
                        KtElement ktElement = argument;
                        BindingTrace bindingTrace = context.trace;
                        Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"context.trace");
                        BindingContext bindingContext = bindingTrace.getBindingContext();
                        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext, (String)"context.trace.bindingContext");
                        MutableResolvedCall resolvedCall2 = (MutableResolvedCall)CallUtilKt.getResolvedCall(ktElement, bindingContext);
                        if (resolvedCall2 != null && !resolvedCall2.hasInferredReturnType()) {
                            bl2 = false;
                        } else {
                            BindingTrace bindingTrace2 = context.trace;
                            Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace2, (String)"context.trace");
                            KotlinType expressionType = bindingTrace2.getBindingContext().getType(argument);
                            bl2 = expressionType == null || KotlinTypeKt.isError(expressionType);
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public static final List<ValueArgument> getValueArgumentsInParentheses(@NotNull Call $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        List<? extends ValueArgument> list2 = $receiver.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"valueArguments");
        return CallUtilKt.filterArgsInParentheses(list2);
    }

    @NotNull
    public static final List<ValueArgument> getValueArgumentsInParentheses(@NotNull KtCallElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        List<? extends ValueArgument> list2 = $receiver.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"valueArguments");
        return CallUtilKt.filterArgsInParentheses(list2);
    }

    @NotNull
    public static final KtElement getValueArgumentListOrElement(@NotNull Call $receiver) {
        KtElement ktElement;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver instanceof CallTransformer.CallForImplicitInvoke) {
            Call call2 = ((CallTransformer.CallForImplicitInvoke)$receiver).getOuterCall();
            Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"outerCall");
            ktElement = CallUtilKt.getValueArgumentListOrElement(call2);
        } else {
            KtValueArgumentList ktValueArgumentList = $receiver.getValueArgumentList();
            ktElement = ktValueArgumentList != null ? (KtElement)ktValueArgumentList : (KtElement)$receiver.getCalleeExpression();
            if (ktElement == null) {
                KtElement ktElement2 = $receiver.getCallElement();
                ktElement = ktElement2;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktElement2, (String)"callElement");
            }
        }
        return ktElement;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ValueArgument> filterArgsInParentheses(@NotNull List<? extends ValueArgument> $receiver) {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)$receiver;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            ValueArgument it = (ValueArgument)element$iv$iv;
            if (!(!(it instanceof KtLambdaArgument))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)var3_3;
    }

    @Nullable
    public static final ValueArgument getValueArgumentForExpression(@NotNull Call $receiver, @NotNull KtExpression expression2) {
        Object v2;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            getValueArgumentForExpression.1 deparenthesizeStructurally$ = getValueArgumentForExpression.1.INSTANCE;
            Function1<KtElement, Boolean> isParenthesizedExpression$ = new Function1<KtElement, Boolean>(expression2){
                final /* synthetic */ KtExpression $expression;

                public final boolean invoke(@NotNull KtElement $receiver) {
                    boolean bl;
                    block1: {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        Sequence $receiver$iv = SequencesKt.generateSequence((Object)$receiver, (Function1)getValueArgumentForExpression.1.INSTANCE);
                        for (E element$iv : $receiver$iv) {
                            KtElement it = (KtElement)element$iv;
                            if (!Intrinsics.areEqual((Object)it, (Object)this.$expression)) continue;
                            bl = true;
                            break block1;
                        }
                        bl = false;
                    }
                    return bl;
                }
                {
                    this.$expression = ktExpression;
                    super(1);
                }
            };
            List<? extends ValueArgument> list2 = $receiver.getValueArguments();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"valueArguments");
            Iterable $receiver$iv = list2;
            for (Object element$iv : $receiver$iv) {
                ValueArgument it = (ValueArgument)element$iv;
                Object object = it;
                if (!(object != null && (object = object.getArgumentExpression()) != null ? isParenthesizedExpression$.invoke((KtElement)object) : false)) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    @Nullable
    public static final KtExpression getCalleeExpressionIfAny(@Nullable KtElement $receiver) {
        KtElement element = $receiver instanceof KtExpression ? (KtElement)KtPsiUtil.deparenthesize((KtExpression)$receiver) : $receiver;
        KtElement ktElement = element;
        return ktElement instanceof KtSimpleNameExpression ? (KtExpression)element : (ktElement instanceof KtCallElement ? ((KtCallElement)element).getCalleeExpression() : (ktElement instanceof KtQualifiedExpression ? CallUtilKt.getCalleeExpressionIfAny(((KtQualifiedExpression)element).getSelectorExpression()) : (ktElement instanceof KtOperationExpression ? (KtExpression)((KtOperationExpression)element).getOperationReference() : null)));
    }

    @Nullable
    public static final Call getCall(@NotNull KtElement $receiver, @NotNull BindingContext context) {
        KtExpression reference;
        KtExpression ktExpression;
        KtProperty subjectVariable;
        KtElement element;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        KtElement ktElement = element = $receiver instanceof KtExpression ? (KtElement)KtPsiUtil.deparenthesize((KtExpression)$receiver) : $receiver;
        if (element == null) {
            return null;
        }
        if (element instanceof KtCallElement && ((KtCallElement)element).getCalleeExpression() == null) {
            return null;
        }
        if (element instanceof KtWhenExpression && (subjectVariable = ((KtWhenExpression)element).getSubjectVariable()) != null) {
            return CallUtilKt.getCall(subjectVariable, context);
        }
        PsiElement parent2 = element.getParent();
        PsiElement psiElement = parent2;
        if (psiElement instanceof KtInstanceExpressionWithLabel) {
            ktExpression = (KtExpression)parent2;
        } else if (psiElement instanceof KtUserType) {
            PsiElement psiElement2 = ((KtUserType)parent2).getParent();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"parent.parent");
            PsiElement psiElement3 = psiElement2.getParent();
            if (!(psiElement3 instanceof KtConstructorCalleeExpression)) {
                psiElement3 = null;
            }
            ktExpression = (KtConstructorCalleeExpression)psiElement3;
        } else {
            ktExpression = reference = CallUtilKt.getCalleeExpressionIfAny(element);
        }
        if (reference != null) {
            return (Call)context.get(BindingContext.CALL, reference);
        }
        return (Call)context.get(BindingContext.CALL, element);
    }

    @Nullable
    public static final Call getParentCall(@NotNull KtElement $receiver, @NotNull BindingContext context, boolean strict) {
        KtElement parent2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Class[] callExpressionTypes = new Class[]{KtSimpleNameExpression.class, KtCallElement.class, KtBinaryExpression.class, KtUnaryExpression.class, KtArrayAccessExpression.class};
        KtElement ktElement = parent2 = strict ? (KtElement)PsiTreeUtil.getParentOfType((PsiElement)$receiver, Arrays.copyOf(callExpressionTypes, callExpressionTypes.length)) : (KtElement)PsiTreeUtil.getNonStrictParentOfType($receiver, Arrays.copyOf(callExpressionTypes, callExpressionTypes.length));
        return ktElement != null ? CallUtilKt.getCall(ktElement, context) : null;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ Call getParentCall$default(KtElement ktElement, BindingContext bindingContext, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return CallUtilKt.getParentCall(ktElement, bindingContext, bl);
    }

    @Nullable
    public static final ResolvedCall<? extends CallableDescriptor> getResolvedCall(@Nullable Call $receiver, @NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return (ResolvedCall)context.get(BindingContext.RESOLVED_CALL, $receiver);
    }

    @Nullable
    public static final ResolvedCall<? extends CallableDescriptor> getResolvedCall(@Nullable KtElement $receiver, @NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = $receiver;
        return object != null && (object = CallUtilKt.getCall((KtElement)object, context)) != null ? CallUtilKt.getResolvedCall((Call)object, context) : null;
    }

    @Nullable
    public static final ResolvedCall<? extends CallableDescriptor> getParentResolvedCall(@Nullable KtElement $receiver, @NotNull BindingContext context, boolean strict) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = $receiver;
        return object != null && (object = CallUtilKt.getParentCall((KtElement)object, context, strict)) != null ? CallUtilKt.getResolvedCall((Call)object, context) : null;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ ResolvedCall getParentResolvedCall$default(KtElement ktElement, BindingContext bindingContext, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return CallUtilKt.getParentResolvedCall(ktElement, bindingContext, bl);
    }

    @NotNull
    public static final Call getCallWithAssert(@NotNull KtElement $receiver, @NotNull BindingContext context) {
        Call $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Call call2 = $receiver$iv = CallUtilKt.getCall($receiver, context);
        if (call2 == null) {
            String string;
            String string2 = string = "No call for " + PsiUtilsKt.getTextWithLocation($receiver);
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        return call2;
    }

    @NotNull
    public static final ResolvedCall<? extends CallableDescriptor> getResolvedCallWithAssert(@NotNull KtElement $receiver, @NotNull BindingContext context) {
        ResolvedCall<? extends CallableDescriptor> $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = $receiver$iv = CallUtilKt.getResolvedCall($receiver, context);
        if (resolvedCall2 == null) {
            String string;
            String string2 = string = "No resolved call for " + PsiUtilsKt.getTextWithLocation($receiver);
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        return resolvedCall2;
    }

    @NotNull
    public static final ResolvedCall<? extends CallableDescriptor> getResolvedCallWithAssert(@NotNull Call $receiver, @NotNull BindingContext context) {
        ResolvedCall<? extends CallableDescriptor> $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = $receiver$iv = CallUtilKt.getResolvedCall($receiver, context);
        if (resolvedCall2 == null) {
            String string;
            StringBuilder stringBuilder = new StringBuilder().append("No resolved call for ");
            KtElement ktElement = $receiver.getCallElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"this.callElement");
            String string2 = string = stringBuilder.append(PsiUtilsKt.getTextWithLocation(ktElement)).toString();
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        return resolvedCall2;
    }

    @NotNull
    public static final ResolvedCall<? extends FunctionDescriptor> getFunctionResolvedCallWithAssert(@NotNull KtExpression $receiver, @NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert($receiver, context);
        boolean bl = resolvedCall2.getResultingDescriptor() instanceof FunctionDescriptor;
        if (_Assertions.ENABLED && !bl) {
            String string = "ResolvedCall for this expression must be ResolvedCall<? extends FunctionDescriptor>: " + PsiUtilsKt.getTextWithLocation($receiver);
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        if (resolvedCall3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.model.ResolvedCall<out org.jetbrains.kotlin.descriptors.FunctionDescriptor>");
        }
        return resolvedCall3;
    }

    @NotNull
    public static final ResolvedCall<? extends PropertyDescriptor> getPropertyResolvedCallWithAssert(@NotNull KtExpression $receiver, @NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert($receiver, context);
        boolean bl = resolvedCall2.getResultingDescriptor() instanceof PropertyDescriptor;
        if (_Assertions.ENABLED && !bl) {
            String string = "ResolvedCall for this expression must be ResolvedCall<? extends PropertyDescriptor>: " + PsiUtilsKt.getTextWithLocation($receiver);
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        if (resolvedCall3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.model.ResolvedCall<out org.jetbrains.kotlin.descriptors.PropertyDescriptor>");
        }
        return resolvedCall3;
    }

    @NotNull
    public static final ResolvedCall<? extends VariableDescriptor> getVariableResolvedCallWithAssert(@NotNull KtExpression $receiver, @NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCallWithAssert($receiver, context);
        boolean bl = resolvedCall2.getResultingDescriptor() instanceof VariableDescriptor;
        if (_Assertions.ENABLED && !bl) {
            String string = "ResolvedCall for this expression must be ResolvedCall<? extends PropertyDescriptor>: " + PsiUtilsKt.getTextWithLocation($receiver);
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        if (resolvedCall3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.model.ResolvedCall<out org.jetbrains.kotlin.descriptors.VariableDescriptor>");
        }
        return resolvedCall3;
    }

    @Nullable
    public static final KotlinType getType(@NotNull KtExpression $receiver, @NotNull BindingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        KotlinType type2 = context.getType($receiver);
        if (type2 != null) {
            return type2;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall($receiver, context);
        if (resolvedCall2 instanceof VariableAsFunctionResolvedCall) {
            return ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall().getResultingDescriptor().getType();
        }
        return null;
    }

    public static final boolean isFakeElement(@NotNull KtElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        PsiFile file2 = $receiver.getContainingFile();
        return file2 instanceof KtFile && KtPsiFactoryKt.getDoNotAnalyze((KtFile)file2) != null;
    }

    public static final boolean isSafeCall(@NotNull Call $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver instanceof CallTransformer.CallForImplicitInvoke) {
            Call call2 = ((CallTransformer.CallForImplicitInvoke)$receiver).getOuterCall();
            Intrinsics.checkExpressionValueIsNotNull((Object)call2, (String)"outerCall");
            if (call2.isSemanticallyEquivalentToSafeCall()) {
                return true;
            }
        }
        return $receiver.isSemanticallyEquivalentToSafeCall();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isCallableReference(@NotNull Call $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KtElement callElement = $receiver.getCallElement();
        if (!(callElement instanceof KtNameReferenceExpression)) return false;
        PsiElement psiElement = ((KtNameReferenceExpression)callElement).getParent();
        if (!(psiElement instanceof KtCallableReferenceExpression)) {
            psiElement = null;
        }
        KtCallableReferenceExpression ktCallableReferenceExpression = (KtCallableReferenceExpression)psiElement;
        if (!Intrinsics.areEqual((Object)(ktCallableReferenceExpression != null ? ktCallableReferenceExpression.getCallableReference() : null), (Object)callElement)) return false;
        return true;
    }

    @NotNull
    public static final KotlinLookupLocation createLookupLocation(@NotNull Call $receiver) {
        KtElement element;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KtExpression calleeExpression = $receiver.getCalleeExpression();
        KtElement ktElement = element = calleeExpression != null && !CallUtilKt.isFakeElement(calleeExpression) ? (KtElement)calleeExpression : $receiver.getCallElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktElement, (String)"element");
        return new KotlinLookupLocation(ktElement);
    }

    @Nullable
    public static final KtExpression getFirstArgumentExpression(@NotNull ResolvedCall<?> $receiver) {
        KtExpression ktExpression;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        List<ResolvedValueArgument> list2 = $receiver.getValueArgumentsByIndex();
        if (list2 != null) {
            List<ResolvedValueArgument> list3;
            List<ResolvedValueArgument> $receiver2 = list3 = list2;
            ResolvedValueArgument resolvedValueArgument = $receiver2.get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)resolvedValueArgument, (String)"get(0)");
            ktExpression = resolvedValueArgument.getArguments().get(0).getArgumentExpression();
        } else {
            ktExpression = null;
        }
        return ktExpression;
    }

    @Nullable
    public static final KtExpression getReceiverExpression(@NotNull ResolvedCall<?> $receiver) {
        Object object;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        ReceiverValue $receiver$iv = $receiver.getExtensionReceiver();
        ReceiverValue receiverValue = $receiver$iv;
        if (!(receiverValue instanceof ExpressionReceiver)) {
            receiverValue = null;
        }
        if ((object = (ExpressionReceiver)receiverValue) == null || (object = object.getExpression()) == null) {
            $receiver$iv = $receiver.getDispatchReceiver();
            ReceiverValue receiverValue2 = $receiver$iv;
            if (!(receiverValue2 instanceof ExpressionReceiver)) {
                receiverValue2 = null;
            }
            ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverValue2;
            object = expressionReceiver != null ? expressionReceiver.getExpression() : null;
        }
        return object;
    }
}

