/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal.kapt.incremental;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.internal.kapt.incremental.ClassAbiExtractor;
import org.jetbrains.kotlin.gradle.internal.kapt.incremental.ClassDependencies;
import org.jetbrains.kotlin.gradle.internal.kapt.incremental.ClassTypeExtractorVisitor;
import org.jetbrains.kotlin.gradle.internal.kapt.incremental.ClasspathEntryData;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassWriter;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"CLASS_STRUCTURE_ARTIFACT_TYPE", "", "MODULE_INFO", "analyzeInputStream", "", "input", "Ljava/io/InputStream;", "internalName", "entryData", "Lorg/jetbrains/kotlin/gradle/internal/kapt/incremental/ClasspathEntryData;", "visitDirectory", "directory", "Ljava/io/File;", "visitJar", "jar", "kotlin-gradle-plugin"})
public final class ClasspathAnalyzerKt {
    @NotNull
    public static final String CLASS_STRUCTURE_ARTIFACT_TYPE = "class-structure";
    private static final String MODULE_INFO = "module-info.class";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ClasspathEntryData visitDirectory(File directory) {
        ClasspathEntryData entryData = new ClasspathEntryData();
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)directory, null, (int)1, null)), (Function1)((Function1)new Function1<File, Boolean>(directory){
            final /* synthetic */ File $directory;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke(@NotNull File it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)"class")) return false;
                String string = FilesKt.relativeTo((File)it, (File)this.$directory).toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.relativeTo(directory).toString()");
                String string2 = string;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                if (StringsKt.startsWith$default((String)string4, (String)"meta-inf", (boolean)false, (int)2, null)) return false;
                if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"module-info.class") ^ true)) return false;
                return true;
            }
            {
                this.$directory = file;
                super(1);
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            String internalName = StringsKt.dropLast((String)FilesKt.getInvariantSeparatorsPath((File)FilesKt.relativeTo((File)it, (File)directory)), (int)".class".length());
            Object object = it;
            boolean bl2 = false;
            FileInputStream fileInputStream = new FileInputStream((File)object);
            InputStream inputStream = fileInputStream;
            object = new BufferedInputStream(inputStream);
            bl2 = false;
            Throwable throwable = null;
            try {
                BufferedInputStream inputStream2 = (BufferedInputStream)object;
                boolean bl3 = false;
                ClasspathAnalyzerKt.analyzeInputStream(inputStream2, internalName, entryData);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        return entryData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ClasspathEntryData visitJar(File jar) {
        ClasspathEntryData entryData = new ClasspathEntryData();
        Closeable closeable = new ZipFile(jar);
        boolean bl = false;
        Throwable throwable = null;
        try {
            ZipFile zipFile = (ZipFile)closeable;
            boolean bl2 = false;
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                Closeable closeable2;
                ZipEntry entry;
                ZipEntry zipEntry = entry = entries.nextElement();
                Intrinsics.checkExpressionValueIsNotNull((Object)zipEntry, (String)"entry");
                String string = zipEntry.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entry.name");
                if (!StringsKt.endsWith$default((String)string, (String)"class", (boolean)false, (int)2, null)) continue;
                Intrinsics.checkExpressionValueIsNotNull((Object)entry.getName(), (String)"entry.name");
                boolean bl3 = false;
                String string2 = closeable2;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                if (StringsKt.startsWith$default((String)string3, (String)"meta-inf", (boolean)false, (int)2, null) || !(Intrinsics.areEqual((Object)entry.getName(), (Object)MODULE_INFO) ^ true)) continue;
                closeable2 = new BufferedInputStream(zipFile.getInputStream(entry));
                bl3 = false;
                Throwable throwable2 = null;
                try {
                    BufferedInputStream inputStream = (BufferedInputStream)closeable2;
                    boolean bl4 = false;
                    InputStream inputStream2 = inputStream;
                    String string4 = entry.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"entry.name");
                    ClasspathAnalyzerKt.analyzeInputStream(inputStream2, StringsKt.dropLast((String)string4, (int)".class".length()), entryData);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return entryData;
    }

    private static final void analyzeInputStream(InputStream input, String internalName, ClasspathEntryData entryData) {
        ClassAbiExtractor abiExtractor = new ClassAbiExtractor(new ClassWriter(0));
        ClassTypeExtractorVisitor typeDependenciesExtractor = new ClassTypeExtractorVisitor(abiExtractor);
        new ClassReader(ByteStreamsKt.readBytes$default((InputStream)input, (int)0, (int)1, null)).accept(typeDependenciesExtractor, 7);
        byte[] bytes = abiExtractor.getBytes();
        byte[] digest = MessageDigest.getInstance("MD5").digest(bytes);
        Map<String, byte[]> map2 = entryData.getClassAbiHash();
        Intrinsics.checkExpressionValueIsNotNull((Object)digest, (String)"digest");
        map2.put(internalName, digest);
        entryData.getClassDependencies().put(internalName, new ClassDependencies((Collection<String>)typeDependenciesExtractor.getAbiTypes(), (Collection<String>)typeDependenciesExtractor.getPrivateTypes()));
    }

    public static final /* synthetic */ ClasspathEntryData access$visitDirectory(File directory) {
        return ClasspathAnalyzerKt.visitDirectory(directory);
    }

    public static final /* synthetic */ ClasspathEntryData access$visitJar(File jar) {
        return ClasspathAnalyzerKt.visitJar(jar);
    }
}

