/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.conversion;

import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Set;
import org.mapstruct.ap.internal.conversion.AbstractNumberToStringConversion;
import org.mapstruct.ap.internal.conversion.ConversionUtils;
import org.mapstruct.ap.internal.model.common.ConversionContext;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.util.NativeTypes;
import org.mapstruct.ap.internal.util.Strings;

public class PrimitiveToStringConversion
extends AbstractNumberToStringConversion {
    private final Class<?> sourceType;
    private final Class<?> wrapperType;

    public PrimitiveToStringConversion(Class<?> sourceType) {
        super(NativeTypes.isNumber(sourceType));
        if (!sourceType.isPrimitive()) {
            throw new IllegalArgumentException(sourceType + " is no primitive type.");
        }
        this.sourceType = sourceType;
        this.wrapperType = NativeTypes.getWrapperType(sourceType);
    }

    @Override
    public String getToExpression(ConversionContext conversionContext) {
        if (this.requiresDecimalFormat(conversionContext)) {
            StringBuilder sb = new StringBuilder();
            this.appendDecimalFormatter(sb, conversionContext);
            sb.append(".format( <SOURCE> )");
            return sb.toString();
        }
        return "String.valueOf( <SOURCE> )";
    }

    @Override
    public Set<Type> getToConversionImportTypes(ConversionContext conversionContext) {
        if (this.requiresDecimalFormat(conversionContext)) {
            return Collections.singleton(conversionContext.getTypeFactory().getType(DecimalFormat.class));
        }
        return Collections.emptySet();
    }

    @Override
    public String getFromExpression(ConversionContext conversionContext) {
        if (this.requiresDecimalFormat(conversionContext)) {
            StringBuilder sb = new StringBuilder();
            this.appendDecimalFormatter(sb, conversionContext);
            sb.append(".parse( <SOURCE> ).");
            sb.append(this.sourceType.getSimpleName());
            sb.append("Value()");
            return sb.toString();
        }
        return this.wrapperType.getSimpleName() + ".parse" + Strings.capitalize(this.sourceType.getSimpleName()) + "( <SOURCE> )";
    }

    @Override
    protected Set<Type> getFromConversionImportTypes(ConversionContext conversionContext) {
        if (this.requiresDecimalFormat(conversionContext)) {
            return Collections.singleton(conversionContext.getTypeFactory().getType(DecimalFormat.class));
        }
        return Collections.emptySet();
    }

    private void appendDecimalFormatter(StringBuilder sb, ConversionContext conversionContext) {
        sb.append("new ");
        sb.append(ConversionUtils.decimalFormat(conversionContext));
        sb.append("( ");
        if (conversionContext.getNumberFormat() != null) {
            sb.append("\"");
            sb.append(conversionContext.getNumberFormat());
            sb.append("\"");
        }
        sb.append(" )");
    }
}

