/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.mapstruct.ap.internal.model.LifecycleCallbackMethodReference;
import org.mapstruct.ap.internal.model.LifecycleMethodResolver;
import org.mapstruct.ap.internal.model.MappingBuilderContext;
import org.mapstruct.ap.internal.model.MappingMethod;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.source.ForgedMethod;
import org.mapstruct.ap.internal.model.source.ForgedMethodHistory;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.model.source.ValueMapping;
import org.mapstruct.ap.internal.prism.BeanMappingPrism;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.Strings;

public class ValueMappingMethod
extends MappingMethod {
    private final List<MappingEntry> valueMappings;
    private final String defaultTarget;
    private final String nullTarget;
    private final boolean throwIllegalArgumentException;
    private final boolean overridden;

    private ValueMappingMethod(Method method, List<MappingEntry> enumMappings, String nullTarget, String defaultTarget, boolean throwIllegalArgumentException, List<LifecycleCallbackMethodReference> beforeMappingMethods, List<LifecycleCallbackMethodReference> afterMappingMethods) {
        super(method, beforeMappingMethods, afterMappingMethods);
        this.valueMappings = enumMappings;
        this.nullTarget = nullTarget;
        this.defaultTarget = defaultTarget;
        this.throwIllegalArgumentException = throwIllegalArgumentException;
        this.overridden = method.overridesMethod();
    }

    public List<MappingEntry> getValueMappings() {
        return this.valueMappings;
    }

    public String getDefaultTarget() {
        return this.defaultTarget;
    }

    public String getNullTarget() {
        return this.nullTarget;
    }

    public boolean isThrowIllegalArgumentException() {
        return this.throwIllegalArgumentException;
    }

    public Parameter getSourceParameter() {
        return Collections.first(this.getSourceParameters());
    }

    public boolean isOverridden() {
        return this.overridden;
    }

    public static class MappingEntry {
        private final String source;
        private final String target;

        MappingEntry(String source, String target) {
            this.source = source;
            this.target = target;
        }

        public String getSource() {
            return this.source;
        }

        public String getTarget() {
            return this.target;
        }
    }

    public static class Builder {
        private Method method;
        private MappingBuilderContext ctx;
        private final List<ValueMapping> trueValueMappings = new ArrayList<ValueMapping>();
        private ValueMapping defaultTargetValue = null;
        private ValueMapping nullTargetValue = null;
        private boolean applyNamebasedMappings = true;

        public Builder mappingContext(MappingBuilderContext mappingContext) {
            this.ctx = mappingContext;
            return this;
        }

        public Builder method(Method sourceMethod) {
            this.method = sourceMethod;
            return this;
        }

        public Builder valueMappings(List<ValueMapping> valueMappings) {
            for (ValueMapping valueMapping : valueMappings) {
                if ("<ANY_REMAINING>".equals(valueMapping.getSource())) {
                    this.defaultTargetValue = valueMapping;
                    continue;
                }
                if ("<ANY_UNMAPPED>".equals(valueMapping.getSource())) {
                    this.defaultTargetValue = valueMapping;
                    this.applyNamebasedMappings = false;
                    continue;
                }
                if ("<NULL>".equals(valueMapping.getSource())) {
                    this.nullTargetValue = valueMapping;
                    continue;
                }
                this.trueValueMappings.add(valueMapping);
            }
            return this;
        }

        public ValueMappingMethod build() {
            ArrayList<MappingEntry> mappingEntries = new ArrayList<MappingEntry>();
            String nullTarget = null;
            String defaultTarget = null;
            boolean throwIllegalArgumentException = false;
            if (Collections.first(this.method.getSourceParameters()).getType().isEnumType() && this.method.getResultType().isEnumType()) {
                mappingEntries.addAll(this.enumToEnumMapping(this.method));
                if (this.nullTargetValue != null && !"<NULL>".equals(this.nullTargetValue.getTarget())) {
                    nullTarget = this.nullTargetValue.getTarget();
                }
                if (this.defaultTargetValue != null) {
                    defaultTarget = "<NULL>".equals(this.defaultTargetValue.getTarget()) ? null : this.defaultTargetValue.getTarget();
                } else {
                    throwIllegalArgumentException = true;
                }
            }
            SelectionParameters selectionParameters = this.getSelectionParameters(this.method, this.ctx.getTypeUtils());
            HashSet<String> existingVariables = new HashSet<String>(this.method.getParameterNames());
            List<LifecycleCallbackMethodReference> beforeMappingMethods = LifecycleMethodResolver.beforeMappingMethods(this.method, selectionParameters, this.ctx, existingVariables);
            List<LifecycleCallbackMethodReference> afterMappingMethods = LifecycleMethodResolver.afterMappingMethods(this.method, selectionParameters, this.ctx, existingVariables);
            return new ValueMappingMethod(this.method, mappingEntries, nullTarget, defaultTarget, throwIllegalArgumentException, beforeMappingMethods, afterMappingMethods);
        }

        /*
         * WARNING - void declaration
         */
        private List<MappingEntry> enumToEnumMapping(Method method) {
            ArrayList<MappingEntry> mappings = new ArrayList<MappingEntry>();
            ArrayList<String> unmappedSourceConstants = new ArrayList<String>(Collections.first(method.getSourceParameters()).getType().getEnumConstants());
            if (!this.reportErrorIfMappedEnumConstantsDontExist(method)) {
                return mappings;
            }
            for (ValueMapping valueMapping : this.trueValueMappings) {
                String target = "<NULL>".equals(valueMapping.getTarget()) ? null : valueMapping.getTarget();
                mappings.add(new MappingEntry(valueMapping.getSource(), target));
                unmappedSourceConstants.remove(valueMapping.getSource());
            }
            if (this.applyNamebasedMappings) {
                List<String> targetConstants = method.getReturnType().getEnumConstants();
                for (String sourceConstant : new ArrayList<String>(unmappedSourceConstants)) {
                    if (!targetConstants.contains(sourceConstant)) continue;
                    mappings.add(new MappingEntry(sourceConstant, sourceConstant));
                    unmappedSourceConstants.remove(sourceConstant);
                }
                if (this.defaultTargetValue == null && !unmappedSourceConstants.isEmpty()) {
                    void var5_9;
                    String string = "source";
                    String targetErrorMessage = "target";
                    if (method instanceof ForgedMethod && ((ForgedMethod)method).getHistory() != null) {
                        ForgedMethodHistory history = ((ForgedMethod)method).getHistory();
                        String string2 = history.createSourcePropertyErrorMessage();
                        targetErrorMessage = "\"" + history.getTargetType().toString() + " " + history.createTargetPropertyName() + "\"";
                    }
                    this.ctx.getMessager().printMessage((Element)method.getExecutable(), Message.VALUE_MAPPING_UNMAPPED_SOURCES, var5_9, targetErrorMessage, Strings.join(unmappedSourceConstants, ", "));
                }
            }
            return mappings;
        }

        private SelectionParameters getSelectionParameters(Method method, Types typeUtils) {
            BeanMappingPrism beanMappingPrism = BeanMappingPrism.getInstanceOn(method.getExecutable());
            if (beanMappingPrism != null) {
                List<TypeMirror> qualifiers = beanMappingPrism.qualifiedBy();
                List<String> qualifyingNames = beanMappingPrism.qualifiedByName();
                TypeMirror resultType = beanMappingPrism.resultType();
                return new SelectionParameters(qualifiers, qualifyingNames, resultType, typeUtils);
            }
            return null;
        }

        private boolean reportErrorIfMappedEnumConstantsDontExist(Method method) {
            List<String> sourceEnumConstants = Collections.first(method.getSourceParameters()).getType().getEnumConstants();
            List<String> targetEnumConstants = method.getReturnType().getEnumConstants();
            boolean foundIncorrectMapping = false;
            for (ValueMapping mappedConstant : this.trueValueMappings) {
                if (!sourceEnumConstants.contains(mappedConstant.getSource())) {
                    this.ctx.getMessager().printMessage((Element)method.getExecutable(), mappedConstant.getMirror(), mappedConstant.getSourceAnnotationValue(), Message.VALUEMAPPING_NON_EXISTING_CONSTANT, mappedConstant.getSource(), Collections.first(method.getSourceParameters()).getType());
                    foundIncorrectMapping = true;
                }
                if ("<NULL>".equals(mappedConstant.getTarget()) || targetEnumConstants.contains(mappedConstant.getTarget())) continue;
                this.ctx.getMessager().printMessage((Element)method.getExecutable(), mappedConstant.getMirror(), mappedConstant.getTargetAnnotationValue(), Message.VALUEMAPPING_NON_EXISTING_CONSTANT, mappedConstant.getTarget(), method.getReturnType());
                foundIncorrectMapping = true;
            }
            if (this.defaultTargetValue != null && !"<NULL>".equals(this.defaultTargetValue.getTarget()) && !targetEnumConstants.contains(this.defaultTargetValue.getTarget())) {
                this.ctx.getMessager().printMessage((Element)method.getExecutable(), this.defaultTargetValue.getMirror(), this.defaultTargetValue.getTargetAnnotationValue(), Message.VALUEMAPPING_NON_EXISTING_CONSTANT, this.defaultTargetValue.getTarget(), method.getReturnType());
                foundIncorrectMapping = true;
            }
            if (this.nullTargetValue != null && "<NULL>".equals(this.nullTargetValue.getTarget()) && !targetEnumConstants.contains(this.nullTargetValue.getTarget())) {
                this.ctx.getMessager().printMessage((Element)method.getExecutable(), this.nullTargetValue.getMirror(), this.nullTargetValue.getTargetAnnotationValue(), Message.VALUEMAPPING_NON_EXISTING_CONSTANT, this.nullTargetValue.getTarget(), method.getReturnType());
                foundIncorrectMapping = true;
            }
            return !foundIncorrectMapping;
        }
    }
}

