/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool;

import com.alibaba.druid.pool.DruidConnectionHolder;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.alibaba.druid.pool.DruidPooledPreparedStatement;
import com.alibaba.druid.pool.DruidPooledStatement;
import com.alibaba.druid.pool.ElasticSearchDruidPooledPreparedStatement;
import com.alibaba.druid.pool.PreparedStatementHolder;
import com.alibaba.druid.pool.PreparedStatementPool;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class ElasticSearchDruidPooledConnection
extends DruidPooledConnection {
    public ElasticSearchDruidPooledConnection(DruidConnectionHolder holder) {
        super(holder);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkState();
        PreparedStatementHolder stmtHolder = null;
        DruidPooledPreparedStatement.PreparedStatementKey key = new DruidPooledPreparedStatement.PreparedStatementKey(sql, this.getCatalog(), PreparedStatementPool.MethodType.M1);
        boolean poolPreparedStatements = this.holder.isPoolPreparedStatements();
        if (poolPreparedStatements) {
            stmtHolder = this.holder.getStatementPool().get(key);
        }
        if (stmtHolder == null) {
            try {
                stmtHolder = new PreparedStatementHolder(key, this.conn.prepareStatement(sql));
                this.holder.getDataSource().incrementPreparedStatementCount();
            }
            catch (SQLException ex) {
                this.handleException(ex, sql);
            }
        }
        this.initStatement(stmtHolder);
        ElasticSearchDruidPooledPreparedStatement rtnVal = new ElasticSearchDruidPooledPreparedStatement(this, stmtHolder);
        this.holder.addTrace((DruidPooledStatement)rtnVal);
        return rtnVal;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkState();
        PreparedStatementHolder stmtHolder = null;
        DruidPooledPreparedStatement.PreparedStatementKey key = new DruidPooledPreparedStatement.PreparedStatementKey(sql, this.getCatalog(), PreparedStatementPool.MethodType.M2, resultSetType, resultSetConcurrency);
        boolean poolPreparedStatements = this.holder.isPoolPreparedStatements();
        if (poolPreparedStatements) {
            stmtHolder = this.holder.getStatementPool().get(key);
        }
        if (stmtHolder == null) {
            try {
                stmtHolder = new PreparedStatementHolder(key, this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency));
                this.holder.getDataSource().incrementPreparedStatementCount();
            }
            catch (SQLException ex) {
                this.handleException(ex, sql);
            }
        }
        this.initStatement(stmtHolder);
        ElasticSearchDruidPooledPreparedStatement rtnVal = new ElasticSearchDruidPooledPreparedStatement(this, stmtHolder);
        this.holder.addTrace((DruidPooledStatement)rtnVal);
        return rtnVal;
    }

    private void initStatement(PreparedStatementHolder stmtHolder) throws SQLException {
        stmtHolder.incrementInUseCount();
        this.holder.getDataSource().initStatement((DruidPooledConnection)this, (Statement)stmtHolder.statement);
    }
}

