/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.pool;

import com.alibaba.druid.proxy.jdbc.JdbcParameter;
import com.alibaba.druid.proxy.jdbc.JdbcParameterDate;
import com.alibaba.druid.proxy.jdbc.JdbcParameterDecimal;
import com.alibaba.druid.proxy.jdbc.JdbcParameterImpl;
import com.alibaba.druid.proxy.jdbc.JdbcParameterInt;
import com.alibaba.druid.proxy.jdbc.JdbcParameterLong;
import com.alibaba.druid.proxy.jdbc.JdbcParameterNull;
import com.alibaba.druid.proxy.jdbc.JdbcParameterString;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.nlpcn.es4sql.query.ESActionFactory;

public class ElasticSearchPreparedStatement
implements PreparedStatement {
    private static final Log LOG = LogFactory.getLog(ElasticSearchPreparedStatement.class);
    private String sql;
    private JdbcParameter[] parameters;
    private int parametersSize;
    private ResultSet results = null;
    private SQLUtils.FormatOption sqlFormatOption = new SQLUtils.FormatOption(false, false);

    public ElasticSearchPreparedStatement(String sql) {
        this.sql = sql;
        this.parameters = new JdbcParameter[16];
        this.parametersSize = 0;
    }

    public String getSql() {
        return this.sql;
    }

    public String getExecutableSql() {
        if (this.parametersSize < 1) {
            return this.sql;
        }
        ArrayList<Object> parameters = new ArrayList<Object>(this.parametersSize);
        for (int i = 0; i < this.parametersSize; ++i) {
            JdbcParameter jdbcParam = this.parameters[i];
            parameters.add(jdbcParam != null ? jdbcParam.getValue() : null);
        }
        try {
            SQLStatementParser parser = ESActionFactory.createSqlStatementParser(this.sql);
            List statementList = parser.parseStatementList();
            return SQLUtils.toSQLString((List)statementList, (String)"mysql", parameters, (SQLUtils.FormatOption)this.sqlFormatOption);
        }
        catch (ParserException | ClassCastException ex) {
            LOG.warn("format error", ex);
            return this.sql;
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return null;
    }

    @Override
    public int executeUpdate() throws SQLException {
        return 0;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.setParameter(parameterIndex, this.createParameterNull(sqlType));
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(16, x));
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(-6, x));
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(5, x));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(x));
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(x));
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(6, Float.valueOf(x)));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(8, x));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(x));
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(x));
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(10007, x));
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(x));
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(92, x));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(x));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(10002, (Object)x, (long)length));
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(10006, (Object)x, (long)length));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(10001, (Object)x, (long)length));
    }

    @Override
    public void clearParameters() throws SQLException {
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(targetSqlType, x));
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.setObjectParameter(parameterIndex, x);
    }

    @Override
    public boolean execute() throws SQLException {
        return false;
    }

    @Override
    public void addBatch() throws SQLException {
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(10003, (Object)reader, (long)length));
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(2006, x));
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(2004, x));
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(2005, x));
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(2003, x));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(91, (Object)x, cal));
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(92, (Object)x, cal));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(93, (Object)x, cal));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setParameter(parameterIndex, this.createParameterNull(sqlType));
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(10005, x));
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(-8, x));
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(-9, value));
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(10004, (Object)value, length));
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(2011, value));
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(2005, (Object)reader, length));
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(2004, (Object)inputStream, length));
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(2011, (Object)reader, length));
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(2009, xmlObject));
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(x, targetSqlType, scaleOrLength));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(10002, (Object)x, length));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(10001, (Object)x, length));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(10003, (Object)reader, length));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(10002, x));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(10001, x));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(10003, reader));
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(10004, value));
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(2005, reader));
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(2004, inputStream));
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.setParameter(parameterIndex, this.createParameter(2011, reader));
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return null;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return 0;
    }

    @Override
    public void close() throws SQLException {
        if (this.results != null) {
            this.results.close();
        }
        this.results = null;
        this.parameters = null;
        this.parametersSize = 0;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
    }

    @Override
    public int getMaxRows() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
    }

    @Override
    public void cancel() throws SQLException {
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void setCursorName(String name) throws SQLException {
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return false;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.results;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return 0;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 0;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 0;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
    }

    @Override
    public void clearBatch() throws SQLException {
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return new int[0];
    }

    @Override
    public Connection getConnection() throws SQLException {
        return null;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return null;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return 0;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return 0;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return false;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return false;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    public void setResults(ResultSet results) {
        this.results = results;
    }

    private JdbcParameter createParameterNull(int sqlType) {
        return JdbcParameterNull.valueOf((int)sqlType);
    }

    private JdbcParameter createParameter(int sqlType, Object value) {
        if (value == null) {
            return JdbcParameterNull.valueOf((int)sqlType);
        }
        return new JdbcParameterImpl(sqlType, value);
    }

    private JdbcParameter createParameter(int x) {
        return JdbcParameterInt.valueOf((int)x);
    }

    private JdbcParameter createParameter(long x) {
        return JdbcParameterLong.valueOf((long)x);
    }

    private JdbcParameter createParameter(BigDecimal x) {
        if (x == null) {
            return JdbcParameterNull.DECIMAL;
        }
        return JdbcParameterDecimal.valueOf((BigDecimal)x);
    }

    private JdbcParameter createParameter(String x) {
        if (x == null) {
            return JdbcParameterNull.VARCHAR;
        }
        if (x.length() == 0) {
            return JdbcParameterString.empty;
        }
        return new JdbcParameterString(x);
    }

    private JdbcParameter createParameter(java.util.Date x) {
        if (x == null) {
            return JdbcParameterNull.DATE;
        }
        return new JdbcParameterDate(x);
    }

    private JdbcParameter createParameter(int sqlType, Object value, long length) {
        if (value == null) {
            return JdbcParameterNull.valueOf((int)sqlType);
        }
        return new JdbcParameterImpl(sqlType, value, length);
    }

    private void setObjectParameter(int parameterIndex, Object x) {
        if (x == null) {
            this.setParameter(parameterIndex, this.createParameterNull(1111));
            return;
        }
        Class<?> clazz = x.getClass();
        if (clazz == Byte.class) {
            this.setParameter(parameterIndex, this.createParameter(-6, x));
            return;
        }
        if (clazz == Short.class) {
            this.setParameter(parameterIndex, this.createParameter(5, x));
            return;
        }
        if (clazz == Integer.class) {
            this.setParameter(parameterIndex, this.createParameter((Integer)x));
            return;
        }
        if (clazz == Long.class) {
            this.setParameter(parameterIndex, this.createParameter((Long)x));
            return;
        }
        if (clazz == String.class) {
            this.setParameter(parameterIndex, this.createParameter((String)x));
            return;
        }
        if (clazz == BigDecimal.class) {
            this.setParameter(parameterIndex, this.createParameter((BigDecimal)x));
            return;
        }
        if (clazz == Float.class) {
            this.setParameter(parameterIndex, (JdbcParameter)new JdbcParameterImpl(6, x));
            return;
        }
        if (clazz == Double.class) {
            this.setParameter(parameterIndex, (JdbcParameter)new JdbcParameterImpl(8, x));
            return;
        }
        if (clazz == Date.class || clazz == java.util.Date.class) {
            this.setParameter(parameterIndex, this.createParameter((java.util.Date)x));
            return;
        }
        if (clazz == Timestamp.class) {
            this.setParameter(parameterIndex, this.createParameter((Timestamp)x));
            return;
        }
        if (clazz == Time.class) {
            this.setParameter(parameterIndex, (JdbcParameter)new JdbcParameterImpl(92, x));
            return;
        }
        if (clazz == Boolean.class) {
            this.setParameter(parameterIndex, (JdbcParameter)new JdbcParameterImpl(16, x));
            return;
        }
        if (clazz == byte[].class) {
            this.setParameter(parameterIndex, (JdbcParameter)new JdbcParameterImpl(10007, x));
            return;
        }
        if (x instanceof InputStream) {
            this.setParameter(parameterIndex, (JdbcParameter)new JdbcParameterImpl(10001, x));
            return;
        }
        if (x instanceof Reader) {
            this.setParameter(parameterIndex, (JdbcParameter)new JdbcParameterImpl(10003, x));
            return;
        }
        if (x instanceof Clob) {
            this.setParameter(parameterIndex, (JdbcParameter)new JdbcParameterImpl(2005, x));
            return;
        }
        if (x instanceof NClob) {
            this.setParameter(parameterIndex, (JdbcParameter)new JdbcParameterImpl(2011, x));
            return;
        }
        if (x instanceof Blob) {
            this.setParameter(parameterIndex, (JdbcParameter)new JdbcParameterImpl(2004, x));
            return;
        }
        this.setParameter(parameterIndex, this.createParameter(1111, null));
    }

    private JdbcParameter createParameter(int sqlType, Object value, Calendar calendar) {
        if (value == null) {
            return JdbcParameterNull.valueOf((int)sqlType);
        }
        return new JdbcParameterImpl(sqlType, value, calendar);
    }

    private JdbcParameter createParameter(Object x, int sqlType, int scaleOrLength) {
        if (x == null) {
            return JdbcParameterNull.valueOf((int)sqlType);
        }
        return new JdbcParameterImpl(sqlType, x, -1L, null, scaleOrLength);
    }

    private void setParameter(int jdbcIndex, JdbcParameter parameter) {
        int index = jdbcIndex - 1;
        if (jdbcIndex > this.parametersSize) {
            this.parametersSize = jdbcIndex;
        }
        if (this.parametersSize >= this.parameters.length) {
            int oldCapacity = this.parameters.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity <= 4) {
                newCapacity = 4;
            }
            this.parameters = Arrays.copyOf(this.parameters, newCapacity);
        }
        this.parameters[index] = parameter;
    }
}

