/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBooleanExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLTextLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLValuableExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUnionQuery;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.nlpcn.es4sql.domain.KVValue;
import org.nlpcn.es4sql.exception.SqlParseException;

public class Util {
    public static String joiner(List<KVValue> lists, String oper) {
        if (lists.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder(lists.get(0).toString());
        for (int i = 1; i < lists.size(); ++i) {
            sb.append(oper);
            sb.append(lists.get(i).toString());
        }
        return sb.toString();
    }

    public static List<Map<String, Object>> sortByMap(List<Map<String, Object>> lists) {
        return lists;
    }

    public static Object removeTableAilasFromField(Object expr, String tableAlias) {
        if (expr instanceof SQLIdentifierExpr || expr instanceof SQLPropertyExpr || expr instanceof SQLVariantRefExpr) {
            String aliasPrefix;
            String name = expr.toString().replace("`", "");
            if (tableAlias != null && name.startsWith(aliasPrefix = tableAlias + ".")) {
                String newFieldName = name.replaceFirst(aliasPrefix, "");
                return new SQLIdentifierExpr(newFieldName);
            }
        }
        return expr;
    }

    public static Object expr2Object(SQLExpr expr) {
        return Util.expr2Object(expr, "");
    }

    public static Object expr2Object(SQLExpr expr, String charWithQuote) {
        Object value = null;
        if (expr instanceof SQLNumericLiteralExpr) {
            value = ((SQLNumericLiteralExpr)expr).getNumber();
        } else if (expr instanceof SQLCharExpr) {
            value = charWithQuote + ((SQLCharExpr)expr).getText() + charWithQuote;
        } else if (expr instanceof SQLIdentifierExpr) {
            value = expr.toString();
        } else if (expr instanceof SQLPropertyExpr) {
            value = expr.toString();
        } else if (expr instanceof SQLVariantRefExpr) {
            value = expr.toString();
        } else if (expr instanceof SQLAllColumnExpr) {
            value = "*";
        } else if (expr instanceof SQLValuableExpr) {
            value = ((SQLValuableExpr)expr).getValue();
        } else if (expr instanceof SQLBooleanExpr) {
            value = ((SQLBooleanExpr)expr).getValue();
        }
        return value;
    }

    public static Object getScriptValue(SQLExpr expr) throws SqlParseException {
        if (expr instanceof SQLIdentifierExpr || expr instanceof SQLPropertyExpr || expr instanceof SQLVariantRefExpr) {
            return "doc['" + expr.toString() + "'].value";
        }
        if (expr instanceof SQLValuableExpr) {
            return ((SQLValuableExpr)expr).getValue();
        }
        throw new SqlParseException("could not parse sqlBinaryOpExpr need to be identifier/valuable got" + expr.getClass().toString() + " with value:" + expr.toString());
    }

    public static Object getScriptValueWithQuote(SQLExpr expr, String quote) throws SqlParseException {
        if (expr instanceof SQLIdentifierExpr || expr instanceof SQLPropertyExpr || expr instanceof SQLVariantRefExpr) {
            return "doc['" + expr.toString() + "'].value";
        }
        if (expr instanceof SQLCharExpr) {
            return quote + ((SQLCharExpr)expr).getValue() + quote;
        }
        if (expr instanceof SQLIntegerExpr) {
            return ((SQLIntegerExpr)expr).getValue();
        }
        if (expr instanceof SQLNumericLiteralExpr) {
            return ((SQLNumericLiteralExpr)expr).getNumber();
        }
        if (expr instanceof SQLNullExpr) {
            return ((SQLNullExpr)expr).toString().toLowerCase();
        }
        if (expr instanceof SQLBinaryOpExpr) {
            String left = "doc['" + ((SQLBinaryOpExpr)expr).getLeft().toString() + "'].value";
            String operator = ((SQLBinaryOpExpr)expr).getOperator().getName();
            String right = "doc['" + ((SQLBinaryOpExpr)expr).getRight().toString() + "'].value";
            return left + operator + right;
        }
        throw new SqlParseException("could not parse sqlBinaryOpExpr need to be identifier/valuable got " + expr.getClass().toString() + " with value:" + expr.toString());
    }

    public static boolean isFromJoinOrUnionTable(SQLExpr expr) {
        AtomicInteger counter = new AtomicInteger(10);
        for (SQLExpr temp = expr; !(temp == null || expr instanceof SQLSelectQueryBlock || expr instanceof SQLJoinTableSource || expr instanceof SQLUnionQuery || counter.get() <= 0); temp = temp.getParent()) {
            SQLTableSource from;
            counter.decrementAndGet();
            if (!(temp instanceof SQLSelectQueryBlock) || !((from = ((SQLSelectQueryBlock)temp).getFrom()) instanceof SQLJoinTableSource) && !(from instanceof SQLUnionQuery)) continue;
            return true;
        }
        return false;
    }

    public static double[] String2DoubleArr(String paramer) {
        String[] split = paramer.split(",");
        double[] ds = new double[split.length];
        for (int i = 0; i < ds.length; ++i) {
            ds[i] = Double.parseDouble(split[i].trim());
        }
        return ds;
    }

    public static double[] KV2DoubleArr(List<KVValue> params) {
        double[] ds = new double[params.size()];
        int i = 0;
        for (KVValue v : params) {
            ds[i] = ((Number)v.value).doubleValue();
            ++i;
        }
        return ds;
    }

    public static String extendedToString(SQLExpr sqlExpr) {
        if (sqlExpr instanceof SQLTextLiteralExpr) {
            return ((SQLTextLiteralExpr)sqlExpr).getText();
        }
        return sqlExpr.toString();
    }

    public static String[] concatStringsArrays(String[] a1, String[] a2) {
        int i;
        String[] strings = new String[a1.length + a2.length];
        for (i = 0; i < a1.length; ++i) {
            strings[i] = a1[i];
        }
        for (i = 0; i < a2.length; ++i) {
            strings[a1.length + i] = a2[i];
        }
        return strings;
    }

    public static Object searchPathInMap(Map<String, Object> fieldsMap, String[] path) {
        Map currentObject = fieldsMap;
        for (int i = 0; i < path.length - 1; ++i) {
            Object valueFromCurrentMap = currentObject.get(path[i]);
            if (valueFromCurrentMap == null) {
                return null;
            }
            if (!Map.class.isAssignableFrom(valueFromCurrentMap.getClass())) {
                return null;
            }
            currentObject = (Map)valueFromCurrentMap;
        }
        return currentObject.get(path[path.length - 1]);
    }

    public static Object deepSearchInMap(Map<String, Object> fieldsMap, String field) {
        if (field.contains(".")) {
            String[] split = field.split("\\.");
            return Util.searchPathInMap(fieldsMap, split);
        }
        return fieldsMap.get(field);
    }

    public static boolean clearEmptyPaths(Map<String, Object> map) {
        if (map.size() == 0) {
            return true;
        }
        HashSet<String> keysToDelete = new HashSet<String>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (!Map.class.isAssignableFrom(value.getClass()) || !Util.clearEmptyPaths((Map)value)) continue;
            keysToDelete.add(entry.getKey());
        }
        if (keysToDelete.size() != 0) {
            if (map.size() == keysToDelete.size()) {
                map.clear();
                return true;
            }
            Iterator<Map.Entry<String, Object>> iterator = keysToDelete.iterator();
            if (iterator.hasNext()) {
                String key = (String)((Object)iterator.next());
                map.remove(key);
                return false;
            }
        }
        return false;
    }
}

