/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql.domain;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.nlpcn.es4sql.domain.Where;
import org.nlpcn.es4sql.exception.SqlParseException;
import org.nlpcn.es4sql.parse.ChildrenType;
import org.nlpcn.es4sql.parse.NestedType;

public class Condition
extends Where {
    private String name;
    private SQLExpr nameExpr;
    private Object value;
    private SQLExpr valueExpr;
    private OPEAR opear;
    private Object relationshipType;
    private boolean isNested;
    private String nestedPath;
    private String innerHits;
    private boolean isChildren;
    private String childType;

    public SQLExpr getNameExpr() {
        return this.nameExpr;
    }

    public SQLExpr getValueExpr() {
        return this.valueExpr;
    }

    public Condition(Where.CONN conn) {
        super(conn);
    }

    public Condition(Where.CONN conn, String field, SQLExpr nameExpr, String condition, Object obj, SQLExpr valueExpr) throws SqlParseException {
        this(conn, field, nameExpr, condition, obj, valueExpr, null);
    }

    public Condition(Where.CONN conn, String field, SQLExpr nameExpr, OPEAR condition, Object obj, SQLExpr valueExpr) throws SqlParseException {
        this(conn, field, nameExpr, condition, obj, valueExpr, null);
    }

    public Condition(Where.CONN conn, String name, SQLExpr nameExpr, String oper, Object value, SQLExpr valueExpr, Object relationshipType) throws SqlParseException {
        super(conn);
        this.opear = null;
        this.name = name;
        this.value = value;
        this.nameExpr = nameExpr;
        this.valueExpr = valueExpr;
        this.relationshipType = relationshipType;
        if (this.relationshipType != null) {
            if (this.relationshipType instanceof NestedType) {
                NestedType nestedType = (NestedType)relationshipType;
                this.isNested = true;
                this.nestedPath = nestedType.path;
                this.innerHits = nestedType.getInnerHits();
                this.isChildren = false;
                this.childType = "";
            } else if (relationshipType instanceof ChildrenType) {
                ChildrenType childrenType = (ChildrenType)relationshipType;
                this.isNested = false;
                this.nestedPath = "";
                this.isChildren = true;
                this.childType = childrenType.childType;
            }
        } else {
            this.isNested = false;
            this.nestedPath = "";
            this.isChildren = false;
            this.childType = "";
        }
        switch (oper) {
            case "=": {
                this.opear = OPEAR.EQ;
                break;
            }
            case ">": {
                this.opear = OPEAR.GT;
                break;
            }
            case "<": {
                this.opear = OPEAR.LT;
                break;
            }
            case ">=": {
                this.opear = OPEAR.GTE;
                break;
            }
            case "<=": {
                this.opear = OPEAR.LTE;
                break;
            }
            case "<>": {
                this.opear = OPEAR.N;
                break;
            }
            case "LIKE": {
                this.opear = OPEAR.LIKE;
                break;
            }
            case "NOT": {
                this.opear = OPEAR.N;
                break;
            }
            case "NOT LIKE": {
                this.opear = OPEAR.NLIKE;
                break;
            }
            case "IS": {
                this.opear = OPEAR.IS;
                break;
            }
            case "IS NOT": {
                this.opear = OPEAR.ISN;
                break;
            }
            case "NOT IN": {
                this.opear = OPEAR.NIN;
                break;
            }
            case "IN": {
                this.opear = OPEAR.IN;
                break;
            }
            case "BETWEEN": {
                this.opear = OPEAR.BETWEEN;
                break;
            }
            case "NOT BETWEEN": {
                this.opear = OPEAR.NBETWEEN;
                break;
            }
            case "GEO_INTERSECTS": {
                this.opear = OPEAR.GEO_INTERSECTS;
                break;
            }
            case "GEO_BOUNDING_BOX": {
                this.opear = OPEAR.GEO_BOUNDING_BOX;
                break;
            }
            case "GEO_DISTANCE": {
                this.opear = OPEAR.GEO_DISTANCE;
                break;
            }
            case "GEO_POLYGON": {
                this.opear = OPEAR.GEO_POLYGON;
                break;
            }
            case "NESTED": {
                this.opear = OPEAR.NESTED_COMPLEX;
                break;
            }
            case "NOT NESTED": {
                this.opear = OPEAR.NNESTED_COMPLEX;
                break;
            }
            case "CHILDREN": {
                this.opear = OPEAR.CHILDREN_COMPLEX;
                break;
            }
            case "SCRIPT": {
                this.opear = OPEAR.SCRIPT;
                break;
            }
            default: {
                throw new SqlParseException(oper + " is err!");
            }
        }
    }

    public Condition(Where.CONN conn, String name, SQLExpr nameExpr, OPEAR oper, Object value, SQLExpr valueExpr, Object relationshipType) throws SqlParseException {
        super(conn);
        this.opear = null;
        this.nameExpr = nameExpr;
        this.valueExpr = valueExpr;
        this.name = name;
        this.value = value;
        this.opear = oper;
        this.relationshipType = relationshipType;
        if (this.relationshipType != null) {
            if (this.relationshipType instanceof NestedType) {
                NestedType nestedType = (NestedType)relationshipType;
                this.isNested = true;
                this.nestedPath = nestedType.path;
                this.innerHits = nestedType.getInnerHits();
                this.isChildren = false;
                this.childType = "";
            } else if (relationshipType instanceof ChildrenType) {
                ChildrenType childrenType = (ChildrenType)relationshipType;
                this.isNested = false;
                this.nestedPath = "";
                this.isChildren = true;
                this.childType = childrenType.childType;
            }
        } else {
            this.isNested = false;
            this.nestedPath = "";
            this.isChildren = false;
            this.childType = "";
        }
    }

    public String getOpertatorSymbol() throws SqlParseException {
        switch (this.opear) {
            case EQ: {
                return "==";
            }
            case GT: {
                return ">";
            }
            case LT: {
                return "<";
            }
            case GTE: {
                return ">=";
            }
            case LTE: {
                return "<=";
            }
            case N: {
                return "<>";
            }
            case IS: {
                return "==";
            }
            case ISN: {
                return "!=";
            }
        }
        throw new SqlParseException((Object)((Object)this.opear) + " is err!");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public OPEAR getOpear() {
        return this.opear;
    }

    public void setOpear(OPEAR opear) {
        this.opear = opear;
    }

    public Object getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(Object relationshipType) {
        this.relationshipType = relationshipType;
    }

    public boolean isNested() {
        return this.isNested;
    }

    public void setNested(boolean isNested) {
        this.isNested = isNested;
    }

    public String getNestedPath() {
        return this.nestedPath;
    }

    public void setNestedPath(String nestedPath) {
        this.nestedPath = nestedPath;
    }

    public String getInnerHits() {
        return this.innerHits;
    }

    public void setInnerHits(String innerHits) {
        this.innerHits = innerHits;
    }

    public boolean isChildren() {
        return this.isChildren;
    }

    public void setChildren(boolean isChildren) {
        this.isChildren = isChildren;
    }

    public String getChildType() {
        return this.childType;
    }

    public void setChildType(String childType) {
        this.childType = childType;
    }

    @Override
    public String toString() {
        String result = "";
        if (this.isNested()) {
            result = "nested condition ";
            if (this.getNestedPath() != null) {
                result = result + "on path:" + this.getNestedPath() + " ";
            }
            if (this.getInnerHits() != null) {
                result = result + "inner_hits:" + this.getInnerHits() + " ";
            }
        } else if (this.isChildren()) {
            result = "children condition ";
            if (this.getChildType() != null) {
                result = result + "on child: " + this.getChildType() + " ";
            }
        }
        result = this.value instanceof Object[] ? result + (Object)((Object)this.conn) + " " + this.name + " " + (Object)((Object)this.opear) + " " + Arrays.toString((Object[])this.value) : result + (Object)((Object)this.conn) + " " + this.name + " " + (Object)((Object)this.opear) + " " + this.value;
        return result;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        try {
            Condition clonedCondition = new Condition(this.getConn(), this.getName(), this.getNameExpr(), this.getOpear(), this.getValue(), this.getValueExpr(), this.getRelationshipType());
            return clonedCondition;
        }
        catch (SqlParseException sqlParseException) {
            return null;
        }
    }

    public static enum OPEAR {
        EQ,
        GT,
        LT,
        GTE,
        LTE,
        N,
        LIKE,
        NLIKE,
        REGEXP,
        NREGEXP,
        IS,
        ISN,
        IN,
        NIN,
        BETWEEN,
        NBETWEEN,
        GEO_INTERSECTS,
        GEO_BOUNDING_BOX,
        GEO_DISTANCE,
        GEO_POLYGON,
        IN_TERMS,
        TERM,
        IDS_QUERY,
        NESTED_COMPLEX,
        NNESTED_COMPLEX,
        CHILDREN_COMPLEX,
        SCRIPT,
        NIN_TERMS,
        NTERM;

        public static Map<String, OPEAR> methodNameToOpear;
        private static BiMap<OPEAR, OPEAR> negatives;

        public OPEAR negative() throws SqlParseException {
            OPEAR negative = (OPEAR)((Object)negatives.get((Object)this));
            OPEAR oPEAR = negative = negative != null ? negative : (OPEAR)((Object)negatives.inverse().get((Object)this));
            if (negative == null) {
                throw new SqlParseException("OPEAR negative not supported: " + (Object)((Object)this));
            }
            return negative;
        }

        static {
            methodNameToOpear = new HashMap<String, OPEAR>();
            methodNameToOpear.put("term", TERM);
            methodNameToOpear.put("matchterm", TERM);
            methodNameToOpear.put("match_term", TERM);
            methodNameToOpear.put("terms", IN_TERMS);
            methodNameToOpear.put("in_terms", IN_TERMS);
            methodNameToOpear.put("ids", IDS_QUERY);
            methodNameToOpear.put("ids_query", IDS_QUERY);
            methodNameToOpear.put("regexp", REGEXP);
            methodNameToOpear.put("regexp_query", REGEXP);
            negatives = HashBiMap.create((int)7);
            negatives.put((Object)EQ, (Object)N);
            negatives.put((Object)IN_TERMS, (Object)NIN_TERMS);
            negatives.put((Object)TERM, (Object)NTERM);
            negatives.put((Object)GT, (Object)LTE);
            negatives.put((Object)LT, (Object)GTE);
            negatives.put((Object)LIKE, (Object)NLIKE);
            negatives.put((Object)IS, (Object)ISN);
            negatives.put((Object)IN, (Object)NIN);
            negatives.put((Object)BETWEEN, (Object)NBETWEEN);
            negatives.put((Object)REGEXP, (Object)NREGEXP);
            negatives.put((Object)NESTED_COMPLEX, (Object)NNESTED_COMPLEX);
        }
    }
}

