/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql.parse;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLCaseExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import org.nlpcn.es4sql.Util;
import org.nlpcn.es4sql.domain.Condition;
import org.nlpcn.es4sql.domain.Where;
import org.nlpcn.es4sql.exception.SqlParseException;
import org.nlpcn.es4sql.parse.ScriptFilter;
import org.nlpcn.es4sql.parse.SqlParser;
import org.nlpcn.es4sql.parse.WhereParser;

public class CaseWhenParser {
    private SQLCaseExpr caseExpr;
    private String alias;
    private String tableAlias;

    public CaseWhenParser(SQLCaseExpr caseExpr, String alias, String tableAlias) {
        this.alias = alias;
        this.tableAlias = tableAlias;
        this.caseExpr = caseExpr;
    }

    public String parse() throws SqlParseException {
        ArrayList<String> result = new ArrayList<String>();
        for (SQLCaseExpr.Item item : this.caseExpr.getItems()) {
            SQLExpr conditionExpr = item.getConditionExpr();
            WhereParser parser = new WhereParser(new SqlParser(), conditionExpr);
            String scriptCode = this.explain(parser.findWhere());
            if (scriptCode.startsWith(" &&")) {
                scriptCode = scriptCode.substring(3);
            }
            if (result.size() == 0) {
                result.add("if(" + scriptCode + "){" + Util.getScriptValueWithQuote(item.getValueExpr(), "'") + "}");
                continue;
            }
            result.add("else if(" + scriptCode + "){" + Util.getScriptValueWithQuote(item.getValueExpr(), "'") + "}");
        }
        SQLExpr elseExpr = this.caseExpr.getElseExpr();
        if (elseExpr == null) {
            result.add("else { null }");
        } else {
            result.add("else {" + Util.getScriptValueWithQuote(elseExpr, "'") + "}");
        }
        return Joiner.on((String)" ").join(result);
    }

    public String parseCaseWhenInWhere(Object[] valueArr) throws SqlParseException {
        ArrayList<String> result = new ArrayList<String>();
        String TMP = "tmp";
        result.add("String " + TMP + " = '';");
        for (SQLCaseExpr.Item item : this.caseExpr.getItems()) {
            SQLExpr conditionExpr = item.getConditionExpr();
            WhereParser parser = new WhereParser(new SqlParser(), conditionExpr);
            String scriptCode = this.explain(parser.findWhere());
            if (scriptCode.startsWith(" &&")) {
                scriptCode = scriptCode.substring(3);
            }
            if (result.size() == 1) {
                result.add("if(" + scriptCode + "){" + TMP + "=" + Util.getScriptValueWithQuote(item.getValueExpr(), "'") + "}");
                continue;
            }
            result.add("else if(" + scriptCode + "){" + TMP + "=" + Util.getScriptValueWithQuote(item.getValueExpr(), "'") + "}");
        }
        SQLExpr elseExpr = this.caseExpr.getElseExpr();
        if (elseExpr == null) {
            result.add("else { null }");
        } else {
            result.add("else {" + TMP + "=" + Util.getScriptValueWithQuote(elseExpr, "'") + "}");
        }
        String judgeStatement = this.parseInNotInJudge(valueArr, TMP, "==", "||", true);
        result.add("return " + judgeStatement + ";");
        return Joiner.on((String)" ").join(result);
    }

    public String explain(Where where) throws SqlParseException {
        ArrayList<String> codes = new ArrayList<String>();
        while (where.getWheres().size() == 1) {
            where = where.getWheres().getFirst();
        }
        this.explainWhere(codes, where);
        String relation = where.getConn().name().equals("AND") ? " && " : " || ";
        return Joiner.on((String)relation).join(codes);
    }

    private void explainWhere(List<String> codes, Where where) throws SqlParseException {
        if (where instanceof Condition) {
            Condition condition = (Condition)where;
            if (condition.getValue() instanceof ScriptFilter) {
                codes.add(String.format("Function.identity().compose((o)->{%s}).apply(null)", ((ScriptFilter)condition.getValue()).getScript()));
            } else if (condition.getOpear() == Condition.OPEAR.BETWEEN) {
                Object[] objs = (Object[])condition.getValue();
                codes.add("(doc['" + condition.getName() + "'].value >= " + objs[0] + " && doc['" + condition.getName() + "'].value <=" + objs[1] + ")");
            } else if (condition.getOpear() == Condition.OPEAR.IN) {
                codes.add(this.parseInNotInJudge(condition, "==", "||", false));
            } else if (condition.getOpear() == Condition.OPEAR.NIN) {
                codes.add(this.parseInNotInJudge(condition, "!=", "&&", false));
            } else {
                SQLExpr nameExpr = condition.getNameExpr();
                SQLExpr valueExpr = condition.getValueExpr();
                if (valueExpr instanceof SQLNullExpr) {
                    codes.add("(doc['" + nameExpr.toString() + "'].empty)");
                } else {
                    codes.add("(" + Util.getScriptValueWithQuote(nameExpr, "'") + condition.getOpertatorSymbol() + Util.getScriptValueWithQuote(valueExpr, "'") + ")");
                }
            }
        } else {
            for (Where subWhere : where.getWheres()) {
                ArrayList<String> subCodes = new ArrayList<String>();
                this.explainWhere(subCodes, subWhere);
                String relation = subWhere.getConn().name().equals("AND") ? "&&" : "||";
                codes.add(Joiner.on((String)relation).join(subCodes));
            }
        }
    }

    private String parseInNotInJudge(Condition condition, String judgeOperator, String booleanOperator, boolean flag) throws SqlParseException {
        Object[] objArr = (Object[])condition.getValue();
        if (objArr.length == 0) {
            throw new SqlParseException("you should assign some value in bracket!!");
        }
        String script = "(";
        String template = "doc['" + condition.getName() + "'].value " + judgeOperator + " %s " + booleanOperator + " ";
        if (flag) {
            template = condition.getName() + " " + judgeOperator + " %s " + booleanOperator + " ";
        }
        for (Object obj : objArr) {
            script = script + String.format(template, this.parseInNotInValueWithQuote(obj));
        }
        script = script.substring(0, script.lastIndexOf(booleanOperator));
        script = script + ")";
        return script;
    }

    private String parseInNotInJudge(Object value, String fieldName, String judgeOperator, String booleanOperator, boolean flag) throws SqlParseException {
        Condition cond = new Condition(null);
        cond.setValue(value);
        cond.setName(fieldName);
        return this.parseInNotInJudge(cond, judgeOperator, booleanOperator, flag);
    }

    private Object parseInNotInValueWithQuote(Object obj) {
        if (obj instanceof String) {
            return "'" + obj + "'";
        }
        return obj;
    }
}

