/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql.parse;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLAggregateOption;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLCaseExpr;
import com.alibaba.druid.sql.ast.expr.SQLCastExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.util.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.elasticsearch.common.collect.Tuple;
import org.nlpcn.es4sql.SQLFunctions;
import org.nlpcn.es4sql.Util;
import org.nlpcn.es4sql.domain.Field;
import org.nlpcn.es4sql.domain.KVValue;
import org.nlpcn.es4sql.domain.MethodField;
import org.nlpcn.es4sql.domain.Where;
import org.nlpcn.es4sql.exception.SqlParseException;
import org.nlpcn.es4sql.parse.CaseWhenParser;
import org.nlpcn.es4sql.parse.CastParser;
import org.nlpcn.es4sql.parse.ChildrenType;
import org.nlpcn.es4sql.parse.NestedType;
import org.nlpcn.es4sql.parse.SqlParser;
import org.nlpcn.es4sql.parse.WhereParser;

public class FieldMaker {
    public static Field makeField(SQLExpr expr, String alias, String tableAlias) throws SqlParseException {
        if (expr instanceof SQLIdentifierExpr || expr instanceof SQLPropertyExpr || expr instanceof SQLVariantRefExpr) {
            return FieldMaker.handleIdentifier(expr, alias, tableAlias);
        }
        if (expr instanceof SQLQueryExpr) {
            throw new SqlParseException("unknow field name : " + expr);
        }
        if (expr instanceof SQLBinaryOpExpr) {
            return FieldMaker.makeField((SQLExpr)FieldMaker.makeBinaryMethodField((SQLBinaryOpExpr)expr, alias, true), alias, tableAlias);
        }
        if (!(expr instanceof SQLAllColumnExpr)) {
            if (expr instanceof SQLMethodInvokeExpr) {
                SQLMethodInvokeExpr mExpr = (SQLMethodInvokeExpr)expr;
                String methodName = mExpr.getMethodName();
                if (methodName.equalsIgnoreCase("nested") || methodName.equalsIgnoreCase("reverse_nested")) {
                    NestedType nestedType = new NestedType();
                    if (nestedType.tryFillFromExpr((SQLExpr)mExpr)) {
                        return FieldMaker.handleIdentifier(nestedType, alias, tableAlias);
                    }
                } else if (methodName.equalsIgnoreCase("children")) {
                    ChildrenType childrenType = new ChildrenType();
                    if (childrenType.tryFillFromExpr((SQLExpr)mExpr)) {
                        return FieldMaker.handleIdentifier(childrenType, alias, tableAlias);
                    }
                } else if (methodName.equalsIgnoreCase("filter")) {
                    return FieldMaker.makeFilterMethodField(mExpr, alias);
                }
                return FieldMaker.makeMethodField(methodName, mExpr.getParameters(), null, alias, tableAlias, true);
            }
            if (expr instanceof SQLAggregateExpr) {
                SQLAggregateExpr sExpr = (SQLAggregateExpr)expr;
                return FieldMaker.makeMethodField(sExpr.getMethodName(), sExpr.getArguments(), sExpr.getOption(), alias, tableAlias, true);
            }
            if (expr instanceof SQLCaseExpr) {
                String scriptCode = new CaseWhenParser((SQLCaseExpr)expr, alias, tableAlias).parse();
                ArrayList<KVValue> methodParameters = new ArrayList<KVValue>();
                if (null != alias && alias.trim().length() != 0) {
                    methodParameters.add(new KVValue(alias));
                }
                methodParameters.add(new KVValue(scriptCode));
                return new MethodField("script", methodParameters, null, alias);
            }
            if (expr instanceof SQLCastExpr) {
                SQLCastExpr castExpr = (SQLCastExpr)expr;
                if (alias == null) {
                    alias = "cast_" + castExpr.getExpr().toString();
                }
                String scriptCode = new CastParser(castExpr, alias, tableAlias).parse(true);
                ArrayList<KVValue> methodParameters = new ArrayList<KVValue>();
                methodParameters.add(new KVValue(alias));
                methodParameters.add(new KVValue(scriptCode));
                return new MethodField("script", methodParameters, null, alias);
            }
            throw new SqlParseException("unknown field name : " + expr);
        }
        return null;
    }

    private static Object getScriptValue(SQLExpr expr) throws SqlParseException {
        return Util.getScriptValue(expr);
    }

    private static Field makeScriptMethodField(SQLBinaryOpExpr binaryExpr, String alias, String tableAlias) throws SqlParseException {
        ArrayList<SQLExpr> params = new ArrayList<SQLExpr>();
        String scriptFieldAlias = alias == null || alias.equals("") ? binaryExpr.toString() : alias;
        params.add((SQLExpr)new SQLCharExpr(scriptFieldAlias));
        Object left = FieldMaker.getScriptValue(binaryExpr.getLeft());
        Object right = FieldMaker.getScriptValue(binaryExpr.getRight());
        String script = String.format("%s %s %s", left, binaryExpr.getOperator().getName(), right);
        params.add((SQLExpr)new SQLCharExpr(script));
        return FieldMaker.makeMethodField("script", params, null, null, tableAlias, false);
    }

    private static Field makeFilterMethodField(SQLMethodInvokeExpr filterMethod, String alias) throws SqlParseException {
        List parameters = filterMethod.getParameters();
        int parametersSize = parameters.size();
        if (parametersSize != 1 && parametersSize != 2) {
            throw new SqlParseException("filter group by field should only have one or 2 parameters filter(Expr) or filter(name,Expr)");
        }
        String filterAlias = filterMethod.getMethodName();
        SQLExpr exprToCheck = null;
        if (parametersSize == 1) {
            exprToCheck = (SQLExpr)parameters.get(0);
            filterAlias = "filter(" + exprToCheck.toString().replaceAll("\n", " ") + ")";
        }
        if (parametersSize == 2) {
            filterAlias = Util.extendedToString((SQLExpr)parameters.get(0));
            exprToCheck = (SQLExpr)parameters.get(1);
        }
        Where where = Where.newInstance();
        new WhereParser(new SqlParser()).parseWhere(exprToCheck, where);
        if (where.getWheres().size() == 0) {
            throw new SqlParseException("unable to parse filter where.");
        }
        ArrayList<KVValue> methodParameters = new ArrayList<KVValue>();
        methodParameters.add(new KVValue("where", where));
        methodParameters.add(new KVValue("alias", filterAlias + "@FILTER"));
        return new MethodField("filter", methodParameters, null, alias);
    }

    private static Field handleIdentifier(NestedType nestedType, String alias, String tableAlias) throws SqlParseException {
        Field field = FieldMaker.handleIdentifier((SQLExpr)new SQLIdentifierExpr(nestedType.field), alias, tableAlias);
        field.setNested(nestedType);
        field.setChildren(null);
        return field;
    }

    private static Field handleIdentifier(ChildrenType childrenType, String alias, String tableAlias) throws SqlParseException {
        Field field = FieldMaker.handleIdentifier((SQLExpr)new SQLIdentifierExpr(childrenType.field), alias, tableAlias);
        field.setNested(null);
        field.setChildren(childrenType);
        return field;
    }

    public static SQLMethodInvokeExpr makeBinaryMethodField(SQLBinaryOpExpr expr, String alias, boolean first) throws SqlParseException {
        ArrayList<SQLCharExpr> params = new ArrayList<SQLCharExpr>();
        String scriptFieldAlias = first && (alias == null || alias.equals("")) ? "field_" + SQLFunctions.random() : alias;
        params.add(new SQLCharExpr(scriptFieldAlias));
        switch (expr.getOperator()) {
            case Add: {
                return FieldMaker.convertBinaryOperatorToMethod("add", expr);
            }
            case Multiply: {
                return FieldMaker.convertBinaryOperatorToMethod("multiply", expr);
            }
            case Divide: {
                return FieldMaker.convertBinaryOperatorToMethod("divide", expr);
            }
            case Modulus: {
                return FieldMaker.convertBinaryOperatorToMethod("modulus", expr);
            }
            case Subtract: {
                return FieldMaker.convertBinaryOperatorToMethod("subtract", expr);
            }
        }
        throw new SqlParseException(expr.getOperator().getName() + " is not support");
    }

    private static SQLMethodInvokeExpr convertBinaryOperatorToMethod(String operator, SQLBinaryOpExpr expr) {
        SQLMethodInvokeExpr methodInvokeExpr = new SQLMethodInvokeExpr(operator, null);
        methodInvokeExpr.addParameter(expr.getLeft());
        methodInvokeExpr.addParameter(expr.getRight());
        return methodInvokeExpr;
    }

    private static Field handleIdentifier(SQLExpr expr, String alias, String tableAlias) throws SqlParseException {
        String aliasPrefix;
        String name;
        String newFieldName = name = expr.toString().replace("`", "");
        Field field = null;
        if (tableAlias != null && name.startsWith(aliasPrefix = tableAlias + ".")) {
            newFieldName = name.replaceFirst(aliasPrefix, "");
            field = new Field(newFieldName, alias);
        }
        if (tableAlias == null) {
            field = new Field(newFieldName, alias);
        }
        if (alias != null && !alias.equals(name) && !Util.isFromJoinOrUnionTable(expr)) {
            ArrayList paramers = Lists.newArrayList();
            paramers.add(new SQLCharExpr(alias));
            paramers.add(new SQLCharExpr("doc['" + newFieldName + "'].value"));
            field = FieldMaker.makeMethodField("script", paramers, null, alias, tableAlias, true);
        }
        return field;
    }

    public static MethodField makeMethodField(String name, List<SQLExpr> arguments, SQLAggregateOption option, String alias, String tableAlias, boolean first) throws SqlParseException {
        LinkedList<KVValue> paramers = new LinkedList<KVValue>();
        String finalMethodName = name;
        String binaryOperatorName = null;
        ArrayList<String> binaryOperatorNames = new ArrayList<String>();
        for (SQLExpr object : arguments) {
            String value;
            String key;
            MethodField mf;
            if (object instanceof SQLBinaryOpExpr) {
                SQLBinaryOpExpr binaryOpExpr = (SQLBinaryOpExpr)object;
                if (SQLFunctions.buildInFunctions.contains(binaryOpExpr.getOperator().toString().toLowerCase())) {
                    SQLMethodInvokeExpr mExpr = FieldMaker.makeBinaryMethodField(binaryOpExpr, alias, first);
                    mf = FieldMaker.makeMethodField(mExpr.getMethodName(), mExpr.getParameters(), null, null, tableAlias, false);
                    key = mf.getParams().get(0).toString();
                    value = mf.getParams().get(1).toString();
                    paramers.add(new KVValue(key, new SQLCharExpr(first && !SQLFunctions.buildInFunctions.contains(finalMethodName) ? String.format("%s;return %s;", value, key) : value)));
                    continue;
                }
                binaryOperatorName = binaryOpExpr.getOperator().getName().trim();
                if (SQLFunctions.binaryOperators.contains(binaryOperatorName)) {
                    String methodName;
                    binaryOperatorNames.add(binaryOperatorName);
                    SQLExpr right = binaryOpExpr.getRight();
                    Object value2 = Util.expr2Object(right);
                    if (binaryOpExpr.getParent() instanceof SQLMethodInvokeExpr && ("if".equals(methodName = ((SQLMethodInvokeExpr)binaryOpExpr.getParent()).getMethodName()) || "case".equals(methodName) || "case_new".equals(methodName))) {
                        value2 = Util.expr2Object(right, "'");
                    }
                    paramers.add(new KVValue(binaryOpExpr.getLeft().toString(), value2));
                    continue;
                }
                paramers.add(new KVValue("script", FieldMaker.makeScriptMethodField(binaryOpExpr, null, tableAlias)));
                continue;
            }
            if (object instanceof SQLMethodInvokeExpr) {
                KVValue script;
                SQLMethodInvokeExpr mExpr = (SQLMethodInvokeExpr)object;
                String methodName = mExpr.getMethodName().toLowerCase();
                if (methodName.equals("script")) {
                    script = new KVValue("script", FieldMaker.makeMethodField(mExpr.getMethodName(), mExpr.getParameters(), null, alias, tableAlias, true));
                    paramers.add(script);
                    continue;
                }
                if (methodName.equals("nested") || methodName.equals("reverse_nested")) {
                    NestedType nestedType = new NestedType();
                    if (!nestedType.tryFillFromExpr(object)) {
                        throw new SqlParseException("failed parsing nested expr " + object);
                    }
                    paramers.add(new KVValue("nested", nestedType));
                    continue;
                }
                if (methodName.equals("children")) {
                    ChildrenType childrenType = new ChildrenType();
                    if (!childrenType.tryFillFromExpr(object)) {
                        throw new SqlParseException("failed parsing children expr " + object);
                    }
                    paramers.add(new KVValue("children", childrenType));
                    continue;
                }
                if (SQLFunctions.buildInFunctions.contains(methodName)) {
                    if (mExpr.getParent() instanceof SQLAggregateExpr) {
                        script = new KVValue("script", FieldMaker.makeMethodField(mExpr.getMethodName(), mExpr.getParameters(), null, alias, tableAlias, true));
                        paramers.add(script);
                        continue;
                    }
                    mf = FieldMaker.makeMethodField(methodName, mExpr.getParameters(), null, null, tableAlias, false);
                    key = mf.getParams().get(0).toString();
                    value = mf.getParams().get(1).toString();
                    paramers.add(new KVValue(key, new SQLCharExpr(first && !SQLFunctions.buildInFunctions.contains(finalMethodName) ? String.format("%s;return %s;", value, key) : value)));
                    continue;
                }
                throw new SqlParseException("only support script/nested/children as inner functions");
            }
            if (object instanceof SQLCaseExpr) {
                String scriptCode = new CaseWhenParser((SQLCaseExpr)object, alias, tableAlias).parse();
                paramers.add(new KVValue("script", new SQLCharExpr(scriptCode)));
                continue;
            }
            if (object instanceof SQLCastExpr) {
                CastParser castParser = new CastParser((SQLCastExpr)object, alias, tableAlias);
                String scriptCode = castParser.parse(false);
                paramers.add(new KVValue(castParser.getName(), new SQLCharExpr(scriptCode)));
                continue;
            }
            paramers.add(new KVValue(Util.removeTableAilasFromField(object, tableAlias)));
        }
        if (SQLFunctions.buildInFunctions.contains(finalMethodName.toLowerCase())) {
            if (alias == null && first) {
                alias = "field_" + SQLFunctions.random();
            }
            Tuple<String, String> newFunctions = null;
            try {
                newFunctions = SQLFunctions.function(finalMethodName, paramers, ((KVValue)paramers.get((int)0)).key, first, binaryOperatorName, binaryOperatorNames);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            paramers.clear();
            if (!first) {
                paramers.add(new KVValue(newFunctions.v1()));
            } else if (((String)newFunctions.v1()).toLowerCase().contains("if")) {
                if (!StringUtils.isEmpty((String)alias) && !alias.startsWith("field_")) {
                    paramers.add(new KVValue(alias));
                } else {
                    paramers.add(new KVValue(newFunctions.v1()));
                }
            } else {
                paramers.add(new KVValue(alias));
            }
            paramers.add(new KVValue(newFunctions.v2()));
            finalMethodName = "script";
        }
        if (first) {
            LinkedList<KVValue> tempParamers = new LinkedList<KVValue>();
            for (KVValue temp : paramers) {
                if (temp.value instanceof SQLExpr) {
                    tempParamers.add(new KVValue(temp.key, Util.expr2Object((SQLExpr)temp.value)));
                    continue;
                }
                tempParamers.add(new KVValue(temp.key, temp.value));
            }
            paramers.clear();
            paramers.addAll(tempParamers);
        }
        return new MethodField(finalMethodName, paramers, option == null ? null : option.name(), alias);
    }
}

