/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchScrollAction;
import org.elasticsearch.action.search.SearchScrollRequestBuilder;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.NestedSortBuilder;
import org.elasticsearch.search.sort.ScriptSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.nlpcn.es4sql.domain.Field;
import org.nlpcn.es4sql.domain.KVValue;
import org.nlpcn.es4sql.domain.MethodField;
import org.nlpcn.es4sql.domain.Order;
import org.nlpcn.es4sql.domain.Select;
import org.nlpcn.es4sql.domain.Where;
import org.nlpcn.es4sql.domain.hints.Hint;
import org.nlpcn.es4sql.domain.hints.HintType;
import org.nlpcn.es4sql.exception.SqlParseException;
import org.nlpcn.es4sql.query.QueryAction;
import org.nlpcn.es4sql.query.SqlElasticSearchRequestBuilder;
import org.nlpcn.es4sql.query.maker.QueryMaker;

public class DefaultQueryAction
extends QueryAction {
    private final Select select;
    private SearchRequestBuilder request;
    private List<String> fieldNames = new LinkedList<String>();

    public DefaultQueryAction(Client client, Select select) {
        super(client, select);
        this.select = select;
    }

    public void intialize(SearchRequestBuilder request) throws SqlParseException {
        this.request = request;
    }

    @Override
    public SqlElasticSearchRequestBuilder explain() throws SqlParseException {
        Hint scrollHint = null;
        for (Hint hint : this.select.getHints()) {
            if (hint.getType() != HintType.USE_SCROLL) continue;
            scrollHint = hint;
            break;
        }
        if (scrollHint != null && scrollHint.getParams()[0] instanceof String) {
            return new SqlElasticSearchRequestBuilder((ActionRequestBuilder)new SearchScrollRequestBuilder((ElasticsearchClient)this.client, SearchScrollAction.INSTANCE, (String)scrollHint.getParams()[0]).setScroll(new TimeValue((long)((Integer)scrollHint.getParams()[1]).intValue())));
        }
        this.request = new SearchRequestBuilder((ElasticsearchClient)this.client, SearchAction.INSTANCE);
        this.setIndicesAndTypes();
        this.setFields(this.select.getFields());
        this.setWhere(this.select.getWhere());
        this.setSorts(this.select.getOrderBys());
        this.setLimit(this.select.getOffset(), this.select.getRowCount());
        if (scrollHint != null) {
            if (!this.select.isOrderdSelect()) {
                this.request.addSort("_doc", SortOrder.ASC);
            }
            this.request.setSize(((Integer)scrollHint.getParams()[0]).intValue()).setScroll(new TimeValue((long)((Integer)scrollHint.getParams()[1]).intValue()));
        } else {
            this.request.setSearchType(SearchType.DFS_QUERY_THEN_FETCH);
        }
        this.updateRequestWithIndexAndRoutingOptions(this.select, this.request);
        this.updateRequestWithHighlight(this.select, this.request);
        this.updateRequestWithCollapse(this.select, this.request);
        this.updateRequestWithPostFilter(this.select, this.request);
        this.updateRequestWithStats(this.select, this.request);
        this.updateRequestWithPreference(this.select, this.request);
        this.updateRequestWithTrackTotalHits(this.select, this.request);
        this.updateRequestWithTimeout(this.select, this.request);
        this.updateRequestWithIndicesOptions(this.select, this.request);
        this.updateRequestWithMinScore(this.select, this.request);
        SqlElasticSearchRequestBuilder sqlElasticRequestBuilder = new SqlElasticSearchRequestBuilder((ActionRequestBuilder)this.request);
        return sqlElasticRequestBuilder;
    }

    private void setIndicesAndTypes() {
        this.request.setIndices(this.query.getIndexArr());
        String[] typeArr = this.query.getTypeArr();
        if (typeArr != null) {
            this.request.setTypes(typeArr);
        }
    }

    public void setFields(List<Field> fields) throws SqlParseException {
        if (this.select.getFields().size() > 0) {
            ArrayList<String> includeFields = new ArrayList<String>();
            ArrayList<String> excludeFields = new ArrayList<String>();
            for (Field field : fields) {
                if (field instanceof MethodField) {
                    MethodField method = (MethodField)field;
                    if (method.getName().toLowerCase().equals("script")) {
                        this.handleScriptField(method);
                        continue;
                    }
                    if (method.getName().equalsIgnoreCase("include")) {
                        for (KVValue kvValue : method.getParams()) {
                            String f = kvValue.value.toString();
                            this.fieldNames.add(f);
                            includeFields.add(f);
                        }
                        continue;
                    }
                    if (method.getName().equalsIgnoreCase("exclude")) {
                        for (KVValue kvValue : method.getParams()) {
                            excludeFields.add(kvValue.value.toString());
                        }
                        continue;
                    }
                    if (!method.getName().equalsIgnoreCase("docvalue")) continue;
                    this.handleDocvalueField(method);
                    continue;
                }
                if (field == null) continue;
                this.fieldNames.add(field.getName());
                includeFields.add(field.getName());
            }
            this.request.setFetchSource(includeFields.toArray(new String[includeFields.size()]), excludeFields.toArray(new String[excludeFields.size()]));
        }
    }

    private void handleScriptField(MethodField method) throws SqlParseException {
        List<KVValue> params = method.getParams();
        if (params.size() == 2) {
            String f = params.get((int)0).value.toString();
            this.fieldNames.add(f);
            this.request.addScriptField(f, new Script(params.get((int)1).value.toString()));
        } else if (params.size() == 3) {
            String f = params.get((int)0).value.toString();
            this.fieldNames.add(f);
            this.request.addScriptField(f, new Script(ScriptType.INLINE, params.get((int)1).value.toString(), params.get((int)2).value.toString(), Collections.emptyMap()));
        } else {
            throw new SqlParseException("scripted_field only allows script(name,script) or script(name,lang,script)");
        }
    }

    private void handleDocvalueField(MethodField method) throws SqlParseException {
        List<KVValue> params = method.getParams();
        if (params.size() == 1) {
            String f = params.get((int)0).value.toString();
            this.fieldNames.add(f);
            this.request.addDocValueField(f);
        } else if (params.size() == 2) {
            String f = params.get((int)0).value.toString();
            this.fieldNames.add(f);
            this.request.addDocValueField(f, params.get((int)1).value.toString());
        } else {
            throw new SqlParseException("docvalue_fields only allows docvalue(field) or docvalue(field,format)");
        }
    }

    private void setWhere(Where where) throws SqlParseException {
        if (where != null) {
            BoolQueryBuilder boolQuery = QueryMaker.explan(where, this.select.isQuery);
            this.request.setQuery((QueryBuilder)boolQuery);
        }
    }

    private void setSorts(List<Order> orderBys) {
        for (Order order : orderBys) {
            if (order.getNestedPath() != null) {
                this.request.addSort((SortBuilder)((FieldSortBuilder)SortBuilders.fieldSort((String)order.getName()).order(SortOrder.valueOf((String)order.getType()))).setNestedSort(new NestedSortBuilder(order.getNestedPath())));
                continue;
            }
            if (order.getName().contains("script(")) {
                String scriptStr = order.getName().substring("script(".length(), order.getName().length() - 1);
                Script script = new Script(scriptStr);
                ScriptSortBuilder scriptSortBuilder = SortBuilders.scriptSort((Script)script, (ScriptSortBuilder.ScriptSortType)order.getScriptSortType());
                scriptSortBuilder = (ScriptSortBuilder)scriptSortBuilder.order(SortOrder.valueOf((String)order.getType()));
                this.request.addSort((SortBuilder)scriptSortBuilder);
                continue;
            }
            this.request.addSort(order.getName(), SortOrder.valueOf((String)order.getType()));
        }
    }

    private void setLimit(int from, int size) {
        this.request.setFrom(from);
        if (size > -1) {
            this.request.setSize(size);
        }
    }

    public SearchRequestBuilder getRequestBuilder() {
        return this.request;
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }
}

