/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql.query.join;

import org.elasticsearch.index.query.BoolQueryBuilder;
import org.nlpcn.es4sql.domain.Where;
import org.nlpcn.es4sql.exception.SqlParseException;
import org.nlpcn.es4sql.query.join.JoinRequestBuilder;
import org.nlpcn.es4sql.query.maker.QueryMaker;

public class NestedLoopsElasticRequestBuilder
extends JoinRequestBuilder {
    private Where connectedWhere;
    private int multiSearchMaxSize = 100;

    @Override
    public String explain() {
        String baseExplain = super.explain();
        Where where = this.connectedWhere;
        BoolQueryBuilder explan = null;
        try {
            if (where != null) {
                explan = QueryMaker.explan(where, false);
            }
        }
        catch (SqlParseException sqlParseException) {
            // empty catch block
        }
        String conditions = explan == null ? "Could not parse conditions" : explan.toString();
        String nestedExplain = "Nested Loops \n run first query , and for each result run second query with additional conditions :\n" + conditions + "\n" + baseExplain;
        return nestedExplain;
    }

    public int getMultiSearchMaxSize() {
        return this.multiSearchMaxSize;
    }

    public void setMultiSearchMaxSize(int multiSearchMaxSize) {
        this.multiSearchMaxSize = multiSearchMaxSize;
    }

    public Where getConnectedWhere() {
        return this.connectedWhere;
    }

    public void setConnectedWhere(Where connectedWhere) {
        this.connectedWhere = connectedWhere;
    }
}

