/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.es4sql.query.maker;

import java.io.IOException;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.InnerHitBuilder;
import org.elasticsearch.index.query.NestedQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.join.query.JoinQueryBuilders;
import org.nlpcn.es4sql.domain.Condition;
import org.nlpcn.es4sql.domain.Where;
import org.nlpcn.es4sql.exception.SqlParseException;
import org.nlpcn.es4sql.query.maker.Maker;

public class QueryMaker
extends Maker {
    public static BoolQueryBuilder explan(Where where) throws SqlParseException {
        return QueryMaker.explan(where, true);
    }

    public static BoolQueryBuilder explan(Where where, boolean isQuery) throws SqlParseException {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        while (where.getWheres().size() == 1) {
            where = where.getWheres().getFirst();
        }
        new QueryMaker().explanWhere(boolQuery, where);
        if (isQuery) {
            return boolQuery;
        }
        return QueryBuilders.boolQuery().filter((QueryBuilder)boolQuery);
    }

    private QueryMaker() {
        super(true);
    }

    private void explanWhere(BoolQueryBuilder boolQuery, Where where) throws SqlParseException {
        if (where instanceof Condition) {
            this.addSubQuery(boolQuery, where, (QueryBuilder)this.make((Condition)where));
        } else {
            BoolQueryBuilder subQuery = QueryBuilders.boolQuery();
            this.addSubQuery(boolQuery, where, (QueryBuilder)subQuery);
            for (Where subWhere : where.getWheres()) {
                this.explanWhere(subQuery, subWhere);
            }
        }
    }

    private void addSubQuery(BoolQueryBuilder boolQuery, Where where, QueryBuilder subQuery) {
        if (where instanceof Condition) {
            Condition condition = (Condition)where;
            if (condition.isNested()) {
                boolean isNestedQuery = subQuery instanceof NestedQueryBuilder;
                InnerHitBuilder ihb = null;
                if (condition.getInnerHits() != null) {
                    try (XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, condition.getInnerHits());){
                        ihb = InnerHitBuilder.fromXContent((XContentParser)parser);
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("couldn't parse inner_hits: " + e.getMessage(), e);
                    }
                }
                if ("missing".equalsIgnoreCase(String.valueOf(condition.getValue())) && (condition.getOpear() == Condition.OPEAR.IS || condition.getOpear() == Condition.OPEAR.EQ)) {
                    NestedQueryBuilder q;
                    NestedQueryBuilder nestedQueryBuilder = q = isNestedQuery ? (NestedQueryBuilder)subQuery : QueryBuilders.nestedQuery((String)condition.getNestedPath(), (QueryBuilder)QueryBuilders.boolQuery().mustNot(subQuery), (ScoreMode)ScoreMode.None);
                    if (ihb != null) {
                        q.innerHit(ihb);
                    }
                    boolQuery.mustNot((QueryBuilder)q);
                    return;
                }
                if (condition.getOpear() == Condition.OPEAR.NNESTED_COMPLEX) {
                    if (ihb != null) {
                        ((NestedQueryBuilder)NestedQueryBuilder.class.cast(subQuery)).innerHit(ihb);
                    }
                    boolQuery.mustNot(subQuery);
                    return;
                }
                if (!isNestedQuery) {
                    subQuery = QueryBuilders.nestedQuery((String)condition.getNestedPath(), (QueryBuilder)subQuery, (ScoreMode)ScoreMode.None);
                }
                if (ihb != null) {
                    ((NestedQueryBuilder)subQuery).innerHit(ihb);
                }
            } else if (condition.isChildren()) {
                subQuery = JoinQueryBuilders.hasChildQuery((String)condition.getChildType(), (QueryBuilder)subQuery, (ScoreMode)ScoreMode.None);
            }
        }
        if (where.getConn() == Where.CONN.AND) {
            boolQuery.must(subQuery);
        } else {
            boolQuery.should(subQuery);
        }
    }
}

